/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;
import ru.bitel.bgbilling.modules.bill.server.event.BillCreatedEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@WebAction(title="\u0421\u0447\u0435\u0442\u0430")
public class ActionBill
extends AbstractAction {
    public ActionBill() {
        super("bill");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432")
    public void list() throws BGException {
        Page page = this.getPage();
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);){
            int organizationId = Utils.parseInt((String)contractModuleConfigDao.get(this.contractId, "organization.id"), (int)0);
            this.setResultParam("accountList", new AccountManager(this.con, this.moduleId).getBankAccountList(organizationId, true));
            this.setResultParam("billList", new BillManager(this.con, this.moduleId).getBillList(page, this.contractId));
        }
        this.setResultParam("page", page);
        this.requestDispatcher(this.moduleName, "bill_list");
    }

    @WebOperation(title="\u041d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442")
    public void addBill() throws Exception {
        int type = this.req.getInt("billType", -1);
        int bankAccountId = this.req.getInt("billAccount", 0);
        boolean create = Utils.notBlankString((String)this.req.get("create"));
        GregorianCalendar now = new GregorianCalendar();
        int yy = now.get(1);
        int mm = now.get(2);
        this.setResultParam("billTypeId", type);
        this.setResultParam("billAccountId", bankAccountId);
        if (create) {
            this.setResultParam("contentType", ActionResultContentType.binary);
            BigDecimal billSumm = BigDecimal.ZERO;
            ArrayList<PositionValue> posList = new ArrayList<PositionValue>();
            Map pairs = this.context.getRequest().getParameterMap();
            for (Object key : pairs.keySet()) {
                BigDecimal summ;
                String[] name_id;
                String keyString = (String)key;
                String value = ((String[])pairs.get(key))[0];
                if (!keyString.startsWith("name_") || (name_id = keyString.split("_")).length != 2 || (summ = Utils.parseBigDecimal((String)this.req.get("summ_" + name_id[1], ""), (BigDecimal)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) <= 0) continue;
                String unit = this.req.get("unit_" + name_id[1]);
                PositionValue positionValue = new PositionValue();
                positionValue.setPositionId(Utils.parseInt((String)name_id[1]));
                positionValue.setName(value);
                positionValue.setSum(summ);
                positionValue.setUnit(Utils.maskNull((String)unit));
                positionValue.setInSumm(true);
                positionValue.setQuantity(Utils.parseBigDecimal((String)this.moduleSetup.get("web.bill.generate.position.quantity", "0"), (BigDecimal)BigDecimal.ZERO));
                posList.add(positionValue);
                billSumm = billSumm.add(summ);
            }
            Bill bill = Bill.builder().setContractId(this.contractId).setTypeId(type).setAccountId(bankAccountId).setBankAccount(new AccountManager(this.con, this.moduleId).getBankAccount(bankAccountId)).setYy(yy).setMm(mm).setSumm(billSumm).setCreateDate(new Date()).setUserId(-1).setNpid(new DocTypeManager(this.con, this.moduleId).getType(type).getNpid()).build();
            try {
                int billId = new BillManager(this.con, this.moduleId).addBillDoc(this.userId, bill, posList, Collections.emptyList());
                this.context.publishAfterCommit((Event)new BillCreatedEvent(this.userId, this.moduleId, this.contractId, billId));
                this.con.commit();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            this.list();
        } else if (type == 0) {
            this.requestDispatcher(this.moduleName, "bill_add");
        } else if (type > 0) {
            DocType docType = new DocTypeManager(this.con, this.moduleId).getType(type);
            ContractManager cm = new ContractManager(this.con);
            TemplateBill templateBill = new TemplateBill();
            PositionDao positionDao = new PositionDao(this.con, this.moduleId, docType.getDocumentType());
            new TemplateBillManager(this.con, this.moduleId, docType.getDocumentType()).getTemplatePositions(cm, templateBill, new GregorianCalendar(yy, mm, 1), this.contractId, String.valueOf(this.contractId), null, docType, positionDao.getPositionMap());
            this.setResultParam("pageTitle", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430");
            this.setResultParam("billPositionList", templateBill.getPositionList());
            this.setResultParam("billSubList", templateBill.getSubBillList());
            this.requestDispatcher(this.moduleName, "bill_add");
        } else {
            ArrayList<DocType> billTypeList = new ArrayList<DocType>();
            Set allowedWebBillTypes = Utils.toIntegerSet((String)this.moduleSetup.get("allowed.web.bill.types", null));
            for (DocType docType : new ContractDocTypeManager(this.con, this.moduleId).getContractDocTypeList(this.contractId, DocumentType.BILL)) {
                if (!allowedWebBillTypes.contains(docType.getId())) continue;
                billTypeList.add(docType);
            }
            this.setResultParam("billTypeList", billTypeList);
            try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);){
                int organizationId = Utils.parseInt((String)contractModuleConfigDao.get(this.contractId, "organization.id"), (int)0);
                this.setResultParam("accountList", new AccountManager(this.con, this.moduleId).getBankAccountList(organizationId, true));
            }
            this.requestDispatcher(this.moduleName, "bill_add");
        }
    }

    @WebOperation(title="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430")
    public void delete() throws BGException {
        int id = this.req.getInt("id", 0);
        new BillManager(this.con, this.moduleId).deleteBill(this.contractId, id, false);
    }
}

