/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.service.action;

import bitel.billing.server.service.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.GetErrorLogModulesEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

public class ActionErrorLogList
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int mid = this.getIntParameter("mid", -1);
        Date date1 = this.getDateParameter("date1", null);
        Date date2 = this.getDateParameter("date2", null);
        Page page = this.getPage();
        int sourceid = this.getIntParameter("sourceid", -1);
        if (mid == -1) {
            Element services = this.createElement(this.rootNode, "services");
            this.addListItem(services, "service", "-1", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0436\u0443\u0440\u043d\u0430\u043b");
            this.addListItem(services, "service", "0", "\u041e\u0431\u0449\u0438\u0439 \u0436\u0443\u0440\u043d\u0430\u043b");
            GetErrorLogModulesEvent event = new GetErrorLogModulesEvent();
            event = EventProcessor.getInstance().request(event);
            for (BGModule mod : event.getModulesList()) {
                this.addListItem(services, "service", "" + mod.getId(), mod.getTitle());
            }
        } else {
            PreparedStatement ps;
            String yyyymm = TimeUtils.format((Date)(date1 == null ? new Date() : date1), (String)"yyyyMM");
            String tableName = (mid == 0 ? "contract_error_" : "data_log_error_") + yyyymm;
            String query = "SELECT count(*) FROM " + tableName;
            Object where = " WHERE true";
            if (mid > 0) {
                where = (String)where + " AND mid=?";
                if (sourceid > 0) {
                    where = (String)where + " AND source_id=?";
                }
            }
            if (date1 != null) {
                where = (String)where + " AND dt>=?";
            }
            if (date2 != null) {
                where = (String)where + " AND dt<=?";
            }
            int all = 0;
            if (ServerUtils.tableExists(this.con, tableName)) {
                int index = 1;
                ps = this.con.prepareStatement(query + (String)where);
                if (mid > 0) {
                    ps.setInt(index++, mid);
                    if (sourceid > 0) {
                        ps.setInt(index++, sourceid);
                    }
                }
                if (date1 != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
                }
                if (date2 != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    all = rs.getInt(1);
                }
                rs.close();
            }
            page.setRecordCount(all);
            Element errorMessages = this.createElement(this.rootNode, "errorMessages");
            errorMessages.setAttribute("all", "" + all);
            this.setPageAttribute(errorMessages, page);
            query = "SELECT id, dt, hh, msg_title FROM " + tableName;
            if (ServerUtils.tableExists(this.con, tableName)) {
                int index = 1;
                ResultSet rs = null;
                ps = this.con.prepareStatement(query + (String)where + page.sqlLimit());
                if (mid > 0) {
                    ps.setInt(index++, mid);
                    if (sourceid > 0) {
                        ps.setInt(index++, sourceid);
                    }
                }
                if (date1 != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
                }
                if (date2 != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    Element error = this.createElement(errorMessages, "error");
                    error.setAttribute("id", rs.getString(1));
                    error.setAttribute("dt", rs.getString(2));
                    error.setAttribute("hh", rs.getString(3));
                    error.setAttribute("title", rs.getString(4));
                }
                rs.close();
            }
        }
    }
}

