/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;

public class TrashDatabaseSelector {
    private List<TableMapRow> configRowList = new ArrayList<TableMapRow>();

    public TrashDatabaseSelector(Preferences setup) {
        ParameterMap configRows = setup.sub("trash.table.map.");
        for (Map.Entry me : configRows.entrySet()) {
            String prefix = (String)me.getKey();
            int pos = prefix.indexOf(46);
            if (pos <= 0) continue;
            prefix = prefix.substring(pos + 1);
            TableMapRow row = new TableMapRow();
            row.tablePrefix = prefix;
            row.database = (String)me.getValue();
            this.configRowList.add(row);
        }
    }

    public String getDatabaseName(String tableName) {
        String result = null;
        for (TableMapRow row : this.configRowList) {
            if (!tableName.startsWith(row.tablePrefix)) continue;
            result = row.database;
            break;
        }
        return result;
    }

    private static class TableMapRow {
        public String tablePrefix;
        public String database;

        private TableMapRow() {
        }
    }
}

