/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantListCellRenderer;
import ru.bitel.bgbilling.plugins.assistant.client.admin.EditorPanel;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ExportAssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ImportAssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class AssistantActionLibraryTab
extends BGUPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private AssistantService assistantService = null;
    private EditorPanel editorPanel = new EditorPanel(this);
    private BGUList<AssistantActionItem> masterActionList = new BGUList();
    private BGUList<AssistantActionItem> libraryActionList = new BGUList();
    private BGUComboBox<IdTitle> masterList = new BGUComboBox();
    private List<AssistantActionItem> assistantActionList;

    protected void jbInit() throws Exception {
        this.tabbedPane.add((Component)this.getMasterTabPanel(), "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043c\u0430\u0441\u0442\u0435\u0440\u043e\u0432");
        this.tabbedPane.add((Component)this.getLibraryTabPanel(), "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
        this.tabbedPane.addChangeListener(e -> this.setActionList());
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.tabbedPane, (Component)this.getRightPanel(), 400L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getMasterTabPanel() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0421\u043e\u0437\u0434\u0430\u0442\u044c").addActionListener(e -> this.performAction("new"));
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.performAction("edit"));
        popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> this.performAction("delete"));
        popupMenu.add("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.tryCall(() -> new ExportAssistantMaster((ClientContext)this.getContext(), ((IdTitle)this.masterList.getSelectedItem()).getId(), this.assistantActionList, this)));
        popupMenu.add("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> new ImportAssistantMaster((ClientContext)this.getContext(), this));
        this.masterActionList.setComponentPopupMenu(popupMenu);
        this.masterActionList.setSelectionMode(0);
        this.masterActionList.setCellRenderer((ListCellRenderer)new AssistantListCellRenderer());
        this.masterActionList.addMouseListener((MouseListener)new ListMouseAdapter());
        this.masterActionList.setDragEnabled(true);
        this.masterActionList.setDropMode(DropMode.INSERT);
        this.masterActionList.setTransferHandler((TransferHandler)new AssistantMasterTabTransferHandler());
        this.masterList.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setActionList();
            }
        });
        JLabel helpLabel = new JLabel("(\u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0440\u044f\u0434\u043a\u0430, \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438)");
        helpLabel.setFont(new Font("Monospaced", 0, 10));
        helpLabel.setForeground(Color.GRAY);
        int gridy = 0;
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041c\u0430\u0441\u0442\u0435\u0440:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 5), 0, 0));
        leftPanel.add((Component)this.masterList, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        leftPanel.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 5), 0, 0));
        leftPanel.add((Component)new JScrollPane((Component)this.masterActionList), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add((Component)helpLabel, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return leftPanel;
    }

    private JPanel getLibraryTabPanel() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0421\u043e\u0437\u0434\u0430\u0442\u044c").addActionListener(e -> this.performAction("new"));
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.performAction("edit"));
        popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> this.performAction("delete"));
        this.libraryActionList.setComponentPopupMenu(popupMenu);
        this.libraryActionList.setSelectionMode(0);
        this.libraryActionList.setCellRenderer((ListCellRenderer)new AssistantListCellRenderer());
        this.libraryActionList.addMouseListener((MouseListener)new ListMouseAdapter());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.libraryActionList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AssistantActionLibraryTab.this.setEnabled(true);
                AssistantAction assistantAction = AssistantActionLibraryTab.this.editorPanel.getAssistantAction();
                if (assistantAction != null) {
                    AssistantActionLibraryTab.this.tryCall(() -> {
                        int id = AssistantActionLibraryTab.this.getAssistantService().assistantActionUpdate(assistantAction);
                        if (AssistantActionLibraryTab.this.tabbedPane.getSelectedIndex() == 0 && ((IdTitle)AssistantActionLibraryTab.this.masterList.getSelectedItem()).getId() > 0) {
                            AssistantActionLibraryTab.this.getAssistantService().assistantMasterActionLinkUpdate(((IdTitle)AssistantActionLibraryTab.this.masterList.getSelectedItem()).getId(), id);
                        }
                        AssistantActionLibraryTab.this.setActionList();
                    });
                }
            }
        });
        this.editorPanel.setVisible(false);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.editorPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setActionList() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == 0) {
            this.tryCall(() -> {
                this.assistantActionList = ((IdTitle)this.masterList.getSelectedItem()).getId() == 0 ? new ArrayList<AssistantActionItem>() : this.getAssistantService().assistantActions(((IdTitle)this.masterList.getSelectedItem()).getId());
                this.setActionList(this.masterActionList, this.assistantActionList);
            });
        } else if (index == 1) {
            this.tryCall(() -> this.setActionList(this.libraryActionList, this.getAssistantService().assistantActions(0)));
        }
    }

    private void setActionList(BGUList<AssistantActionItem> list, List<AssistantActionItem> actionItems) {
        Comparator<AssistantActionItem> comparator = Comparator.comparing(AssistantActionItem::getSort);
        actionItems.sort(comparator);
        AssistantActionItem currentItem = (AssistantActionItem)list.getSelectedValue();
        list.setData(actionItems);
        if (currentItem != null) {
            int currentItemId = currentItem.getId();
            ClientUtils.setListSelection(list, (int)currentItemId, (int)-1);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.isEnabled()) {
                return;
            }
            ArrayList<IdTitle> masterListItems = new ArrayList<IdTitle>();
            masterListItems.add(new IdTitle(0, "===== \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0430\u0441\u0442\u0435\u0440 ====="));
            masterListItems.addAll(this.getAssistantService().assistantMasters().stream().map(IdTitle::toIdTitle).toList());
            this.masterList.setData(masterListItems);
            this.setActionList();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            int masterId = ((IdTitle)this.masterList.getSelectedItem()).getId();
            if (!this.isEnabled() || this.tabbedPane.getSelectedIndex() == 0 && masterId == 0) {
                return;
            }
            this.setEnabled(false);
            AssistantAction assistantAction = new AssistantAction();
            assistantAction.setDependent(this.tabbedPane.getSelectedIndex() == 0 && masterId > 0 ? masterId : 0);
            this.editorPanel.setAssistantAction(assistantAction, this.getAssistantService().getInterfaceName(), this.getAssistantService().getSuperclassName());
            this.editorPanel.performAction("refresh");
            this.editorPanel.setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (!this.isEnabled()) {
                return;
            }
            BGUList<AssistantActionItem> list = this.tabbedPane.getSelectedIndex() == 0 ? this.masterActionList : this.libraryActionList;
            AssistantActionItem assistantActionItem = (AssistantActionItem)list.getSelectedValue();
            if (assistantActionItem != null) {
                this.editorPanel.setAssistantAction(this.getAssistantService().assistantActionGet(assistantActionItem.getId()), this.getAssistantService().getInterfaceName(), this.getAssistantService().getSuperclassName());
                this.editorPanel.setVisible(true);
                this.setEnabled(false);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (!this.isEnabled()) {
                return;
            }
            BGUList<AssistantActionItem> list = this.tabbedPane.getSelectedIndex() == 0 ? this.masterActionList : this.libraryActionList;
            AssistantActionItem assistantActionItem = (AssistantActionItem)list.getSelectedValue();
            if (assistantActionItem != null && ClientUtils.confirmDelete((Object)assistantActionItem.getTitle())) {
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    this.getAssistantService().assistantMasterActionLinkDelete(((IdTitle)this.masterList.getSelectedItem()).getId(), assistantActionItem.getId());
                    if (assistantActionItem.getDependent() > 0) {
                        this.getAssistantService().assistantActionDelete(assistantActionItem.getId());
                    }
                } else {
                    this.getAssistantService().assistantActionDelete(assistantActionItem.getId());
                }
                this.setActionList();
            }
        });
    }

    private void reorder(int nextIndex, TransferHandler.TransferSupport info) {
        int selectedIndex = 0;
        Component component = info.getComponent();
        if (component instanceof JList) {
            JList list = (JList)component;
            selectedIndex = list.getSelectedIndex();
        }
        int oldPosition = this.assistantActionList.get(selectedIndex).getSort();
        if (nextIndex < selectedIndex) {
            int topPoint = nextIndex;
            this.assistantActionList.get(selectedIndex).setSort(this.assistantActionList.get(topPoint).getSort());
            for (int x = topPoint; x < selectedIndex; ++x) {
                if (topPoint - selectedIndex >= 0) continue;
                AssistantActionItem first = this.assistantActionList.get(x);
                AssistantActionItem second = this.assistantActionList.get(x + 1);
                if (x == selectedIndex) continue;
                if (x + 1 == selectedIndex) {
                    first.setSort(oldPosition);
                    continue;
                }
                first.setSort(second.getSort());
            }
        } else {
            int endPosition = --nextIndex;
            int topPoint = selectedIndex;
            this.assistantActionList.get(selectedIndex).setSort(this.assistantActionList.get(nextIndex).getSort());
            for (int x = endPosition; x > topPoint; --x) {
                AssistantActionItem first = this.assistantActionList.get(x);
                AssistantActionItem second = this.assistantActionList.get(x - 1);
                if (x == selectedIndex) continue;
                if (x - 1 == selectedIndex) {
                    first.setSort(oldPosition);
                    continue;
                }
                first.setSort(second.getSort());
            }
        }
        this.tryCall(() -> {
            ArrayList<AssistantActionItem> updatedActionItems = new ArrayList<AssistantActionItem>();
            for (int x = 0; x < this.assistantActionList.size(); ++x) {
                updatedActionItems.add(this.assistantActionList.get(x));
            }
            this.getAssistantService().updateSortListAssistantAction(updatedActionItems);
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.masterList.setEnabled(enabled);
        this.masterActionList.setEnabled(enabled);
        this.libraryActionList.setEnabled(enabled);
        this.tabbedPane.setEnabled(enabled);
    }

    private JMenuItem getMenuItem1(String title, ActionListener actionListener) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    private AssistantService getAssistantService() {
        if (this.assistantService == null) {
            this.assistantService = (AssistantService)((ClientContext)this.getContext()).getPort(AssistantService.class);
        }
        return this.assistantService;
    }

    class ListMouseAdapter
    extends MouseAdapter {
        ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BGUList<AssistantActionItem> list = AssistantActionLibraryTab.this.tabbedPane.getSelectedIndex() == 0 ? AssistantActionLibraryTab.this.masterActionList : AssistantActionLibraryTab.this.libraryActionList;
            JPopupMenu popupMenu = list.getComponentPopupMenu();
            if (list.isEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    AssistantActionLibraryTab.this.performAction("edit");
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && AssistantActionLibraryTab.this.masterActionList.getSelectedValue() != null) {
                    for (int x = 1; x < popupMenu.getComponents().length - 1; ++x) {
                        popupMenu.getComponent(x).setVisible(true);
                    }
                    popupMenu.show((Component)AssistantActionLibraryTab.this.masterActionList, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getButton() == 3) {
                    for (int x = 1; x < popupMenu.getComponents().length - 3; ++x) {
                        popupMenu.getComponent(x).setVisible(false);
                    }
                    popupMenu.show((Component)AssistantActionLibraryTab.this.masterActionList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    class AssistantMasterTabTransferHandler
    extends TransferHandler {
        protected final DataFlavor dataFlavor = new DataFlavor(Object[].class, "Object Row Index");
        protected int[] indices;
        protected int nextIndex = -1;
        protected int addCount;

        AssistantMasterTabTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            Component pane = c.getRootPane().getGlassPane();
            pane.setCursor(DragSource.DefaultMoveDrop);
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            JList source = (JList)component;
            component.getRootPane().getGlassPane().setVisible(true);
            this.indices = source.getSelectedIndices();
            final AssistantActionItem[] transferedObjects = source.getSelectedValuesList().toArray(new AssistantActionItem[0]);
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{AssistantMasterTabTransferHandler.this.dataFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return Objects.equals(AssistantMasterTabTransferHandler.this.dataFlavor, flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(flavor)) {
                        return transferedObjects;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop() && support.isDataFlavorSupported(this.dataFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            TransferHandler.DropLocation infoDropLocation = info.getDropLocation();
            if (!this.canImport(info) || !(infoDropLocation instanceof JList.DropLocation)) {
                return false;
            }
            if (infoDropLocation instanceof JList.DropLocation) {
                JList target;
                JList.DropLocation dropLocation = (JList.DropLocation)infoDropLocation;
                Object object = info.getComponent();
                if (object instanceof JList && (object = (target = (JList)object).getModel()) instanceof DefaultListModel) {
                    DefaultListModel listModel = (DefaultListModel)object;
                    int index = dropLocation.getIndex();
                    int maxCount = listModel.getSize();
                    if (index < 0 || index > maxCount) {
                        index = maxCount;
                    }
                    this.nextIndex = index;
                    AssistantActionLibraryTab.this.reorder(this.nextIndex, info);
                    try {
                        AssistantActionItem[] values = (AssistantActionItem[])info.getTransferable().getTransferData(this.dataFlavor);
                        for (int i = 0; i < values.length; ++i) {
                            int idx = index++;
                            listModel.add(idx, values[i]);
                            target.addSelectionInterval(idx, idx);
                        }
                        this.addCount = values.length;
                        return true;
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            source.getRootPane().getGlassPane().setVisible(false);
            this.cleanup(source, action == 2);
        }

        private void cleanup(JComponent c, boolean remove) {
            if (remove && Objects.nonNull(this.indices)) {
                JList source;
                ListModel listModel;
                if (this.addCount > 0) {
                    for (int i = 0; i < this.indices.length; ++i) {
                        if (this.indices[i] < this.nextIndex) continue;
                        int n = i;
                        this.indices[n] = this.indices[n] + this.addCount;
                    }
                }
                if (c instanceof JList && (listModel = (source = (JList)c).getModel()) instanceof DefaultListModel) {
                    DefaultListModel model = (DefaultListModel)listModel;
                    for (int i = this.indices.length - 1; i >= 0; --i) {
                        model.remove(this.indices[i]);
                    }
                }
            }
            this.indices = null;
            this.addCount = 0;
            this.nextIndex = -1;
        }
    }
}

