package ru.bitel.bgbilling.modules.inet.dyn.device.cisco;

import java.util.List;

import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivator;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class ISGPPPoEServiceActivator
    extends ISGServiceActivator
    implements ServiceActivator
{
	public ISGPPPoEServiceActivator()
	{
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object init( Setup setup, int moduleId, InetDevice device, InetDeviceType deviceType, ParameterMap deviceConfig )
	    throws Exception
	{
		super.init( setup, moduleId, device, deviceType, deviceConfig );

		// по умолчанию закрытие - PoD
		this.closeMode = deviceConfig.getInt( SA_RADIUS_CONNECTION_CLOSE_MODE, CLOSE_MODE_POD );
		// по умолчанию, при переключении состояния из отлючен во включен и withoutBreak=false делаем тоже самое, что и при обычном закрытии сессии
		this.closeEnableMode = deviceConfig.getInt( SA_RADIUS_CONNECTION_CLOSE_ENABLE_MODE, this.closeMode );

		// никакой работы с вторичной авторизацией (InetDhcpHelperProcessor/InetRadiusHelperProcessor) нет
		this.closeRemoveFromKeyMap = deviceConfig.getInt( SA_RADIUS_CONNECTION_CLOSE_REMOVE_FROM_KEY_MAP, 0 ) > 0;

		// при закрытии соединения не отправляем дополнительно запросы на отключение сервисов
		this.disableServicesOnClose = deviceConfig.getInt( SA_RADIUS_CONNECTION_CLOSE_DISABLE_SERVICES, 0 ) > 0;

		return null;
	}
	
	@Override
	public List<ConfigParameter> configParameterList()
	{
	    List<ConfigParameter> configParameters = super.configParameterList();
	    configParameters.add( new ConfigParameter( SA_RADIUS_CONNECTION_CLOSE_MODE, String.valueOf( CLOSE_MODE_POD ) ) );
	    configParameters.add( new ConfigParameter( SA_RADIUS_CONNECTION_CLOSE_ENABLE_MODE, "" ) );
	    configParameters.add( new ConfigParameter( SA_RADIUS_CONNECTION_CLOSE_REMOVE_FROM_KEY_MAP, "0" ) );
	    configParameters.add( new ConfigParameter( SA_RADIUS_CONNECTION_CLOSE_DISABLE_SERVICES, "0" ) );
	    return configParameters;
	}
}
