/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

@Deprecated
public class ContractParameterManager
implements AutoCloseable {
    private static volatile Map<Integer, Boolean> PARAMETERS_HISTORY = new HashMap<Integer, Boolean>();
    private ServerContext context = (ServerContext)ServerContext.get();
    private Map<Integer, ContractParameterPref> parameterIdTypeMap = null;
    protected Connection con;
    private Map<String, PreparedStatement> psCache = new HashMap<String, PreparedStatement>();

    public ContractParameterManager(Connection con) {
        this.con = con;
    }

    public static void resetParametersHistoryMap() {
        PARAMETERS_HISTORY = new HashMap<Integer, Boolean>();
    }

    private boolean checkParameterHistoryLogging(int pid) {
        return this.checkParameterHistoryLogging(this.con, pid);
    }

    private boolean checkParameterHistoryLogging(Connection con, int pid) {
        boolean result = false;
        if (PARAMETERS_HISTORY.containsKey(pid)) {
            result = PARAMETERS_HISTORY.get(pid);
        } else {
            try {
                HashMap<Integer, Boolean> historyMap = new HashMap<Integer, Boolean>();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT id, flags FROM contract_parameters_pref");
                while (rs.next()) {
                    boolean has;
                    int id = rs.getInt(1);
                    boolean bl = has = (rs.getInt(2) & 1) > 0;
                    if (id == pid) {
                        result = has;
                    }
                    historyMap.put(id, has);
                }
                rs.close();
                st.close();
                PARAMETERS_HISTORY.putAll(historyMap);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void setContractRefParam(int cid, int pid, int value, int userId) {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM contract_parameter_type_8 WHERE cid=? AND pid=?");
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                PreparedStatement ps1 = this.con.prepareStatement("INSERT INTO contract_parameter_type_8 SET cid=?, pid=?, val=?");
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setInt(index++, value);
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("UPDATE contract_parameter_type_8 SET val=? WHERE cid=? AND pid=? AND NOT(val<=>?)");
                ps2.setInt(index++, value);
                ps2.setInt(index++, cid);
                ps2.setInt(index++, pid);
                ps2.setInt(index++, value);
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateIntegerParamLog(cid, pid, value, userId);
        }
    }

    public Integer getContractRefParam(int cid, int pid) {
        Integer result = null;
        String query = null;
        try {
            query = "SELECT val FROM contract_parameter_type_8 WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Integer> getContractRefParamMap(int cid, Set<Integer> pids) throws SQLException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT pid, val FROM ");
        query.append("contract_parameter_type_8");
        query.append(" WHERE cid=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int pid = rs.getInt(1);
            if (pids != null && !pids.contains(pid)) continue;
            result.put(pid, rs.getInt(2));
        }
        rs.close();
        ps.close();
        return result;
    }

    private void updateIntegerParamLog(int contractId, int parameterId, Integer value, int userId) {
        String query = "INSERT INTO contract_parameter_type_8_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, parameterId);
            ps.setObject(index++, value);
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteContractRefParam(int cid, int pid, int userId) throws Exception {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateIntegerParamLog(cid, pid, null, userId);
        }
    }

    public Map<Integer, MultiListParamValues> getMultiListParamValueMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, MultiListParamValues> result = new HashMap<Integer, MultiListParamValues>();
        try {
            Object query = "SELECT item.val AS id, val.title AS val, item.custom_value AS custom_value, item.pid AS pid FROM contract_parameter_type_multilist_item AS item  LEFT JOIN contract_parameter_type_multilist_values AS val on val.id = item.val where item.cid=?";
            if (pids != null && pids.size() != 0) {
                query = (String)query + " AND item.pid IN (" + Utils.toString(pids) + ")";
            }
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int pid = rs.getInt("pid");
                MultiListParamValues listValues = (MultiListParamValues)result.get(pid);
                if (listValues == null) {
                    listValues = new MultiListParamValues();
                    result.put(pid, listValues);
                }
                listValues.add(this.getListParamValueFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateMultiListParameterAndItems(int contractId, int parameterId, MultiListParamValues values, int userId) {
        PreparedStatement ps;
        String query = "DELETE FROM contract_parameter_type_multilist_item WHERE cid=? AND pid=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, contractId);
                ps.setInt(index++, parameterId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        query = "INSERT INTO contract_parameter_type_multilist_item SET cid=?, pid=?, val=?, custom_value=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, contractId);
                ps.setInt(2, parameterId);
                for (ListParamValue value : values) {
                    ps.setInt(3, value.getId());
                    ps.setString(5, value.getCustomValue());
                    ps.executeUpdate();
                }
                values = this.getMultiListParamValues(contractId, parameterId);
                this.updateMultiListParameter(this.con, contractId, parameterId, values, userId);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMultiListParameter(Connection con, int cid, int pid, MultiListParamValues values, int userID) {
        String val = "";
        try {
            if (values.size() > 0) {
                val = values.toStringValue();
                String query = "REPLACE INTO contract_parameter_type_multilist SET cid=?, pid=?, val=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, pid);
                ps.setString(3, val);
                ps.executeUpdate();
                ps.close();
            } else {
                String query = "DELETE FROM contract_parameter_type_multilist WHERE cid=? AND pid=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, pid);
                ps.executeUpdate();
                ps.close();
                val = null;
            }
            if (this.checkParameterHistoryLogging(con, pid)) {
                this.updateMultiListParamLog(con, cid, pid, val, userID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateListParamLog(int cid, int pid, Integer value, String customValue, int userId) {
        String query = "INSERT INTO contract_parameter_type_7_log SET cid=?, pid=?, val=?, title=?, dt_change=now(), user_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            String title = "";
            if (value != null) {
                title = value == 0 ? customValue : Optional.ofNullable(this.context.getDirectory(ContractParameterListItem.class, pid).get(value)).map(a -> a.getTitle()).orElse("");
            }
            int index = 1;
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setObject(index++, value);
            ps.setString(index++, title);
            ps.setInt(index++, userId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateMultiListParamLog(int cid, int pid, String value, int userId) {
        this.updateMultiListParamLog(this.con, cid, pid, value, userId);
    }

    private void updateMultiListParamLog(Connection con, int cid, int pid, String value, int userId) {
        try (Connection connect = Setup.getSetup().getDBConnectionFromPool();){
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO contract_parameter_type_multilist_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = connect.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setObject(index++, value);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<IdTitle> getListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId, "contract_parameter_type_7_values");
    }

    public List<IdTitle> getMultiListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId, "contract_parameter_type_multilist_values");
    }

    private List<IdTitle> getListValues(int parameterId, String tableName) throws BGException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        try {
            String query = "SELECT id, title FROM " + tableName + " WHERE pid=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parameterId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public MultiListParamValues getMultiListParamValues(int contractId, int parameterId) throws SQLException {
        return this.getMultiListParameterValues(this.con, contractId, parameterId);
    }

    private MultiListParamValues getMultiListParameterValues(Connection con, int cid, int pid) throws SQLException {
        MultiListParamValues listValues = new MultiListParamValues();
        String query = "SELECT item.val AS id, val.title AS val, item.custom_value AS custom_value FROM contract_parameter_type_multilist_item AS item LEFT JOIN contract_parameter_type_multilist_values AS val on val.id = item.val where item.cid=? AND item.pid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setInt(2, pid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            listValues.add(this.getListParamValueFromRs(rs));
        }
        rs.close();
        ps.close();
        return listValues;
    }

    private ListParamValue getListParamValueFromRs(ResultSet rs) throws SQLException {
        ListParamValue value = new ListParamValue();
        value.setId(Utils.parseInt((String)rs.getString("id")));
        value.setValue(rs.getString("val"));
        value.setCustomValue(rs.getString("custom_value"));
        return value;
    }

    public int updateMultiListParameterValue(int id, int pid, String title) throws SQLException {
        if (pid > 0 && title != null && title.length() > 0) {
            return this.updateListValue(id, pid, title, "contract_parameter_type_multilist_values");
        }
        return 0;
    }

    public void replaceMultiListCustomValues(int id, int pid, String customValue) throws SQLException {
        String query = "UPDATE contract_parameter_type_multilist_item SET val=?, custom_value=? WHERE pid=? AND custom_value=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setString(2, "");
        ps.setInt(3, pid);
        ps.setString(4, customValue);
        ps.executeUpdate();
        ps.close();
        query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND val=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, id);
        ResultSet rs = ps.executeQuery();
        int cid = -1;
        while (rs.next()) {
            cid = rs.getInt(1);
            this.updateMultiListParameter(this.con, cid, pid, this.getMultiListParamValues(cid, pid), 0);
        }
        rs.close();
        ps.close();
    }

    public int updateListValue(int id, int pid, String title) throws SQLException {
        if (pid > 0 && title != null && title.length() > 0) {
            return this.updateListValue(id, pid, title, "contract_parameter_type_7_values");
        }
        return 0;
    }

    public void replaceCustomListValue(int id, int pid, String customValue) throws SQLException {
        String query = "UPDATE contract_parameter_type_7 SET val=?, custom_value=? WHERE pid=? AND custom_value=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setString(2, "");
        ps.setInt(3, pid);
        ps.setString(4, customValue);
        ps.executeUpdate();
        ps.close();
    }

    private int updateListValue(int id, final int pid, final String title, String tableName) throws SQLException {
        String query = null;
        if (id == 0) {
            query = "INSERT INTO " + tableName + " ( pid, title ) VALUES (?, ?)";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(1, pid);
                ps.setString(2, title);
                ps.executeUpdate();
                id = ServerUtils.lastInsertId(ps);
            }
        }
        query = "UPDATE " + tableName + " SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, title);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        if (tableName.equals("contract_parameter_type_multilist")) {
            this.updateAllMultiListParamsOnContracts(pid, id);
        } else {
            final int finalId = id;
            ExecutorService executor = Executors.newFixedThreadPool(1);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    String query = "SELECT cid FROM contract_parameter_type_7 WHERE pid=? AND val=?";
                    try (Connection connect = Setup.getSetup().getDBConnectionFromPool();
                         PreparedStatement ps = connect.prepareStatement(query);){
                        ps.setInt(1, pid);
                        ps.setInt(2, finalId);
                        try (ResultSet rs = ps.executeQuery();){
                            while (rs.next()) {
                                ContractParameterManager.this.updateListParamLog(rs.getInt(1), pid, finalId, title, 0);
                            }
                        }
                    }
                    catch (SQLException exp) {
                        exp.printStackTrace();
                    }
                }
            });
        }
        return id;
    }

    private void updateAllMultiListParamsOnContracts(final int pid, final int val) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND val=? ";
                try (Connection connect = Setup.getSetup().getDBConnectionFromPool();
                     PreparedStatement ps = connect.prepareStatement(query);){
                    ps.setInt(1, pid);
                    ps.setInt(2, val);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        int cid = rs.getInt(1);
                        MultiListParamValues listValues = ContractParameterManager.this.getMultiListParameterValues(connect, cid, pid);
                        ContractParameterManager.this.updateMultiListParameter(connect, cid, pid, listValues, 0);
                    }
                    rs.close();
                }
                catch (SQLException exp) {
                    exp.printStackTrace();
                }
            }
        });
    }

    public boolean checkMultiListValue(int val, int pid) throws SQLException {
        String query = null;
        PreparedStatement ps = null;
        query = "SELECT COUNT(*) FROM contract_parameter_type_multilist_item WHERE pid=? AND val=? ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, val);
        ResultSet rs = ps.executeQuery();
        int value = 0;
        while (rs.next()) {
            value = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return value != 0;
    }

    public void deleteListValue(int id) throws SQLException {
        this.deleteListValue(id, "contract_parameter_type_7_values");
    }

    public void deleteMultiListValue(int id) throws SQLException {
        this.deleteListValue(id, "contract_parameter_type_multilist_values");
    }

    private void deleteListValue(int id, String tableName) throws SQLException {
        if (id > 0) {
            String query = "DELETE FROM " + tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
    }

    public void deleteListCustomValue(String customValue, int pid) throws SQLException {
        this.deleteListCustomValue(customValue, pid, "contract_parameter_type_7");
    }

    public void deleteMultiListCustomValue(String customValue, int pid) throws SQLException {
        String query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND custom_value=? ";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setString(2, customValue);
        ResultSet rs = ps.executeQuery();
        ArrayList<Integer> contracts = new ArrayList<Integer>();
        while (rs.next()) {
            int cid = rs.getInt(1);
            contracts.add(cid);
        }
        this.deleteListCustomValue(customValue, pid, "contract_parameter_type_multilist_item");
        for (Integer cid : contracts) {
            this.updateMultiListParameter(this.con, cid, pid, this.getMultiListParamValues(cid, pid), 0);
        }
        rs.close();
        ps.close();
    }

    private void deleteListCustomValue(String customValue, int pid, String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName + " WHERE custom_value=? AND pid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, customValue);
        ps.setInt(2, pid);
        ps.executeUpdate();
        ps.close();
    }

    public int getMultilistParamId(String title) throws SQLException {
        String query = "SELECT id FROM contract_parameter_type_multilist_values WHERE title = ?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, title);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int result = rs.getInt(1);
            rs.close();
            ps.close();
            return result;
        }
        rs.close();
        ps.close();
        return -1;
    }

    @Deprecated
    public List<IdTitle> getParameterListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId);
    }

    public Map<Integer, Integer> getAddressCustomParam() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String sql = "SELECT pid, count(*) FROM contract_parameter_type_2 where hid='0' group by pid";
        try (PreparedStatement ps = this.con.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                map.put(rs.getInt("pid"), rs.getInt(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public void deleteParamForContractByType(int parameterTypeId, int contractId) {
        this.deleteParamForContract(this.getTableName(parameterTypeId), contractId);
        if (parameterTypeId == 9) {
            this.deleteParamForContract("contract_parameter_type_phone_item", contractId);
        } else if (parameterTypeId == 11) {
            this.deleteParamForContract("contract_parameter_type_multilist_item", contractId);
        }
        this.deleteParamLogForContractByType(parameterTypeId, contractId);
    }

    public void deleteParamLogForContractByType(int parameterTypeId, int contractId) {
        this.deleteParamForContract(this.getTableName(parameterTypeId) + "_log", contractId);
    }

    public void deleteParamLog(int parameterId) throws Exception {
        ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
        if (pt == ContractParameterPrefType.TYPE_SEPARATOR) {
            return;
        }
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append(pt.getTableName());
        query.append("_log WHERE pid=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, parameterId);
            ps.executeUpdate();
        }
    }

    private void deleteParamForContract(String tableName, int cid) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM " + tableName + " WHERE cid=?";
            ps = this.createPs(query);
            ps.setInt(index++, cid);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private PreparedStatement createPs(String query) throws SQLException {
        PreparedStatement ps = this.psCache.get(query);
        if (ps == null) {
            ps = this.con.prepareStatement(query);
            this.psCache.put(query, ps);
        }
        return ps;
    }

    private int deleteParameter(int contractId, int parameterId) throws Exception {
        int updateRows = 0;
        ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + pt.getTableName() + " WHERE cid=? AND pid=?");){
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            updateRows = ps.executeUpdate();
        }
        if (pt == ContractParameterPrefType.TYPE_PHONE) {
            ps = this.con.prepareStatement("DELETE FROM contract_parameter_type_phone_item WHERE cid=? AND pid=?");
            try {
                ps.setInt(1, contractId);
                ps.setInt(2, parameterId);
                updateRows = ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        return updateRows;
    }

    public List<ParameterHistoryEntry> getParameterHistory(int contractId, int parameterId) throws Exception {
        ArrayList<ParameterHistoryEntry> result = new ArrayList<ParameterHistoryEntry>();
        ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
        String query = "SELECT " + this.getValueSelect(pt) + ", log.dt_change, user.name, user_id  FROM " + pt.getTableName() + "_log AS log  LEFT JOIN user ON log.user_id=user.id  WHERE log.cid=? AND log.pid=?  ORDER BY log.dt_change";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ParameterHistoryEntry entry = new ParameterHistoryEntry();
                    entry.setValue(rs.getString(1));
                    entry.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2)));
                    int userId = rs.getInt(4);
                    if (userId == -1) {
                        entry.setUser("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
                    } else if (userId == 0) {
                        entry.setUser("\u0421\u0435\u0440\u0432\u0435\u0440");
                    } else if (rs.getString(3) == null) {
                        entry.setUser("??? [userId=" + userId + "]");
                    } else {
                        entry.setUser(rs.getString(3));
                    }
                    result.add(entry);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void clearParameterHistory(int cid, int pid, int parameterTypeId) throws SQLException {
        String sql = "DELETE FROM " + this.getTableName(parameterTypeId) + "_log WHERE cid=? AND pid=?";
        PreparedStatement ps = this.con.prepareStatement(sql);
        ps.setInt(1, cid);
        ps.setInt(2, pid);
        ps.executeUpdate();
        ps.close();
    }

    public String getTableName(int parameterTypeId) {
        ContractParameterPrefType type = ContractParameterPrefType.getType(parameterTypeId);
        return type.getTableName();
    }

    public List<IdTitle> getAllParams(int cid, String tableName, String pids) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT param.pid, pref.title");
            query.append(" FROM ");
            query.append(tableName);
            query.append(" AS param LEFT JOIN contract_parameters_pref AS pref ON param.pid=pref.id ");
            query.append(" WHERE param.cid=?");
            if (pids != null) {
                query.append(" AND param.pid IN (");
                query.append(pids);
                query.append(")");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt("pid"), rs.getString("pref.title")));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void copyContractParams(String where, Map<String, ColumnValue> valuesPairs) {
        TableCopier copier = new TableCopier(this.con);
        try {
            copier.copyRecord("contract_parameter_type_1", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_2", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_3", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_4", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_5", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_6", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_7", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_8", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_phone", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_phone_item", where, valuesPairs);
            copier.copyRecord("contract_parameter_type_multilist", where, valuesPairs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void searchCustomAddress(SearchResult<String[]> searchResult, int parameterId) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List result = searchResult.getList();
            try {
                String query = "SELECT SQL_CALC_FOUND_ROWS cid, address, a.comment, pid, contract.title FROM contract_parameter_type_2 AS a LEFT JOIN contract ON contract.id=a.cid WHERE pid=" + parameterId + " AND hid=0" + page.sqlLimit();
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    int index = 0;
                    String[] value = new String[5];
                    value[index++] = rs.getString("cid");
                    value[index++] = rs.getString("address");
                    value[index++] = rs.getString("a.comment");
                    value[index++] = rs.getString("pid");
                    value[index++] = rs.getString("contract.title");
                    result.add(value);
                }
                rs.close();
                st.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private String getValueSelect(ContractParameterPrefType parameterType) {
        String title = "log.val as value";
        if (parameterType == ContractParameterPrefType.TYPE_LIST) {
            title = "concat( '[id=', CAST(log.val AS CHAR), '] ', IF(ISNULL(log.title),'',log.title) ) as value";
        }
        return title;
    }

    @Deprecated
    public HashMap<Integer, String> getValuesForPids(List<Integer> pids, int contractId) {
        return this.getValuesForPids(new HashSet<Integer>(pids), contractId);
    }

    public HashMap<Integer, String> getValuesForPids(Set<Integer> pids, int contractId) {
        LinkedHashMap<Integer, String> values = new LinkedHashMap<Integer, String>();
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            ContractParameterPrefDao prefDao = new ContractParameterPrefDao(this.con);
            Map<Integer, EntityAttr> dataType = contractDao.getContractParameters(contractId, pids);
            HashMap dataType4 = null;
            HashMap<String, String> directory = null;
            Map<Integer, ContractParamValue> dataType8 = null;
            Map<Integer, MultiListParamValues> dataTypeMultiList = null;
            for (ContractParameterPref pid : prefDao.getContractParameterPrefList(pids)) {
                String value = null;
                switch (pid.getType()) {
                    case TYPE_TEXT: {
                        EntityAttr strParam = dataType.get(pid.getId());
                        value = strParam != null ? ((EntityAttrText)strParam).getValue() : null;
                        break;
                    }
                    case TYPE_ADDRESS: {
                        EntityAttr address = dataType.get(pid.getId());
                        value = address != null ? ((EntityAttrAddress)address).getTitle() : null;
                        break;
                    }
                    case TYPE_EMAIL: {
                        EntityAttr email = dataType.get(pid.getId());
                        value = email != null ? ((EntityAttrEmail)email).toString() : null;
                        break;
                    }
                    case TYPE_SERVICING_PERSON: {
                        Hashtable val;
                        Object rs;
                        PreparedStatement ps;
                        String query;
                        if (dataType4 == null) {
                            dataType4 = new HashMap();
                            query = "SELECT pid, val1, val2 FROM contract_parameter_type_4 WHERE cid=?";
                            ps = this.con.prepareStatement(query);
                            try {
                                ps.setInt(1, contractId);
                                rs = ps.executeQuery();
                                try {
                                    while (rs.next()) {
                                        Integer n = rs.getInt(1);
                                        String val2 = rs.getString(3);
                                        Hashtable<String, Integer> val3 = (Hashtable<String, Integer>)dataType4.get(n);
                                        if (val3 == null) {
                                            val3 = new Hashtable<String, Integer>();
                                            val3.put(val2, 1);
                                            dataType4.put(n, val3);
                                            continue;
                                        }
                                        Integer integ = (Integer)val3.get(val2);
                                        val3.put(val2, integ == null ? 1 : integ + 1);
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        if (directory == null) {
                            directory = new HashMap<String, String>();
                            query = "SELECT id, title FROM contract_parameter_type_4_directory";
                            ps = this.con.prepareStatement(query);
                            try {
                                rs = ps.executeQuery();
                                try {
                                    while (rs.next()) {
                                        directory.put(rs.getString(1), rs.getString(2));
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        if ((val = (Hashtable)dataType4.get(pid.getId())) == null) break;
                        StringBuilder buf = new StringBuilder();
                        for (Map.Entry entry : val.entrySet()) {
                            String title = (String)directory.get(entry.getKey());
                            Integer integ = (Integer)entry.getValue();
                            if (title == null || integ == null) continue;
                            if (buf.length() > 0) {
                                buf.append("; ");
                            }
                            buf.append(title);
                            buf.append(": ");
                            buf.append(integ);
                        }
                        value = buf.toString();
                        break;
                    }
                    case TYPE_FLAG: {
                        EntityAttr bool = dataType.get(pid.getId());
                        value = bool != null ? Utils.booleanToStringInt((boolean)((EntityAttrBoolean)bool).getValue()) : null;
                        break;
                    }
                    case TYPE_DATE: {
                        EntityAttr date = dataType.get(pid.getId());
                        value = date != null ? TimeUtils.formatDate((Date)((EntityAttrDate)date).getValue()) : null;
                        break;
                    }
                    case TYPE_LIST: {
                        EntityAttr entityAttr = dataType.get(pid.getId());
                        value = entityAttr != null ? ((EntityAttrList)entityAttr).toString() : null;
                        break;
                    }
                    case TYPE_CONTRACT_REF: {
                        ContractParamValue param;
                        if (dataType8 == null) {
                            dataType8 = this.getContractParamValueMap(contractId);
                        }
                        String string = value = (param = dataType8.get(pid.getId())) == null ? null : param.getTitle();
                        if (value != null || pids == null) break;
                        value = "";
                        break;
                    }
                    case TYPE_PHONE: {
                        EntityAttr phone = dataType.get(pid.getId());
                        value = phone != null ? ((EntityAttrPhone)phone).toString() : null;
                        break;
                    }
                    case TYPE_MULTILIST: {
                        MultiListParamValues multiListParamValues;
                        if (dataTypeMultiList == null) {
                            dataTypeMultiList = this.getMultiListParamValueMap(contractId, null);
                        }
                        String string = value = (multiListParamValues = dataTypeMultiList.get(pid.getId())) != null ? multiListParamValues.toStringValue() : null;
                    }
                }
                if (value == null) continue;
                values.put(pid.getId(), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public String getTextlikeParam(int contractId, final int pid) {
        if (contractId <= 0 || pid <= 0) {
            return null;
        }
        HashMap<Integer, String> v = this.getValuesForPids((Set<Integer>)new HashSet<Integer>(){
            {
                this.add(pid);
            }
        }, contractId);
        return v.getOrDefault(pid, null);
    }

    public ContractParameterPref getParamPref(int parameterId) throws Exception {
        ContractParameterPref result;
        if (this.parameterIdTypeMap == null) {
            this.parameterIdTypeMap = new HashMap<Integer, ContractParameterPref>();
        }
        if ((result = this.parameterIdTypeMap.get(parameterId)) == null) {
            ContractParameterPref pref = (ContractParameterPref)new ContractParameterPrefDao(this.con).get(parameterId);
            if (pref == null) {
                throw new BGException("Type parameterId not found!");
            }
            result = pref;
            this.parameterIdTypeMap.put(parameterId, result);
        }
        return result;
    }

    public Map<Integer, ContractParamValue> getContractParamValueMap(int contractId) throws BGException {
        HashMap<Integer, ContractParamValue> result = new HashMap<Integer, ContractParamValue>();
        String query = "SELECT t1.pid, contract.title, contract.comment FROM contract_parameter_type_8 AS t1 LEFT JOIN contract ON contract.id=t1.val WHERE t1.cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (!Utils.notBlankString((String)rs.getString(2))) continue;
                    ContractParamValue value = new ContractParamValue();
                    value.setId(rs.getInt(1));
                    value.setTitle(rs.getString(2));
                    value.setComment(rs.getString(3));
                    result.put(value.getId(), value);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void close() throws BGException {
        try {
            for (PreparedStatement ps : this.psCache.values()) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

