/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.enums.DirectoryType;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class HelpDeskTableTabInDirectory
extends BGPanel {
    private DirectoryType directoryType;
    private BGUTable table = null;
    private BGTableModel<IdTitle> tableModel;
    private BGControlPanelPages controlPanelPages = new BGControlPanelPages();
    private JLabel label = new JLabel();
    String title;
    String titleN;
    String setAction;
    String deleteAction;

    public HelpDeskTableTabInDirectory(String titleBorder, String titleName, String deleteAction, DirectoryType directoryType) {
        this.title = titleBorder;
        this.titleN = titleName;
        this.module = "ru.bitel.bgbilling.plugins.helpdesk";
        this.deleteAction = deleteAction;
        this.directoryType = directoryType;
        this.controlPanelPages.setKey(titleName);
        this.controlPanelPages.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.trySetData();
            }
        });
        this.tableModel = new BGTableModel<IdTitle>(this.titleN){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn(HelpDeskTableTabInDirectory.this.titleN, String.class, -1, 150, -1, "title", true, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }
        };
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    HelpDeskTableTabInDirectory.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.003, 12, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getTablejScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.controlPanelPages, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JScrollPane getTablejScrollPane() {
        JScrollPane ScrollPane = new JScrollPane((Component)this.table);
        ScrollPane.setBorder(new TitledBorder(this.title));
        return ScrollPane;
    }

    public void newItem() {
        new ItemEditor("\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442", new IdTitle()).open();
    }

    public void editItem() {
        new ItemEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", (IdTitle)this.tableModel.getSelectedRow()).open();
    }

    public void deleteItem() {
        if (this.tableModel.getSelectedRow() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request;
            Document doc;
            Integer id = (Integer)this.tableModel.getValueAt(this.table.getSelectedRow(), 0);
            if (this.directoryType == DirectoryType.GROUP && ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule(this.module).setAction("InspectionGroupContract").setAttribute("groupId", (Object)id))))) {
                this.tryCall(() -> {
                    Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data/row");
                    int countGroup = Utils.parseInt((String)tableElement.getAttribute("countGroup"), (int)-1);
                    int countPattern = Utils.parseInt((String)tableElement.getAttribute("countPattern"), (int)-1);
                    Object stringPattern = "";
                    if (countPattern > 0) {
                        stringPattern = ", \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 " + countPattern;
                    }
                    if ((countGroup > 0 || countPattern > 0) && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 " + countGroup + (String)stringPattern + ". \u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        Request request1 = new Request();
                        request1.setModule(this.module);
                        request1.setAction(this.deleteAction);
                        request1.setAttribute("id", (Object)id);
                        request1.setAttribute("countPattern", countPattern);
                        if (ClientUtils.checkStatus((Document)this.getDocument(request1))) {
                            this.setData();
                            this.updateUI();
                            this.repaint();
                        }
                    }
                    if (countGroup == 0 && countPattern == 0) {
                        Request request2 = new Request();
                        request2.setModule(this.module);
                        request2.setAction(this.deleteAction);
                        request2.setAttribute("id", (Object)id);
                        request2.setAttribute("countPattern", countPattern);
                        if (ClientUtils.checkStatus((Document)this.getDocument(request2))) {
                            this.setData();
                            this.updateUI();
                            this.repaint();
                        }
                    }
                });
            }
            if (this.directoryType == DirectoryType.CATEGORY) {
                this.tryCall(() -> {
                    ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).categoryDelete(id.intValue());
                    this.trySetData();
                });
            }
            if (this.directoryType == DirectoryType.SUBCATEGORY) {
                this.tryCall(() -> {
                    ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).subcategoryDelete(id.intValue());
                    this.trySetData();
                });
            }
        }
    }

    public void update(IdTitle idTitle) {
        try {
            ClientContext clientContext = this.getContext();
            if (this.directoryType == DirectoryType.GROUP) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).groupUpdate(idTitle.getId(), idTitle.getTitle());
            } else if (this.directoryType == DirectoryType.CATEGORY) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).categoryUpdate(idTitle.getId(), idTitle.getTitle());
            } else if (this.directoryType == DirectoryType.SUBCATEGORY) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).subcategoryUpdate(idTitle.getId(), idTitle.getTitle());
            }
            this.setData();
            this.updateUI();
            this.repaint();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setData() throws Exception {
        Async asyncSearchResult = switch (this.directoryType) {
            default -> throw new MatchException(null, null);
            case DirectoryType.GROUP -> Async.of(() -> ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).groupList(true, 0, this.controlPanelPages.getPage()));
            case DirectoryType.CATEGORY -> Async.of(() -> ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).categoryList(this.controlPanelPages.getPage()));
            case DirectoryType.SUBCATEGORY -> Async.of(() -> ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).subcategoryList(this.controlPanelPages.getPage()));
        };
        SearchResult searchResult = (SearchResult)asyncSearchResult.get();
        this.tableModel.setData(searchResult.getList());
        this.controlPanelPages.setPage(searchResult.getPage());
        this.label.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
    }

    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data");
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            NodeList listCategory = tableElement.getChildNodes();
            for (Element row : XMLUtils.elements((NodeList)listCategory)) {
                list.add(new IdTitle(Utils.parseInt((String)row.getAttribute("id")), row.getAttribute("title")));
            }
            this.tableModel.setData(list);
            this.controlPanelPages.setPageInfo(tableElement);
            this.label.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
        }
    }

    class ItemEditor
    extends BGEditorDialog<IdTitle> {
        private BGTextField title;

        public ItemEditor(String title, IdTitle data) {
            super(title, (Object)data);
            this.title = new BGTextField(50);
        }

        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.title.setText(((IdTitle)this.data).getTitle());
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.title.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((IdTitle)this.data).setTitle(this.title.getText());
            HelpDeskTableTabInDirectory.this.update((IdTitle)this.data);
            HelpDeskTableTabInDirectory.this.trySetData();
            return true;
        }
    }
}

