/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.tariff.client.TariffLabelTree;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVarsPanel;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlanData;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class TariffPanelEditor
extends BGUPanel {
    private static final String TARIFF_EDITOR = "editor";
    public static final String TAB_ID = "newTariffPlanEditor";
    private TariffTree tree;
    private TariffPanel tariffPanel;
    private boolean init = false;
    private int currentFace = 0;
    private int tariffPlanId = 0;
    private JTextField tariffPlanTitleInGUI = new JTextField();
    private JTextField tariffPlanTitleInWEB = new JTextField();
    private JCheckBox isUsedCheckBox = new JCheckBox("\u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
    private JCheckBox isWebCheckBox = new JCheckBox("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430");
    private ButtonGroup faceButtonGroup = new ButtonGroup();
    private BGTextField maskText = new BGTextField();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private BGTextArea comment = new BGTextArea();
    private BGTextArea description = new BGTextArea();
    private CardLayout cardLayout1 = new CardLayout();
    private CardLayout cardLayout2 = new CardLayout();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTabbedPane tabPane1 = new JTabbedPane();
    private JTabbedPane tabPane2 = new JTabbedPane();
    private JPanel treePanel = new JPanel(new GridBagLayout());
    private JPanel cardPanel = new JPanel(this.cardLayout1);
    private JPanel treePanelContainer = new JPanel(this.cardLayout2);
    private TariffVarsPanel tariffVarsPanel = null;
    private TariffLabelTree tariffLabelTree = new TariffLabelTree();
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private BGUPanel.WebServiceHolder<TariffService> tariffService = new BGUPanel.WebServiceHolder(TariffService.class, 0);
    AbstractBGUPanel.DefaultAction ok = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){
        {
            this.putValue("ShortDescription", "<html>\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f, <b>\u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435</b> \u0441 \u0434\u0435\u0440\u0435\u0432\u043e\u043c \u0442\u0430\u0440\u0438\u0444\u0430</html>");
        }

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.updateTariff();
        }
    };
    AbstractBGUPanel.DefaultAction flush = new AbstractBGUPanel.DefaultAction("ok.flush", "\u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445"){
        {
            this.putValue("ShortDescription", "<html>\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0434\u0435\u0440\u0435\u0432\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044e\u0442\u0441\u044f <b>\u043d\u0435\u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e</b>, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438<br/>\u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u0435\u0440\u0435\u0432\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \"\u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445\"</html>");
        }

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.tree.flush();
        }
    };
    AbstractBGUPanel.DefaultAction close = new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TariffPanelEditor.this.tree != null && TariffPanelEditor.this.tree.isNeedFlush()) {
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e. \u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                switch (result) {
                    case 0: {
                        TariffPanelEditor.this.flush.perform();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            TariffPanelEditor.this.tariffPanel.setData();
            this.getParentAction().actionPerformed(e);
        }
    };
    AbstractBGUPanel.DefaultAction export = new AbstractBGUPanel.DefaultAction("left.export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.exportTariff();
        }
    };

    public TariffPanelEditor(TariffPanel tariffPanel) {
        this.tariffPanel = tariffPanel;
        this.tariffVarsPanel = new TariffVarsPanel(this.getKernelContext(), () -> this.getTariffService());
        this.tariffLabelTree.setPopupMenu(tariffPanel.labelPanel.popupFilterMenu);
    }

    @Override
    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430");
        this.init = false;
        this.isWebCheckBox.addChangeListener(e -> this.tariffPlanTitleInWEB.setEnabled(!this.isWebCheckBox.getModel().isSelected()));
        JPanel titlePanelGUI = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder(titlePanelGUI, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.tariffPlanTitleInWEB.setToolTipText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430");
        titlePanelGUI.add((Component)this.tariffPlanTitleInGUI, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        titlePanelGUI.add((Component)this.isUsedCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.isUsedCheckBox.setToolTipText("\u0424\u043b\u0430\u0433 \u0442\u043e\u0433\u043e, \u0447\u0442\u043e \u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        JPanel titlePanelWEB = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder(titlePanelWEB, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435");
        this.tariffPlanTitleInWEB.setToolTipText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435");
        titlePanelWEB.add((Component)this.tariffPlanTitleInWEB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        titlePanelWEB.add((Component)this.isWebCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.isWebCheckBox.setToolTipText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0434\u043b\u044f \u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0430");
        this.tariffPlanTitleInGUI.getDocument().addDocumentListener(new RepeatDocumentListener());
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)new JScrollPane(this.tariffLabelTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)new JScrollPane(this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.tabPane1.add((Component)this.getContractFilterPanel(), "\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        this.tabPane1.add((Component)labelPanel, "\u041c\u0435\u0442\u043a\u0438");
        this.tabPane1.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        this.tabPane2.add((Component)this.getTextAreaPanel(this.comment), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.tabPane2.add((Component)this.getTextAreaPanel(this.description), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (\u043b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442)");
        JPanel preferencesPanel = new JPanel(new GridBagLayout());
        preferencesPanel.add((Component)titlePanelGUI, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)titlePanelWEB, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)this.tabPane2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)this.tabPane1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        this.treePanelContainer.add((Component)this.treePanel, "tree");
        this.treePanelContainer.add((Component)new JPanel(), "nothing");
        this.tabbedPane.add("\u0414\u0435\u0440\u0435\u0432\u043e", this.treePanelContainer);
        this.tabbedPane.add("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 (\u0442\u0430\u0440\u0438\u0444\u0430)", this.tariffVarsPanel);
        this.tabbedPane.addChangeListener(e -> {
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.tariffVarsPanel.loadTariffVars();
            }
        });
        BGSplitPaneNoBorder mainTab = new BGSplitPaneNoBorder(1, preferencesPanel, (Component)this.tabbedPane, 400L);
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.add((Component)mainTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cardPanel.add((Component)editorPanel, TARIFF_EDITOR);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTextAreaPanel(BGTextArea textArea) {
        textArea.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(textArea, 200, 120), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractFilterPanel() {
        ActionListener actionListener = e -> this.setCurrentFace(e.getActionCommand());
        JPanel fizYurPanel = new JPanel(new GridBagLayout());
        fizYurPanel.setBorder(new BGTitleBorder(" \u041b\u0438\u0446\u043e "));
        fizYurPanel.add((Component)new FaceButton("\u041b\u044e\u0431\u043e\u0435", "0", this.faceButtonGroup, actionListener), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
        fizYurPanel.add((Component)new FaceButton("\u0424\u0438\u0437\u0438\u0447.", "1", this.faceButtonGroup, actionListener), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
        fizYurPanel.add((Component)new FaceButton("\u042e\u0440\u0438\u0434\u0438\u0447.", "2", this.faceButtonGroup, actionListener), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 3), 0, 0));
        JScrollPane scrollPane = new JScrollPane(this.contractLabelTree);
        scrollPane.setBorder(new BGTitleBorder(" \u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        this.fillTable();
        this.maskText.setEditable(true);
        this.maskText.setOpaque(true);
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBorder(new BGTitleBorder(" \u041c\u0430\u0441\u043a\u0430 "));
        textPanel.add((Component)this.maskText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)fizYurPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)textPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void setCurrentFace(String actionCommand) {
        this.currentFace = Utils.parseInt(actionCommand);
    }

    public boolean isNeedFlush() {
        return this.tree != null ? this.tree.isNeedFlush() : false;
    }

    public void setTariffPlanData() throws Exception {
        if (this.tariffPlanId < 1) {
            return;
        }
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("TariffPlanInfo").setAttribute("tpid", this.tariffPlanId);
        org.w3c.dom.Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (!ClientUtils.checkStatus(doc)) {
            return;
        }
        Element plan = XMLUtils.selectElement(doc, "//tariffPlan");
        if (plan == null) {
            return;
        }
        this.tariffPlanId = Utils.parseInt(XMLUtils.getAttribute(plan, "id", "-1"));
        this.isUsedCheckBox.setSelected(Utils.parseBoolean(plan.getAttribute("used"), false));
        this.isWebCheckBox.setSelected(Utils.parseBoolean(plan.getAttribute("useTitleInWeb"), true));
        this.comment.setText(plan.getAttribute("comment"));
        this.description.setText(plan.getAttribute("description"));
        this.maskText.setText(plan.getAttribute("mask"));
        this.config.setText(ClientUtils.linesToString(XMLUtils.selectElement(plan, "//config")));
        this.tariffPlanTitleInGUI.setText(XMLUtils.getAttribute(plan, "title", "\u0411\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f ;-(("));
        this.tariffPlanTitleInWEB.setText(XMLUtils.getAttribute(plan, "titleWeb", this.tariffPlanTitleInGUI.getText()));
        this.currentFace = Utils.parseInt(plan.getAttribute("face"));
        this.faceButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (Utils.parseInt(a.getActionCommand()) == this.currentFace) {
                a.setSelected(true);
            }
        });
        int treeId = Utils.parseInt(plan.getAttribute("tree_id"), -1);
        if (treeId > 0) {
            TariffTree tree = new TariffTree();
            tree.init(this, treeId);
            this.tree = tree;
            this.treePanel.removeAll();
            this.treePanel.add(tree.getViewable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
            this.cardLayout2.show(this.treePanelContainer, "tree");
            tree.addPropertyChangeListener(evt -> {
                if ("needFlush".equals(evt.getPropertyName())) {
                    this.flush.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
                }
            });
        } else {
            this.cardLayout2.show(this.treePanelContainer, "nothing");
        }
        this.fillTable();
        this.setLabelTreeData(this.tariffLabelTree, this.tariffPlanId);
        this.tariffVarsPanel.setTariffPlanId(this.tariffPlanId);
        this.tabbedPane.setSelectedIndex(0);
        this.tabPane1.setSelectedIndex(0);
        this.tabPane2.setSelectedIndex(0);
    }

    public TariffService getTariffService() {
        return this.tariffService.get();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> {
            TariffPlan tariffPlan = TariffPlan.builder().setTitle("New tariff plan").setUsed(true).build();
            this.tariffPlanId = this.getTariffService().tariffPlanUpdate(tariffPlan);
            this.tariffPanel.setData();
            this.tariffPanel.tariffModel.setSelectedRows((Set<Integer>)new HashSet<Integer>(){
                {
                    this.add(TariffPanelEditor.this.tariffPlanId);
                }
            });
            this.showTariffEditor();
            this.performActionOpen();
        });
        new AbstractBGUPanel.DefaultAction("copy", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (TariffPanelEditor.this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                int ans = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0, 3);
                if (ans == 1) {
                    return;
                }
                int sourceTariffPlanId = ((TariffPlanData)TariffPanelEditor.this.tariffPanel.tariffModel.getSelectedRow()).getId();
                Request request = new Request().setModule(((ClientContext)TariffPanelEditor.this.getContext()).getModule()).setAction("CopyTariffPlan").setAttribute("tpid", sourceTariffPlanId);
                ClientSetup.getInstance().putObject("data", request);
                org.w3c.dom.Document doc = ((ClientContext)TariffPanelEditor.this.getContext()).getDocument(request);
                Element tariffPlan = XMLUtils.selectElement(doc, "//tariffPlan");
                TariffPanelEditor.this.tariffPlanId = Utils.parseInt(XMLUtils.getAttribute(tariffPlan, "id", "-1"));
                TariffPanelEditor.this.tryCall(() -> {
                    TariffService tariffService = ((ClientContext)TariffPanelEditor.this.getContext()).getWebService(TariffService.class, 0);
                    List<TariffLabelItem> items = tariffService.getTariffLabelTreeItemList(sourceTariffPlanId);
                    ArrayList<TariffLabelItem> selectedItems = new ArrayList<TariffLabelItem>();
                    for (TariffLabelItem tariffLabelItem : items) {
                        if (!tariffLabelItem.isSelected()) continue;
                        selectedItems.add(tariffLabelItem);
                    }
                    tariffService.setTariffLabelTreeItemList(TariffPanelEditor.this.tariffPlanId, selectedItems);
                    TariffPanelEditor.this.tariffPanel.labelPanel.updateFilterLabelTreeData(tariffService.getTariffLabelTreeItemList(-1));
                });
                TariffPanelEditor.this.tariffPanel.setData();
                TariffPanelEditor.this.tariffPanel.tariffModel.setSelectedRows((Set<Integer>)new HashSet<Integer>(){
                    {
                        this.add(TariffPanelEditor.this.tariffPlanId);
                    }
                });
                TariffPanelEditor.this.showTariffEditor();
                TariffPanelEditor.this.performActionOpen();
            }
        };
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            this.tariffPlanId = ((TariffPlanData)this.tariffPanel.tariffModel.getSelectedRow()).getId();
            this.showTariffEditor();
            this.performActionOpen();
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (this.isShowing()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            if (this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            if (!ClientUtils.confirmDelete(((TariffPlanData)this.tariffPanel.tariffModel.getSelectedRow()).getTitle())) {
                return;
            }
            int sourceTariffPlanId = ((TariffPlanData)this.tariffPanel.tariffModel.getSelectedRow()).getId();
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("DeleteTariffPlan").setAttribute("tpid", sourceTariffPlanId);
            ClientUtils.checkStatus(((ClientContext)this.getContext()).getDocument(request));
            this.tryCall(() -> {
                TariffService tariffService = ((ClientContext)this.getContext()).getWebService(TariffService.class, 0);
                tariffService.setTariffLabelTreeItemList(sourceTariffPlanId, null);
                this.tariffPanel.labelPanel.updateFilterLabelTreeData(tariffService.getTariffLabelTreeItemList(-1));
            });
            this.tariffPanel.setData();
        });
    }

    private void updateTariff() {
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("UpdateTariffPlan").setAttribute("tpid", this.tariffPlanId).setAttribute("tpused", this.isUsedCheckBox.getModel().isSelected() ? 1 : 0).setAttribute("title", this.tariffPlanTitleInGUI.getText().trim()).setAttribute("title_web", this.tariffPlanTitleInWEB.getText().trim()).setAttribute("use_title_in_web", this.isWebCheckBox.getModel().isSelected() ? 1 : 0).setAttribute("values", Utils.toString(this.contractLabelTree.getSelectedIds())).setAttribute("face", this.currentFace).setAttribute("mask", this.maskText.getText()).setAttribute("config", this.config.getText()).setAttribute("comment", this.comment.getText()).setAttribute("description", this.description.getText());
        ClientUtils.checkStatus(((ClientContext)this.getContext()).getDocument(request));
        this.tryCall(() -> {
            this.tariffService.get().setTariffLabelTreeItemList(this.tariffPlanId, this.tariffLabelTree.getSelectedItems());
            this.tariffPanel.labelPanel.updateFilterLabelTreeData(this.tariffService.get().getTariffLabelTreeItemList(-1));
        });
    }

    private void exportTariff() {
        BGFileChooser fc = new BGFileChooser(this);
        fc.setFileFilter(new BGFileFilter("xml", "XML \u0444\u0430\u0439\u043b\u044b"));
        if (fc.showSaveDialog(this) == 0) {
            Object path = fc.getSelectedFile().getAbsolutePath();
            if (!((String)path).endsWith(".xml") && !((String)path).endsWith(".XML")) {
                path = (String)path + ".xml";
            }
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("ExportTariffPlan").setAttribute("tpid", this.tariffPlanId);
            try {
                FileOutputStream fos = new FileOutputStream((String)path);
                InputStream is = ((ClientContext)this.getContext()).getInputStream(request);
                this.flush(is, fos);
                is.close();
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            catch (IOException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void showTariffEditor() {
        this.cardLayout1.show(this.cardPanel, TARIFF_EDITOR);
        this.tryCall(() -> this.setTariffPlanData());
        this.flush.setEnabled(false);
    }

    private void fillTable() {
        if (!this.init) {
            this.addAfterJbInitTask(() -> this.tryCall(() -> this.contractLabelTree.setData(this.tariffPanel.getContractLabelService().getContractLabelTreeItemList(-1, false))));
        }
        if (this.getContext() != null) {
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("GetTariffContractGroups").setAttribute("tpid", this.tariffPlanId);
            org.w3c.dom.Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.tryCall(() -> this.contractLabelTree.setSelectedIds(Utils.toIntegerList(XMLUtils.selectText(doc, "//active/@values", ""))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(InputStream is, OutputStream os) {
        boolean wasFlush = false;
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf, 0, 1024)) != -1) {
                os.write(buf, 0, len);
                wasFlush = true;
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return wasFlush;
    }

    private void setLabelTreeData(TariffLabelTree labelTree, int tariffPlanId) {
        this.tryCall(() -> labelTree.setData(this.tariffService.get().getTariffLabelTreeItemList(tariffPlanId)));
    }

    public int getTariffPlanId() {
        return this.tariffPlanId;
    }

    private class RepeatDocumentListener
    implements DocumentListener {
        private RepeatDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processText(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processText(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processText(e);
        }

        private void processText(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TariffPanelEditor.this.isWebCheckBox.isSelected()) {
                        Document doc = e.getDocument();
                        TariffPanelEditor.this.tryCall(() -> {
                            String text = doc.getText(0, doc.getLength());
                            TariffPanelEditor.this.tariffPlanTitleInWEB.setText(text);
                        });
                    }
                }
            });
        }
    }

    class FaceButton
    extends JToggleButton {
        public FaceButton(String text, String actionCommand, ButtonGroup buttonGroup, ActionListener actionListener) {
            super(text);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
            buttonGroup.add(this);
        }
    }
}

