/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractRemoveRule;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractRemoveRuleDao
extends AbstractIdDao<ContractRemoveRule> {
    public ContractRemoveRuleDao(Connection con) {
        super(con, 0, "contract_remove_rule");
    }

    @Override
    public List<ContractRemoveRule> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(filter, orderBy, params);
    }

    @Override
    protected ContractRemoveRule getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractRemoveRule rule = new ContractRemoveRule();
        rule.setId(rs.getInt("id"));
        rule.setTitle(rs.getString("title"));
        rule.setComment(rs.getString("comment"));
        rule.setDateFrom(TimeUtils.convertDateToLocalDate(TimeUtils.convertTimestampToDate(rs.getTimestamp("date_from"))));
        rule.setDateTo(TimeUtils.convertDateToLocalDate(TimeUtils.convertTimestampToDate(rs.getTimestamp("date_to"))));
        rule.setLabels(Utils.toIntegerList(rs.getString("labels")));
        rule.setStatuses(Utils.toIntegerList(rs.getString("statuses")));
        ContractRemoveRule.RemoveRuleType removeRuleType = ContractRemoveRule.RemoveRuleType.getType(rs.getInt("rule_type"));
        rule.setRemoveRuleType(removeRuleType);
        if (removeRuleType != null && removeRuleType.equals((Object)ContractRemoveRule.RemoveRuleType.TIME)) {
            rule.setTypeRuleRemoveByTime(ContractRemoveRule.TypeRuleRemoveByTime.MONTH);
        } else if (removeRuleType != null && removeRuleType.equals((Object)ContractRemoveRule.RemoveRuleType.BALANCE)) {
            rule.setTypeRuleRemoveByTime(ContractRemoveRule.TypeRuleRemoveByTime.getTypeRule(rs.getInt("type_remove_by_time")));
            rule.setBalance(rs.getBigDecimal("balance"));
        }
        rule.setTimeCount(rs.getInt("time_count"));
        return rule;
    }

    @Override
    protected void updateImpl(ContractRemoveRule removeRule) throws BGException, SQLException {
        if (removeRule.getRemoveRuleType() == null) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
        }
        String set = " SET title=?, comment=?, date_from=?, date_to=?, labels=?, statuses=?, rule_type=?, type_remove_by_time=?, time_count=?, balance=?";
        String query = (removeRule.getId() > 0 ? "UPDATE " : "INSERT INTO ") + this.tableName + set + (removeRule.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, removeRule.getTitle());
            ps.setString(index++, removeRule.getComment());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateToTimestamp(removeRule.getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertLocalDateToTimestamp(removeRule.getDateTo()));
            ps.setString(index++, Utils.toString(removeRule.getLabels()));
            ps.setString(index++, Utils.toString(removeRule.getStatuses()));
            ps.setInt(index++, removeRule.getRemoveRuleType().ordinal());
            ps.setInt(index++, removeRule.getRemoveRuleType().equals((Object)ContractRemoveRule.RemoveRuleType.BALANCE) ? removeRule.getTypeRuleRemoveByTime().ordinal() : ContractRemoveRule.TypeRuleRemoveByTime.MONTH.ordinal());
            ps.setInt(index++, removeRule.getTimeCount());
            ps.setBigDecimal(index++, removeRule.getBalance());
            if (removeRule.getId() > 0) {
                ps.setInt(index, removeRule.getId());
            }
            ps.executeUpdate();
        }
    }
}

