<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'DispatchSession'">Рассылка сессий</xsl:when>
	<xsl:when test="data/@action = 'DispatchAmount'">Рассылка наработки по логинам ( телефонам )</xsl:when>
	<xsl:when test="data/@action = 'DispatchDirect'">Рассылка отчета по направлениям</xsl:when>	
</xsl:choose>
</xsl:template>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'DispatchSession'">
	 	<xsl:call-template name="DispatchSession"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchAmount'">
	 	<xsl:call-template name="DispatchAmount"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchDirect'">
	 	<xsl:call-template name="DispatchDirect"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<!--
вынесено из лаяута и разделено на два темплаейта, в диалапе и в voicei использовалось
TODO убрать условия сравнения модулей, чтобы сократить в 2 раза
-->
<xsl:template name="sessionFilter">
	<xsl:param name="login_title"/>
	<xsl:variable name="module" select="/data/@module"/>
	<table class="filter">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="$login_title"><xsl:value-of select="$login_title"/></xsl:when>
					<xsl:when test="$module!='voice'">Логин:</xsl:when>
					<xsl:when test="$module='voice'">Телефон:</xsl:when>
				</xsl:choose>
			</td>
			<td>
				<select class="gradbtn " name="login">
					<xsl:call-template name="logins_list"/>
				</select>
			</td>
			<xsl:if test="$module!='voiceip'">
			<td>Ед. измерения </td>
			<td>
				<select class="gradbtn " name='unit'>
					<xsl:call-template name="unit_list"/>
				</select>
			</td>
			</xsl:if>
			<td>Месяц:</td>
			<td>
				<select class="gradbtn " name='month'>
					<xsl:call-template name="month_list"/>
				</select>
			</td>
			<td>Год:</td>
			<td>
				<select class="gradbtn " name='year'>
					<xsl:call-template name="year_list"/>
				</select>
			</td>
			<td nowrap="nowrap">Числа месяца:</td>
			<td>c</td>
			<td><input type="text" name="day_from" size="4" value="{date/@day_from}"/></td>
			<td>по</td>
			<td><input type="text" name="day_to" size="4" value="{date/@day_to}"/></td>
			<xsl:if test="$module!='voiceip' and $module!='voice'">
			<td>
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
			</xsl:if>
		</tr>
	</table>
	
	<xsl:if test="$module='voiceip'">
		<table class="filter">
			<tr>
				<td>Тип звонка:</td>
				<td><input type="radio" name="direct" value="0" checked="1" ></input></td>
				<td>все</td>
				<td><input type="radio" name="direct" value="1">
					<xsl:if test="sessions/@direct='1'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input></td>
				<td>исходящие</td>
				<td><input type="radio" name="direct" value="2" >
					<xsl:if test="sessions/@direct='2'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input></td>
				<td>входящие</td>
				<td>
					<input type="checkbox" name="nofree">
					<xsl:if test="sessions/@nofree"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input>
				</td>
				<td>только платные</td>
				
				<td>
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Вывести'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>	
	</xsl:if>
</xsl:template>

<!-- свойства рассылки наработки по логинам -->
<xsl:template name="DispatchAmount">
	<form action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
		<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
		<input type="hidden" name="command" value="save"/>
		
		<div class="report">
			<table cellspacing='1' class="table800">
			<thead>
				<tr>
		  			<td>Поле</td>
		  			<td>Данные</td>
		  			<td>Комментарий</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>Название:</td>
					<td>
						<!-- 
						<input type="text" name="title" size="32">
						<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
						</input>
						-->
						<input type="text" name="title" size="32" value="{dispatch/@title}"/>
					</td>
					<td><em class="comment">
						Название вашей рассылки, например 'Наработка по логинам voip'.	
						Это название будет указано в теле письма.</em>
					</td>
		  		</tr>
		  		<tr>	
					<td>Адреса:</td>
					<td>
						<textarea name="mails" rows="4" cols="25">
							<xsl:for-each select="dispatch/mail">
							<xsl:value-of select="@value"/>
							<xsl:if test="position() != last()">
								<xsl:value-of select="'	
								'"/>
							</xsl:if>
							</xsl:for-each>
						</textarea>
					</td>
					<td><em class="comment">
						Перечень адресов на которые будут приходить данная рассылка.
						Каждый адрес с новой строки.</em>
					</td>
  		  		</tr>
  		  		<tr>			
					<td>Статус:</td>
					<td>
						<select name="status">
							<option value="0">неактивна</option>
							<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
						</select>
					</td>
					<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
				</tr>
				<tr>	
					<td nowrap="1">Дни недели ( 1-7 ):</td>
					<td>
						<input type="text" name="dw">
							<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
						</input>
					</td>
					<td><em class="comment">
						Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник )
						в которые вам будет высылаться рассылка.</em>
					</td>
		 		</tr>		  
		  		<tr>
					<td colspan="3">
						<xsl:call-template name="okCancel">
							<xsl:with-param name="title1" select="'Сохранить'"/>
							<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
						</xsl:call-template>
					</td>
		  		</tr>
			</tbody>
			</table>
		</div>	
	</form>		
</xsl:template>

<!-- свойства рассылки сессий логина -->
<xsl:template name="DispatchSession">
	<form action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
		<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
		<input type="hidden" name="command" value="save"/>
		
		<div class="report">
			<table cellspacing='1' class="table800">
			<thead>
		  		<tr>
		  			<td>Поле</td>
		  			<td>Данные</td>
		  			<td>Комментарий</td>
		  		</tr>
			</thead>
			<tbody>
		  		<tr>
					<td>Название:</td>
					<td>
						<input type="text" name="title" size="32">
							<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
						</input>
					</td>
					<td><em class="comment">
						Название вашей рассылки, например 'Сессии логина test'.	
						Это название будет указано в теле письма.</em>
					</td>
		  		</tr>
		  		<tr>
					<td>Логин:</td>
					<td>
						<select name="lid">
						<xsl:for-each select="/data/logins/item">
          				<option>
              				<xsl:if test="/data/dispatch/@lid=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              				<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              				<xsl:value-of select="@title"/>
          				</option>
      					</xsl:for-each>	
						</select>
					</td>
					<td>
						<em class="comment">Логин, сессии которого будут высылаться.</em>
					</td>
		  		</tr>
		  		<tr>	
					<td>Адреса:</td>
					<td>
						<textarea name="mails" rows="4" cols="25">
						<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
						</xsl:for-each>
						</textarea>
					</td>
					<td><em class="comment">
						Перечень адресов на которые будут приходить данная рассылка.
						Каждый адрес с новой строки.</em>
					</td>
  		  		</tr>  		  
  		  		<tr>			
					<td>Статус:</td>
					<td>
						<select name="status">
							<option value="0">неактивна</option>
							<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
						</select>
					</td>
					<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 		</tr>
		 		<tr>	
					<td nowrap="1">Дни недели ( 1-7 ):</td>
					<td>
						<input type="text" name="dw">
							<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
						</input>
					</td>
					<td><em class="comment">
						Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник )
						в которые вам будет высылаться рассылка.</em>
					</td>
		 		</tr>		  
		  		<tr>
					<td colspan="3">
						<xsl:call-template name="okCancel">
							<xsl:with-param name="title1" select="'Сохранить'"/>
							<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
						</xsl:call-template>		
					</td>
		  		</tr>
			</tbody>
			</table>
		</div>
	</form>		
</xsl:template>

<!-- свойства рассылки отчета по направлениям -->
<xsl:template name="DispatchDirect">
	<form action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
		<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
		<input type="hidden" name="command" value="save"/>
		
		<div class="report">
			<table cellspacing="1" class="table800">
			<thead>
				<tr>
		  			<td>Поле</td>
		  			<td>Данные</td>
		  			<td>Комментарий</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>Название:</td>
					<td>
						<input type="text" name="title" size="32">
							<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
						</input>
					</td>
					<td><em class="comment">
						Название вашей рассылки, например 'Отчет по направлениям звонков с телефона 11111'.	
						Это название будет указано в теле письма.</em>
					</td>
		  		</tr>
		  		<tr>
					<td>
						<xsl:if test="/data/@module = 'voiceip'">Логин:</xsl:if>
						<xsl:if test="/data/@module = 'voice'">Телефон:</xsl:if>			
					</td>
					<td>
						<select name="lid">
						<xsl:for-each select="/data/logins/item">
          				<option>
              				<xsl:if test="/data/dispatch/@lid=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              				<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              				<xsl:value-of select="@title"/>
          				</option>
      					</xsl:for-each>	
						</select>
					</td>
					<td><em class="comment">Логин ( телефон ), сессии которого будут высылаться.</em></td>
		  		</tr>
		  		<tr>	
					<td>Адреса:</td>
					<td>
						<textarea name="mails" rows="4" cols="25">
						<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
						</xsl:for-each>
						</textarea>
					</td>
					<td><em class="comment">
						Перечень адресов на которые будут приходить данная рассылка.
						Каждый адрес с новой строки.</em>
					</td>
  		  		</tr>
  		  		<tr>			
					<td>Статус:</td>
					<td>
						<select name="status">
							<option value="0">неактивна</option>
							<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
						</select>
					</td>
					<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 		</tr>
		 		<tr>	
					<td nowrap="1">Дни недели ( 1-7 ):</td>
					<td><input type="text" name="dw"><xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute></input></td>
					<td><em class="comment">Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник ) в которые вам будет высылаться рассылка.</em></td>
		 		</tr>		  
		  		<tr>
					<td colspan="3">
						<xsl:call-template name="okCancel">
							<xsl:with-param name="title1" select="'Сохранить'"/>
							<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
						</xsl:call-template>	
					</td>
				</tr>
			</tbody>
			</table>
		</div>
	</form>		
</xsl:template>

<xsl:template name="AddReportReferences">
		<div>
		Отчет в виде:
		<a title="CSV" href="{$WEBEXECUTER}?module=voiceip&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=csv">CSV</a>,
		<a title="HTML" href="{$WEBEXECUTER}?module=voiceip&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=html">HTML</a>,
		<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=voiceip&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=voiceip&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a> (После изменения фильтра сначала нажмите "Вывести")
		</div>
</xsl:template>

</xsl:stylesheet>
