/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.bean;

import java.math.BigDecimal;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Check
extends ru.bitel.bgbilling.plugins.cashcheck.common.Check {
    public Check() {
    }

    public Check(Check.Type checkType) {
        super(checkType);
    }

    public static Check fromCheckData(String checkData) throws BGException {
        if (Utils.isBlankString((String)checkData)) {
            throw new BGException("empty check data");
        }
        if (!checkData.endsWith("\n")) {
            throw new BGException("incorrect check data - last not newline");
        }
        String[] parameters = (checkData = checkData.substring(0, checkData.length() - 1)).split("\\r?\\n", -1);
        if (parameters.length % 3 != 0) {
            throw new BGException("incorrect check data (num lines: " + parameters.length + ")");
        }
        Check commandCheckParameters = new Check();
        BigDecimal summa = BigDecimal.valueOf(0L, 2);
        for (int i = 0; i < parameters.length; i += 3) {
            String s = parameters[i];
            String t = parameters[i + 1];
            String d = parameters[i + 2];
            if ("STRING".equals(s)) {
                commandCheckParameters.lines.add(new Check.CheckLine(null, t, -1));
                continue;
            }
            if ("CUSTOMEREMAIL".equals(s)) {
                commandCheckParameters.customerEmail = t;
                continue;
            }
            if ("TAX".equals(s)) {
                commandCheckParameters.tax = Integer.parseInt(t);
                continue;
            }
            if ("PAYMENTTYPE".equals(s)) {
                commandCheckParameters.paymentType = Integer.parseInt(t);
                continue;
            }
            if ("ONLYELCHECK".equals(s)) {
                commandCheckParameters.onlyElCheck = Utils.parseBoolean((String)t, (boolean)false);
                continue;
            }
            if ("CUSTOMTAG".equals(s)) {
                Check._CUSTOMTAG_decode((String)t, (Map)commandCheckParameters.customTags);
                continue;
            }
            if ("TAG".equals(s)) {
                String[] tv = t.split(";");
                if (tv.length != 2) continue;
                int tag = Integer.parseInt(tv[0]);
                byte[] value = Utils.hexStringToBytes((String)tv[1]);
                commandCheckParameters.setTag(tag, value);
                continue;
            }
            if ("PAYMETHOD".equals(s)) {
                commandCheckParameters.payMethod = Integer.parseInt(t);
                continue;
            }
            if ("PAYOBJECT".equals(s)) {
                commandCheckParameters.payObject = Integer.parseInt(t);
                continue;
            }
            if ("CHECKTYPE".equals(s)) {
                commandCheckParameters.checkType = Check.Type.valueOf((String)t);
                continue;
            }
            if ("CASHIERNAME".equals(s)) {
                commandCheckParameters.cashierName = t;
                continue;
            }
            if ("CASHIERINN".equals(s)) {
                commandCheckParameters.cashierINN = t;
                continue;
            }
            if ("DOCUMENTDATE".equals(s)) {
                commandCheckParameters.documentDate = TimeUtils.parseDate((String)t, (String)"dd.MM.yyyy HH:mm:ss");
                continue;
            }
            if ("DOCUMENTID".equals(s)) {
                commandCheckParameters.documentId = t;
                continue;
            }
            if ("PAYMETHOD_ITEM".equals(s)) {
                int PAYMETHOD_value = Integer.parseInt(t);
                ((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).payMethod = PAYMETHOD_value;
                continue;
            }
            if ("PAYOBJECT_ITEM".equals(s)) {
                int PAYOBJECT_value = Integer.parseInt(t);
                ((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).payObject = PAYOBJECT_value;
                continue;
            }
            if ("TAX_ITEM".equals(s)) {
                int TAX_value = Integer.parseInt(t);
                ((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).tax = TAX_value;
                continue;
            }
            if ("QUANTITY_ITEM".equals(s)) {
                int QUANTITY_value = Integer.parseInt(t);
                ((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).quantity = QUANTITY_value;
                continue;
            }
            if ("MEASURE_ITEM".equals(s)) {
                int MEASURE_value = Integer.parseInt(t);
                ((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).measure = MEASURE_value;
                continue;
            }
            if ("CUSTOMTAG_ITEM".equals(s)) {
                Check._CUSTOMTAG_decode((String)t, (Map)((Check.CheckLine)commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1))).customTags);
                continue;
            }
            if (!d.isEmpty()) {
                BigDecimal sum = new BigDecimal(s);
                sum = Check._roundSum((BigDecimal)sum);
                int dep = Integer.parseInt(d);
                commandCheckParameters.lines.add(new Check.CheckLine(sum, t, dep));
                summa = summa.add(sum);
                continue;
            }
            throw new BGException("UNKNOWN TAG: " + s + "|" + t + "|" + d);
        }
        commandCheckParameters.paymentsum = summa;
        return commandCheckParameters;
    }
}

