/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

public class InetAccountingPeriodDao
extends AbstractIdDao<InetAccountingPeriod> {
    private int userId;

    @Deprecated
    public InetAccountingPeriodDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_accounting_period");
        this.userId = 0;
    }

    public InetAccountingPeriodDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, "inet_accounting_period");
        this.userId = userId;
    }

    protected InetAccountingPeriod getFromRS(ResultSet rs) throws SQLException {
        InetAccountingPeriod result = new InetAccountingPeriod();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contractId"));
        result.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom")));
        result.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo")));
        result.setUserId(rs.getInt("userId"));
        return result;
    }

    protected void updateImpl(InetAccountingPeriod b) throws SQLException {
        String query = "SELECT id, timeFrom, timeTo FROM " + this.tableName + " WHERE contractId=? AND id!=? AND timeFrom<=? AND ?<=timeTo LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, b.getContractId());
            ps.setInt(2, b.getId());
            ps.setTimestamp(3, TimeUtils.convertDateToTimestampSeconds((Date)b.getDateTo()));
            ps.setTimestamp(4, TimeUtils.convertDateToTimestampSeconds((Date)b.getDateFrom()));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int id = rs.getInt(1);
                Date timeFrom = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2));
                Date timeTo = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(3));
                InetAccountingPeriod oldPeriod = new InetAccountingPeriod();
                oldPeriod.setId(id);
                oldPeriod.setDateFrom(timeFrom);
                oldPeriod.setDateTo(timeTo);
                throw new BGRuntimeException("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0434\u043b\u044f contractId=" + b.getContractId() + ", " + String.valueOf(oldPeriod) + ". \u041d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434: " + String.valueOf(b));
            }
        }
        String querySet = "contractId=?, timeFrom=?, timeTo=?, userId=?";
        try (PreparedStatement ps = this.prepareStatement((Id)b, querySet);){
            int index = 1;
            ps.setInt(index++, b.getContractId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)b.getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)b.getDateTo()));
            ps.setInt(index++, this.userId);
            this.executeUpdate((Id)b, index, ps);
        }
    }

    public List<InetAccountingPeriod> list(int contractId) throws SQLException {
        return this.list("contractId=?", "timeFrom DESC", new Object[]{contractId});
    }

    public List<InetAccountingPeriod> list(int contractId, Date dateFrom, boolean lockInShareMode) throws SQLException {
        if (!lockInShareMode) {
            return this.list(contractId, dateFrom);
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE contractId=? AND (timeTo IS NULL OR timeTo>=?) ORDER BY timeFrom LOCK IN SHARE MODE";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<InetAccountingPeriod> result = new ArrayList<InetAccountingPeriod>();
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateFrom));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
            ArrayList<InetAccountingPeriod> arrayList = result;
            return arrayList;
        }
    }

    public List<InetAccountingPeriod> list(int contractId, Date dateFrom) throws SQLException {
        return this.list("contractId=? AND (timeTo IS NULL OR timeTo>=?)", "timeFrom", new Object[]{contractId, TimeUtils.convertDateToTimestamp((Date)dateFrom)});
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }
}

