/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class AccountRangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"period_yel.gif");
    private JLabel view;
    private BGFloatTextField fromTf;
    private BGFloatTextField toTf;
    private BGComboBox<IdTitle> accountCombo;
    private int amount;
    private String from;
    private String to;
    private Directory dir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.dir = this.getDirManager().getDirectory("module_accounts");
    }

    private void initEdit() throws Exception {
        if (this.accountCombo == null) {
            this.accountCombo = new BGComboBox(this.dir.getItems());
            this.fromTf = new BGFloatTextField();
            this.toTf = new BGFloatTextField();
        }
    }

    protected JPanel getEditorPanel() throws Exception {
        this.initEdit();
        JPanel edit = new JPanel();
        edit.add(new JLabel("\u0415\u0441\u043b\u0438 "));
        edit.add((Component)this.accountCombo);
        edit.add(new JLabel(" \u043e\u0442 "));
        edit.add((Component)this.fromTf);
        edit.add(new JLabel(" \u0434\u043e "));
        edit.add((Component)this.toTf);
        return edit;
    }

    public Component getView() throws Exception {
        this.extractData();
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        StringBuffer title = new StringBuffer(150);
        title.append("\u0415\u0441\u043b\u0438 ");
        String amountTitle = this.dir.getValue(this.amount);
        title.append(amountTitle);
        title.append(" \u043e\u0442 ");
        title.append(this.from);
        title.append(" \u0434\u043e ");
        title.append(this.to);
        this.view.setText(title.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.amount = Utils.parseInt((String)((String)data.get("account")), (int)0);
        this.from = (String)data.get("from");
        this.to = (String)data.get("to");
    }

    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.accountCombo, this.amount);
        this.fromTf.setText(this.from);
        this.toTf.setText(this.to);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(5);
        data.put("from", this.fromTf.getText());
        data.put("to", this.toTf.getText());
        data.put("account", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.accountCombo)));
        this.setDataInHash(data);
    }
}

