/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class SPP_Forward
extends ServicePanel
implements ActionListener {
    private int editMode = 0;
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private JList<BGUListItem> forwards = new JList();

    public SPP_Forward() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.dialogToolBar.setDefaultButtons((ActionListener)this);
        this.dialogToolBar.setFloatable(false);
        this.dialogToolBar.setOrientation(1);
        this.dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.forwards.setModel(new DefaultListModel());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane(this.forwards), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.forwards, e -> this.editItem());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int pos;
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.editMode = 2;
            new ForwardEditor("\u041d\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441", "").open();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand) && (pos = this.forwards.getSelectedIndex()) >= 0) {
            ((DefaultListModel)this.forwards.getModel()).remove(pos);
        }
    }

    public void editItem() {
        this.editMode = 1;
        Optional.ofNullable(this.forwards.getSelectedValue()).ifPresentOrElse(item -> new ForwardEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430", item.getTitle()).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!"));
    }

    public void setData() {
        ((DefaultListModel)this.forwards.getModel()).clear();
        if (this.id > 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("ForwardList");
            request.setAttribute("aid", this.id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList(this.forwards, (Node)XMLUtils.getNode((Document)doc, (String)"forward_list"));
            }
        }
    }

    public boolean updateData() {
        boolean result = true;
        if (this.id > 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("UpdateForwards");
            request.setAttribute("aid", this.id);
            StringBuffer forwards = new StringBuffer(100);
            DefaultListModel model = (DefaultListModel)this.forwards.getModel();
            BGUListItem li = null;
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                li = (BGUListItem)model.getElementAt(i);
                if (forwards.length() > 0) {
                    forwards.append(";");
                }
                forwards.append(li.getTitle());
            }
            request.setAttribute("forwards", (Object)forwards);
            result = ClientUtils.checkStatus((Document)this.getDocument(request));
        }
        return result;
    }

    public void setDocument(Document doc) {
    }

    class ForwardEditor
    extends BGEditorDialog<String> {
        private BGTextField value;

        public ForwardEditor(String title, String data) {
            super(title, (Object)data);
            this.value = new BGTextField(30);
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.value, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.value.setText((String)this.data);
        }

        public boolean doApply() throws Exception {
            if (this.value.getText().length() > 0 && this.value.getText().indexOf("@") > 0) {
                if (SPP_Forward.this.editMode == 1) {
                    SPP_Forward.this.forwards.getSelectedValue().setTitle(this.value.getText());
                } else {
                    ((DefaultListModel)SPP_Forward.this.forwards.getModel()).addElement(new BGUListItem(0, this.value.getText()));
                }
                return true;
            }
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 E-Mail!");
            return false;
        }
    }
}

