/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.function.Lazy;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.TimeoutListMapOld;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

public class InetDhcpOfferedAddressMap2 {
    private final TimeoutMap<OfferKey, Offered> map = new TimeoutMap("dhcp-offer-cleaner");
    private final TimeoutListMapOld<Integer, Offered> servMap = new TimeoutListMapOld(new DelayQueue(), "dhcp-offer-cleaner");
    private final boolean useXid;

    public InetDhcpOfferedAddressMap2() {
        this(true);
    }

    public InetDhcpOfferedAddressMap2(boolean useXid) {
        this.useXid = useXid;
    }

    public Offered offerFromServs(int deviceId, Integer inetServId, int xid, byte[] mac, InetServ serv, List<InetServRuntime> childrenServRuntimeList, Supplier<HashSet<IpAddress>> usedAddressSet, int errorCode, long offerTimeout, long dhcpBanCheckTimeout, byte[] onlyAddress) {
        Supplier<HashSet<IpAddress>> parentUsedAddressSet = this.usedAddressFromParentRange(serv, childrenServRuntimeList, usedAddressSet);
        Offered result = this.offerFromServ(deviceId, inetServId, xid, mac, serv, errorCode, parentUsedAddressSet, offerTimeout, dhcpBanCheckTimeout, onlyAddress);
        if (result != null) {
            return result;
        }
        if (childrenServRuntimeList == null || childrenServRuntimeList.size() == 0) {
            return null;
        }
        int size = childrenServRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            InetServRuntime childServRuntime = childrenServRuntimeList.get(i);
            InetServ childServ = childServRuntime.getInetServ();
            if (childServ.getMacAddressListBytes() != null && childServ.getMacAddressListBytes().length > 0 || childServRuntime.getInetServTypeRuntime().dhcpNoAddress || (result = this.offerFromServ(deviceId, inetServId, xid, mac, childServRuntime.getInetServ(), errorCode, usedAddressSet, offerTimeout, dhcpBanCheckTimeout, onlyAddress)) == null) continue;
            return result;
        }
        return null;
    }

    private Supplier<HashSet<IpAddress>> usedAddressFromParentRange(InetServ serv, List<InetServRuntime> childrenServRuntimeList, Supplier<HashSet<IpAddress>> usedAddressSet) {
        byte[] addressFrom = serv.getAddressFrom();
        if (addressFrom == null) {
            return usedAddressSet;
        }
        if (childrenServRuntimeList == null || childrenServRuntimeList.size() == 0) {
            return usedAddressSet;
        }
        HashSet<IpAddress> childAddresses = null;
        int size = childrenServRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            InetServ childServ;
            InetServRuntime childServRuntime = childrenServRuntimeList.get(i);
            if (!childServRuntime.getInetServTypeRuntime().inetServType.isIpFromParentRange() || (childServ = childServRuntime.getInetServ()).getMacAddressListBytes() == null || childServ.getMacAddressListBytes().length == 0 || childServ.getAddressFrom() == null) continue;
            if (childAddresses == null) {
                childAddresses = new HashSet<IpAddress>();
            }
            childAddresses.add(new IpAddress(childServ.getAddressFrom()));
        }
        if (childAddresses == null) {
            return usedAddressSet;
        }
        HashSet<IpAddress> childAddresses_ = childAddresses;
        return Lazy.of(() -> {
            HashSet result = (HashSet)usedAddressSet.get();
            result.addAll(childAddresses_);
            return result;
        });
    }

    private Offered offerFromServ(int deviceId, Integer inetServId, int xid, byte[] mac, InetServ serv, int errorCode, Supplier<HashSet<IpAddress>> usedAddressSet, long offerTimeout, long dhcpBanCheckTimeout, byte[] onlyAddress) {
        long now;
        byte[] result = null;
        byte[] addressFrom = serv.getAddressFrom();
        if (addressFrom == null || addressFrom.length != 4) {
            return null;
        }
        Set usedAddress = usedAddressSet.get();
        byte[] addressTo = serv.getAddressTo();
        if (addressTo != null && !IpAddress.equals((byte[])addressFrom, (byte[])addressTo)) {
            now = System.currentTimeMillis();
            List offered = this.servMap.get((Comparable)Integer.valueOf(serv.getId()));
            if (offered != null) {
                int size = offered.size();
                for (int i = 0; i < size; ++i) {
                    Offered reserve = (Offered)offered.get(i);
                    if (now > reserve.expired) continue;
                    usedAddress.add(new IpAddress(reserve.resource.getAddress()));
                }
            }
            byte[] addressVar = new byte[addressFrom.length];
            System.arraycopy(addressFrom, 0, addressVar, 0, addressFrom.length);
            IpAddress address = new IpAddress(addressVar);
            while (IpAddress.compare((byte[])address.address, (byte[])addressTo) <= 0) {
                if (!usedAddress.contains(address) && (onlyAddress == null || IpAddress.equals((byte[])address.address, (byte[])onlyAddress))) {
                    result = address.address;
                    break;
                }
                IpAddress.increment((byte[])address.address);
            }
        } else {
            IpAddress address = new IpAddress(addressFrom);
            if (!usedAddress.contains(address) && (onlyAddress == null || IpAddress.equals((byte[])address.address, (byte[])onlyAddress))) {
                result = address.address;
            }
            now = System.currentTimeMillis();
        }
        if (result == null) {
            return null;
        }
        if (!this.useXid) {
            xid = 0;
        }
        IpResourceReserve resource = new IpResourceReserve(serv.getIpResourceId(), result, 0L);
        long mapTimeout = now + dhcpBanCheckTimeout;
        Offered offered = new Offered(resource, errorCode, now + offerTimeout, 0);
        this.map.put((Object)new OfferKey(deviceId, xid, mac), (Object)offered, mapTimeout);
        this.servMap.add((Map.Entry)new InetServOfferKey(inetServId, offered, mapTimeout));
        return offered;
    }

    public Offered offer(int deviceId, Integer inetServId, int xid, byte[] mac, IpResourceReserve resource, int errorCode, int ipOfferCounter, long offerTimeout, long dhcpBanCheckTimeout) {
        long now = System.currentTimeMillis();
        if (!this.useXid) {
            xid = 0;
        }
        Offered result = new Offered(resource, errorCode, now + offerTimeout, ipOfferCounter);
        this.map.put((Object)new OfferKey(deviceId, xid, mac), (Object)result, now + dhcpBanCheckTimeout);
        return result;
    }

    public Offered getOffered(int deviceId, Integer inetServId, int xid, byte[] mac) {
        if (!this.useXid) {
            xid = 0;
        }
        Offered result = (Offered)this.map.get((Object)new OfferKey(deviceId, xid, mac));
        return result;
    }

    public Set<Map.Entry<OfferKey, Offered>> entrySet() {
        return this.map.entrySet();
    }

    static final class Offered {
        public final IpResourceReserve resource;
        public final int errorCode;
        public long expired;
        public final int ipOfferCounter;
        public volatile int discoverCounter = 1;
        public volatile boolean asyncStart;
        volatile Future<InetConnection> asyncStartFuture;

        public Offered(IpResourceReserve resource, int errorCode, long expired, int discoverCounter) {
            this.resource = resource;
            this.errorCode = errorCode;
            this.expired = expired;
            this.ipOfferCounter = discoverCounter;
        }
    }

    static final class OfferKey {
        final int deviceId;
        final int xid;
        final byte[] mac;

        public OfferKey(int deviceId, int xid, byte[] mac) {
            this.deviceId = deviceId;
            this.xid = xid;
            this.mac = mac;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.deviceId) + this.xid) + Arrays.hashCode(this.mac);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            OfferKey other = (OfferKey)obj;
            return this.deviceId == other.deviceId && this.xid == other.xid && Arrays.equals(this.mac, other.mac);
        }
    }

    static final class InetServOfferKey
    implements Map.Entry<Integer, Offered>,
    Delayed {
        private Integer key;
        private Offered value;
        private final long expire;

        @Override
        public Integer getKey() {
            return this.key;
        }

        public void setKey(Integer key) {
            this.key = key;
        }

        @Override
        public Offered getValue() {
            return this.value;
        }

        @Override
        public Offered setValue(Offered value) {
            this.value = value;
            return this.value;
        }

        public InetServOfferKey(Integer key, Offered value, long expire) {
            this.key = key;
            this.value = value;
            this.expire = expire;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            InetServOfferKey x = (InetServOfferKey)other;
            long diff = this.expire - x.expire;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

