/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TaskData
extends LightweightTaskData
implements Runnable {
    private List<TaskBase> tasksForRun = new LinkedList<TaskBase>();

    public TaskData(int month, int day, int dayOfWeek, int hour, long min) {
        super(month, day, dayOfWeek, hour, min);
    }

    public void init(Calendar time, Setup setup) {
        try {
            Object task;
            this.tasksForRun.clear();
            if (Utils.notBlankString((String)this.getClassName()) && (task = (TaskBase)Class.forName(this.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0])) != null && this.getTaskStatus().equals((Object)TaskStatus.ENABLE)) {
                ((TaskBase)task).setExecutingTime(time).setModuleId(this.getModuleId()).setPriority(this.getPriority()).initTask(setup, this.getId(), this.getParams());
                this.tasksForRun.add((TaskBase)task);
            }
            if (this.dependentTasks != null) {
                for (DependentTask dependentTask : this.dependentTasks) {
                    TaskBase task2;
                    if (TaskStatus.DISABLE.equals((Object)dependentTask.getTaskStatus()) || (task2 = (TaskBase)Class.forName(dependentTask.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0])) == null) continue;
                    task2.setExecutingTime(time).setModuleId(dependentTask.getModuleId()).setPriority(dependentTask.getPriority() == 0 ? this.getPriority() : dependentTask.getPriority()).initTask(setup, this.getId(), dependentTask.getParams());
                    this.tasksForRun.add(task2);
                }
            }
        }
        catch (Exception ex) {
            new BGLogger().getLogger().error("Error init task #" + this.getId() + " (" + this.className + ")", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        for (TaskBase task : this.tasksForRun) {
            int priority = task.getPriority();
            if (priority < 1 || priority > 10) {
                priority = 5;
            }
            Thread.currentThread().setPriority(priority);
            task.run();
        }
    }

    public boolean canWork(Calendar time) {
        return TimeUtils.checkMasks((Calendar)time, (int)this.hour, (int)this.dayOfWeek, (int)this.month, (int)this.day) && (this.min == 0L || (this.min & 1L << time.get(12)) > 0L);
    }

    @Override
    public void setDependentTasks(List<DependentTask> dependentTasks) {
        if (Utils.notEmptyCollection(dependentTasks)) {
            this.dependentTasks.clear();
            this.dependentTasks.addAll(dependentTasks);
        }
    }
}

