/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.File;
import ru.bitel.common.model.Description;
import ru.bitel.common.model.GuiTitlable;

public class DynamicClass
implements GuiTitlable {
    private String className;
    private long lastModified;
    private boolean needsRecompile;
    private boolean deprecated;
    private String description;

    public DynamicClass() {
    }

    public DynamicClass(String className, long lastModified) {
        this.className = className;
        this.lastModified = lastModified;
    }

    public DynamicClass(String className, long lastModified, String resourceExt) {
        this.className = className + ":" + resourceExt.replace(".", ":");
        this.lastModified = lastModified;
    }

    @XmlAttribute
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @XmlAttribute
    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setNeedsRecompile(boolean needsRecompile) {
        this.needsRecompile = needsRecompile;
    }

    @XmlAttribute
    public boolean isNeedsRecompile() {
        return this.needsRecompile;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAnnotations(Class<?> clazz) {
        this.setDeprecated(clazz.getAnnotation(Deprecated.class) != null);
        Description description = clazz.getAnnotation(Description.class);
        this.setDescription(description != null ? description.value() : null);
    }

    public boolean isJavaSource() {
        return DynamicClass.isJavaSource(this.className);
    }

    public String getResourcePackageName() {
        return DynamicClass.getResourcePackageName(this.className);
    }

    public static boolean isJavaSource(String className) {
        return className.indexOf(58) == -1;
    }

    public static String getResourceExt(String className) {
        int resExtDelim = className.indexOf(58);
        return resExtDelim >= 0 ? className.substring(resExtDelim + 1).replace(":", ".") : "java";
    }

    public static String getResourceName(String className) {
        int resExtDelim = className.indexOf(58);
        return resExtDelim >= 0 ? className.substring(0, resExtDelim) : className;
    }

    public static String getResourceSimpleName(String className) {
        String resName = DynamicClass.getResourceName(className);
        int lastDot = resName.lastIndexOf(46);
        return resName.substring(lastDot + 1);
    }

    public static String getResourcePackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        return lastDot >= 0 ? className.substring(0, lastDot) : "";
    }

    public static String getResourceFileSimpleName(String className) {
        return DynamicClass.getResourceSimpleName(className) + "." + DynamicClass.getResourceExt(className);
    }

    public String getResourceFileSimpleName() {
        return DynamicClass.getResourceFileSimpleName(this.className);
    }

    public static File getClassFile(String parent, String className) {
        String extension = DynamicClass.getResourceExt(className);
        int innerClassDelim = (className = DynamicClass.getResourceName(className)).indexOf(36);
        String path = innerClassDelim >= 0 ? className.substring(0, innerClassDelim) : className;
        path = path.replace('.', File.separatorChar);
        return new File(parent, path + "." + extension);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicClass other = (DynamicClass)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    public String toString() {
        String className = this.className.replaceFirst("ru.bitel.bgbilling.modules.", "r.b.b.m.");
        className = className.replaceFirst("ru.bitel.bgbilling.kernel.", "r.b.b.k.");
        className = className.replaceFirst("ru.bitel.bgbilling.", "r.b.b.");
        return className + (this.deprecated ? " (deprecated)" : "");
    }

    @Override
    public String getGuiTitle() {
        return this.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DynamicClass dynamicClass = new DynamicClass();

        private Builder() {
        }

        public Builder setClassName(String className) {
            this.dynamicClass.className = className;
            return this;
        }

        public Builder setAnnotations(Class<?> clazz) {
            this.dynamicClass.setAnnotations(clazz);
            return this;
        }

        public DynamicClass build() {
            try {
                DynamicClass dynamicClass = this.dynamicClass;
                return dynamicClass;
            }
            finally {
                this.dynamicClass = null;
            }
        }
    }
}

