/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.area.PageViewport;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.fop.render.java2d.Java2DRendererConfig;
import org.apache.fop.render.java2d.Java2DRendererConfigurator;
import org.apache.fop.render.print.PrintRenderer;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class FOUtils {
    public static final String RENDER_PDF = "application/pdf";
    public static final String RENDER_RTF = "application/rtf";
    public static final String RENDER_AWT = "application/X-fop-awt-preview";
    public static final String RENDER_PRINT = "application/X-fop-print";
    private static FopFactory fopFactory;

    public static FOUserAgent newFOUserAgent() {
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.setProducer("BGBilling 10.2504");
        userAgent.setCreationDate(new Date());
        return userAgent;
    }

    public static SAXResult renderSAXResult(OutputStream outputStream, String outputFormat) throws FOPException {
        Fop fop = FOUtils.newFOUserAgent().newFop(outputFormat, outputStream);
        return new SAXResult(fop.getDefaultHandler());
    }

    private static SAXResult renderSAXResult(FOUserAgent userAgent, String outputFormat) throws FOPException {
        Fop fop = userAgent.newFop(outputFormat, null);
        return new SAXResult(fop.getDefaultHandler());
    }

    private static Transformer newTransformer(Source xslt) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(xslt);
        return transformer;
    }

    private static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        return transformer;
    }

    public static void render(Source xml, Source xslt, OutputStream outputStream, String outputFormat) throws FOPException, TransformerException {
        FOUtils.newTransformer(xslt).transform(xml, FOUtils.renderSAXResult(outputStream, outputFormat));
    }

    public static void render(Source fo, OutputStream outputStream, String outputFormat) throws FOPException, TransformerException {
        FOUtils.newTransformer().transform(fo, FOUtils.renderSAXResult(outputStream, outputFormat));
    }

    public static void render(Source xml, Source xslt, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUserAgent fua = renderer.getUserAgent() != null ? renderer.getUserAgent() : FOUtils.newFOUserAgent();
        FOUtils.newTransformer(xslt).transform(xml, FOUtils.renderSAXResult(fua, outputFormat));
    }

    public static void render(Source fo, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUserAgent fua = renderer.getUserAgent() != null ? renderer.getUserAgent() : FOUtils.newFOUserAgent();
        FOUtils.newTransformer().transform(fo, FOUtils.renderSAXResult(fua, outputFormat));
    }

    public static void render(Node fo, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUtils.render((Source)new DOMSource(fo), renderer, outputFormat);
    }

    public static AWTRenderer createAWTRenderer() {
        FOUserAgent userAgent = FOUtils.newFOUserAgent();
        _PatchedAWTRenderer renderer = new _PatchedAWTRenderer(userAgent);
        FOUtils.configure2DRenderer((Java2DRenderer)renderer);
        return renderer;
    }

    public static PrintRenderer createPrintRenderer(PrinterJob printerJob, int copies) {
        FOUserAgent userAgent = FOUtils.newFOUserAgent();
        userAgent.getRendererOptions().put("printerjob", printerJob);
        userAgent.getRendererOptions().put("copies", copies);
        PrintRenderer renderer = new PrintRenderer(userAgent);
        FOUtils.configure2DRenderer((Java2DRenderer)renderer);
        return renderer;
    }

    public static void configure2DRenderer(Java2DRenderer renderer) {
        try {
            Java2DRendererConfigurator rc = new Java2DRendererConfigurator(renderer.getUserAgent(), (RendererConfig.RendererConfigParser)new Java2DRendererConfig.Java2DRendererConfigParser(renderer.getMimeType()));
            rc.configure((Renderer)renderer);
        }
        catch (Exception e) {
            throw new RuntimeException("fop library error configure2DRenderer", e);
        }
    }

    static {
        block9: {
            fopFactory = null;
            try {
                fopFactory = null;
                try (InputStream in = FopFactory.class.getResourceAsStream("/ru/bitel/common/fop-conf/fop.xconf");){
                    if (in != null) {
                        DefaultConfigurationBuilder dcb = new DefaultConfigurationBuilder();
                        DefaultConfiguration cfg = dcb.build(in);
                        FopFactoryBuilder builder = new FopFactoryBuilder(new File("base_uri_is_not_needed").toURI());
                        builder.setConfiguration((Configuration)cfg);
                        fopFactory = builder.build();
                        break block9;
                    }
                    throw new IllegalStateException("fop config not available");
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException("fop library initialization error (" + e.toString() + ")", e);
            }
        }
    }

    public static class _PatchedAWTRenderer
    extends AWTRenderer {
        public _PatchedAWTRenderer(FOUserAgent userAgent) {
            super(userAgent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex >= this.getNumberOfPages()) {
                return 1;
            }
            if (this.state != null) {
                throw new IllegalStateException("state must be null");
            }
            Graphics2D graphics = (Graphics2D)g;
            try {
                PageViewport viewport;
                this.currentPageViewport = viewport = this.getPageViewport(pageIndex);
                AffineTransform at = graphics.getTransform();
                this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
                this.currentBPPosition = 0;
                this.currentIPPosition = 0;
                this.renderPageAreas(viewport.getPage());
                int n = 0;
                return n;
            }
            catch (FOPException ex) {
                BGLogger.error(ex);
                int n = 1;
                return n;
            }
            finally {
                this.state = null;
                this.currentPageViewport = null;
            }
        }
    }
}

