/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class SmarthouseManager
extends BGLogger {
    protected String token = null;
    protected String serverUrl = null;
    protected int connectTimeout;
    protected int readTimeout;

    protected JSONObject doRequest(String uri, String httpMethod) throws Exception {
        return this.doRequest(uri, httpMethod, null);
    }

    protected JSONObject doRequest(String uri, String httpMethod, String outData) throws Exception {
        if (this.serverUrl == null) {
            this.errorSetServerUrl();
        }
        if (this.getToken() == null) {
            this.errorGetToken();
        }
        boolean error = false;
        StringBuilder result = new StringBuilder();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        if ("GET".equals(httpMethod)) {
            HttpGet httpGet = new HttpGet(this.serverUrl + uri);
            if (this.token != null) {
                httpGet.addHeader("Authorization", this.getTokenType() + " " + this.token);
            }
            httpGet.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else if ("POST".equals(httpMethod)) {
            StringEntity stringEntity = new StringEntity(outData);
            stringEntity.setContentType("application/json");
            HttpPost httpPost = new HttpPost(this.serverUrl + uri);
            if (this.token != null) {
                httpPost.addHeader("Authorization", this.getTokenType() + " " + this.token);
            }
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else if ("PATCH".equals(httpMethod)) {
            StringEntity stringEntity = new StringEntity(outData);
            stringEntity.setContentType("application/json");
            HttpPatch httpPatch = new HttpPatch(this.serverUrl + uri);
            if (this.token != null) {
                httpPatch.addHeader("Authorization", this.getTokenType() + " " + this.token);
            }
            httpPatch.setEntity((HttpEntity)stringEntity);
            httpPatch.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(10000).build());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPatch);){
                result.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        } else {
            InputStream inputStream;
            URL url = new URL(this.serverUrl + uri);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("URL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + this.serverUrl + uri);
            }
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setRequestMethod(httpMethod);
            connection.setRequestProperty("Authorization", this.getTokenType() + " " + this.token);
            connection.setDoInput(true);
            if ("POST".equals(httpMethod) || "PATCH".equals(httpMethod)) {
                connection.setDoOutput(true);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                bw.write(outData.toCharArray());
                bw.close();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + outData);
                }
            }
            connection.connect();
            error = connection.getResponseCode() != 200;
            InputStream inputStream2 = inputStream = error ? connection.getErrorStream() : connection.getInputStream();
            if (inputStream != null) {
                this.getLogger().debug("ContentLength = " + connection.getContentLength());
                result.append(new String(Utils.readByBlock((InputStream)inputStream), "UTF-8"));
            } else {
                this.getLogger().error("connection.getResponseCode() = " + connection.getResponseCode());
                this.getLogger().error("inputStream = " + String.valueOf(inputStream));
            }
            connection.disconnect();
        }
        httpclient.close();
        if (error) {
            this.getLogger().error("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + result.toString());
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + result.toString());
        }
        return new JSONObject(result.toString());
    }

    protected String getToken() throws Exception {
        return this.token;
    }

    protected void errorSetServerUrl() throws Exception {
        throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"*.server.url=\"");
    }

    protected void errorGetToken() throws Exception {
        throw new BGMessageException("Token is null");
    }

    protected String getTokenType() {
        return "JWT";
    }
}

