/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.GraduallySubscriptionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class GraduallySubscription
extends TaskBase {
    private Connection con;
    private Connection conSlave;
    private int periodGraduallySubscription;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u043e\u0441\u0442\u0435\u043f\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a \u043f\u0430\u043a\u0435\u0442\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    protected boolean initTask() {
        boolean result = true;
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        this.periodGraduallySubscription = moduleSetup.getInt("period.gradually.subscription", -1);
        if (this.periodGraduallySubscription <= 0) {
            result = false;
            this.getLogger().error("period.gradually.subscription not specified in module setup. The task will run for nothing!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        Calendar now = this.getOperatingTime();
        try {
            this.getLogger().info("Gradually subscription updating...");
            GraduallySubscriptionManager gsManager = new GraduallySubscriptionManager(this.con, this.moduleId);
            CardPacketManager cardPacketManager = new CardPacketManager(this.con, this.moduleId);
            Map<Integer, Date> dateMap = gsManager.getDateMap();
            for (CardPacket cardPacket : cardPacketManager.getCardPacketList(now)) {
                if (cardPacket.getDateTo() != null) continue;
                Date date = dateMap.get(cardPacket.getId());
                if (date != null) {
                    if (TimeUtils.daysDelta((Calendar)now, (Calendar)TimeUtils.convertDateToCalendar((Date)date)) > 1) continue;
                    date = TimeUtils.plusPeriod((Calendar)TimeUtils.convertDateToCalendar((Date)date), (int)5, (int)this.periodGraduallySubscription).getTime();
                    gsManager.updateDate(cardPacket.getId(), date);
                    continue;
                }
                date = TimeUtils.plusPeriod((Calendar)now, (int)5, (int)this.periodGraduallySubscription).getTime();
                gsManager.updateDate(cardPacket.getId(), date);
            }
            gsManager.close();
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.error = e;
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }
}

