/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import jakarta.activation.DataSource;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.plugins.edo.common.bean.Document;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.plugins.edo.server.bean.ContractConfigManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator;
import ru.bitel.bgbilling.plugins.edo.server.bean.SignatoryDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EdoBillManager {
    private Connection con;
    private int billModuleId;
    private Setup setup = Setup.getSetup();
    private Preferences billModuleSetup;
    private BillManager billManager;
    private InvoiceManager invoiceManager;
    private DocumentDao documentDao;
    private SignatoryDao signatoryDao;
    private ContractConfigManager contractConfigManager;

    public EdoBillManager(Connection con, int billModuleId) {
        this.con = con;
        this.billModuleId = billModuleId;
        if (billModuleId > 0) {
            this.billModuleSetup = this.setup.getModuleSetup(Integer.valueOf(billModuleId));
            this.billManager = new BillManager(con, billModuleId);
            this.invoiceManager = new InvoiceManager(con, billModuleId);
        }
        this.documentDao = new DocumentDao(con);
        this.signatoryDao = new SignatoryDao(con);
        this.contractConfigManager = new ContractConfigManager(con);
    }

    public List<KeyValue> formatsList() throws Exception {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        Map<Integer, Signatory> signatoryMap = this.signatoryDao.getMapAll();
        for (Document document : this.documentDao.getListAll()) {
            ArrayList<Integer> signatoryIds = null;
            signatoryIds = Utils.notEmptyCollection((Collection)document.getSignatoryIds()) ? document.getSignatoryIds() : new ArrayList<Integer>(signatoryMap.keySet());
            for (Integer signatoryId : signatoryIds) {
                Signatory signatory = signatoryMap.get(signatoryId);
                if (signatory == null) continue;
                String formatId = String.format("%d_%d", document.getId(), signatoryId);
                String formatTitle = String.format("%s ~ %s", document.getTitle(), signatory.getTitle());
                list.add(new KeyValue(formatId, formatTitle));
            }
        }
        return list;
    }

    public DataSource getDataSource(int docFormatId, int signatoryId, DocumentType type, Integer docId) throws Exception {
        EdoBillFileGenerator fileGenerator;
        Bill doc;
        if (type == DocumentType.BILL) {
            doc = this.billManager.getBill(docId.intValue());
            doc.setXmlData(this.billManager.getXMLData(docId.intValue()));
        } else {
            doc = this.invoiceManager.getInvoice(docId.intValue());
            doc.setXmlData(this.invoiceManager.getXMLData(docId.intValue()));
        }
        Document document = (Document)this.documentDao.get(docFormatId);
        Preferences documentSetup = new Preferences(document.getConfig(), "\n");
        String dynClassName = document.getClazz();
        Signatory signatory = (Signatory)this.signatoryDao.get(signatoryId);
        Preferences signatorySetup = new Preferences(signatory.getConfig(), "\n");
        documentSetup = documentSetup.inherit((ParameterMap)signatorySetup);
        String contractConfig = this.contractConfigManager.getConfig(doc.getContractId());
        if (Utils.notBlankString((String)contractConfig)) {
            Preferences contractSetup = new Preferences(contractConfig, "\n");
            documentSetup = documentSetup.inherit((ParameterMap)contractSetup);
        }
        try {
            fileGenerator = (EdoBillFileGenerator)DynamicClassManager.getInstance().newInstance(EdoBillFileGenerator.class, dynClassName);
            fileGenerator.init(this.setup, this.con, this.billModuleId, (ParameterMap)this.billModuleSetup, (ParameterMap)documentSetup, (BillDoc)doc);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (BGException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage(), (Throwable)e);
        }
        try {
            final InputStream is = fileGenerator.getFileContent();
            final String fn = Utils.normalizeFileName((String)fileGenerator.getFileName());
            return new DataSource(){

                public InputStream getInputStream() {
                    return is;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return null;
                }

                public String getName() {
                    return fn;
                }
            };
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void sendEdo(int docFormatId, int signatoryId, DocumentType type, Integer docId) {
    }
}

