/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.admin.UserAuthR;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;

public class BGClientR
extends BGClientBase {
    public BGClientR() {
        this(null, null, true);
    }

    public BGClientR(String dbInfoKey, String dbAuth, boolean showAboutDialog) {
        this.init1(showAboutDialog);
        DBInfo dbInfo = this.dbInfoManager.getInfo(dbInfoKey);
        if (dbAuth != null) {
            String[] auth = BGClientRunnerCipher.cipher(dbAuth, true).split("\t", -1);
            dbInfo.setDbServerLogin(auth[0]);
            dbInfo.setDbServerPassword(auth[1]);
        }
        if (dbInfo != null) {
            try {
                this.dbInfoManager.connect(dbInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while ((dbInfo = this.auth(dbInfo)) != null) {
        }
        this.init2();
    }

    @Override
    public DBInfo auth(DBInfo dbInfo) {
        super.auth(dbInfo);
        if (dbInfo != null && this.dbInfoManager.isAutorized(dbInfo)) {
            try {
                this.switchServer(dbInfo);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return null;
        }
        UserAuthR userAuthDialog = new UserAuthR();
        if (dbInfo != null) {
            userAuthDialog.setDbInfo(dbInfo);
        } else if (this.dbInfoManager.getDefaultServerKey() != null) {
            userAuthDialog.setDbInfo(this.dbInfoManager.getInfo(this.dbInfoManager.getDefaultServerKey()));
        }
        userAuthDialog.setData();
        if (userAuthDialog.showDialog() == "cancel") {
            DBInfo dbActive = this.dbInfoManager.getActiveDBInfo();
            if (dbActive == null) {
                BGClientR.close();
            } else {
                try {
                    this.setBarData(dbActive);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            return null;
        }
        if (this.dbInfoManager.getActiveDBInfo() != null) {
            for (OnStop p : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                p.onStop();
            }
        }
        dbInfo = userAuthDialog.getDbInfo();
        try {
            if (!this.dbInfoManager.connect(dbInfo)) {
                return dbInfo;
            }
        }
        catch (Exception ex) {
            return dbInfo;
        }
        this.getTabbedPane().removeAll();
        this.dbInfoManager.setActiveDBInfo(dbInfo);
        BGClientR.loadUserEmail(dbInfo);
        try {
            return this.auth5(dbInfo);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return null;
        }
    }

    public static void main(String[] args) {
        BGClientInit.mainInit(args);
        String dbInfoKey = null;
        String dbInfoAuth = null;
        for (String arg : args) {
            if (arg.startsWith("dbInfo=")) {
                dbInfoKey = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("dbAuth=")) continue;
            dbInfoAuth = arg.substring(7);
        }
        new BGClientR(dbInfoKey, dbInfoAuth, true);
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit(true);
    }
}

