/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrServicingPerson;

public class ContractParamServiceEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private String service_id = null;
    private Vector<Properties> parameterList = new Vector();
    private DefaultListModel<BGUListItem> listModel = new DefaultListModel();
    private JList<BGUListItem> serviceList = new JList<BGUListItem>(this.listModel);
    private BGControlPanelListSelect addressPanel = new BGControlPanelListSelect();

    public ContractParamServiceEditorDialog(String title, ContractParamEditorData data) {
        super(title, data);
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.getServicePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        Request request = new Request().setModule("contract").setAction("ServiceList").setContractId(((ContractParamEditorData)this.data).contractId).setAttribute("pid", ((ContractParamEditorData)this.data).parameterId);
        this.setDocument(TransferManager.getDocument(request));
    }

    @Override
    public boolean doApply() throws Exception {
        HashMap value = new HashMap();
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Properties prop = this.parameterList.elementAt(i);
            int servicePersonId = Utils.parseInt(prop.getProperty("sid"), -1);
            int attrAddressId = Utils.parseInt(prop.getProperty("id"), -1);
            if (servicePersonId <= 0 || attrAddressId <= 0) continue;
            if (value.get(servicePersonId) != null) {
                ((List)value.get(servicePersonId)).add(attrAddressId);
                continue;
            }
            ArrayList<Integer> addressIds = new ArrayList<Integer>();
            addressIds.add(attrAddressId);
            value.put(servicePersonId, addressIds);
        }
        ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterUpdate(((ContractParamEditorData)this.data).contractId, (EntityAttr)new EntityAttrServicingPerson(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId, value));
        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
        return true;
    }

    private JPanel getServicePanel() {
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(e -> this.serviceList_valueChanged(e));
        JPanel servicePanel = new JPanel(new GridBagLayout());
        servicePanel.setBorder(new BGTitleBorder(" \u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u043b\u0438\u0446\u0430 "));
        servicePanel.add((Component)BGSwingUtilites.wrapScrollPane(this.serviceList, 300, 200), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(400, 200);
        this.addressPanel.setBorder(new BGTitleBorder(" \u0410\u0434\u0440\u0435\u0441\u0430 "));
        this.addressPanel.addPropertyChangeListener(e -> this.addressPanel_propertyChange(e));
        this.addressPanel.setMinimumSize(dimension);
        this.addressPanel.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)servicePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.addressPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            try {
                ClientUtils.buildList(this.serviceList, XMLUtils.selectNode(doc, "//serviceList"));
                this.addressPanel.getList().setModel(new DefaultListModel());
                this.parameterList = new Vector();
                Element node = XMLUtils.selectElement(doc, "//parameterList");
                if (node != null && node.hasChildNodes()) {
                    for (Element item : XMLUtils.elements(node.getChildNodes())) {
                        Properties prop = new Properties();
                        prop.setProperty("id", XMLUtils.getAttribute(item, "id", null));
                        prop.setProperty("sid", XMLUtils.getAttribute(item, "sid", null));
                        prop.setProperty("title", XMLUtils.getAttribute(item, "title", null));
                        this.parameterList.addElement(prop);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void serviceList_valueChanged(ListSelectionEvent e) {
        this.listModel = (DefaultListModel)this.serviceList.getModel();
        if (!this.serviceList.isSelectionEmpty()) {
            int index = this.serviceList.getMinSelectionIndex();
            BGUListItem li = this.listModel.elementAt(index);
            this.service_id = (String)li.getAttribute("id");
            if (this.service_id != null && this.parameterList != null && this.parameterList.size() > 0) {
                DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
                for (int i = 0; i < this.parameterList.size(); ++i) {
                    Properties prop = this.parameterList.elementAt(i);
                    String sid = prop.getProperty("sid", null);
                    boolean check = this.service_id.equals(sid);
                    if (sid != null && !check && !"0".equals(sid)) continue;
                    BGUListItem item = new BGUListItem(0, prop.getProperty("title", "-"));
                    item.setSelected(check);
                    item.setAttribute("prop", prop);
                    model.addElement(item);
                }
                this.addressPanel.getList().setModel(model);
            }
        }
    }

    void addressPanel_propertyChange(PropertyChangeEvent e) {
        if (this.service_id == null) {
            return;
        }
        if ("itemChange".equals(e.getPropertyName())) {
            ListModel model = this.addressPanel.getList().getModel();
            for (int i = 0; i < ((DefaultListModel)model).getSize(); ++i) {
                BGUListItem item = (BGUListItem)((DefaultListModel)model).getElementAt(i);
                Properties prop = (Properties)item.getAttribute("prop");
                prop.setProperty("sid", item.isSelected() ? this.service_id : "0");
            }
        }
    }
}

