/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.oss.systems.inventory.resource.client.PhoneResourceSubscriptionPanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class PhoneResourcePanel
extends BGUPanel {
    private BGDataSourceTableModel model = new BGDataSourceTableModel("PhoneResource");
    private PhoneCategoryTableModel treeModel = new PhoneCategoryTableModel();
    private PhoneResourceService resourceService;

    public PhoneResourcePanel(ClientContext ctx) {
        super((LayoutManager)new BorderLayout(), ctx);
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("table");
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGUTable table = new BGUTable(this.model);
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.initToolBar(toolBar);
        toolBar.compact();
        BGSwingUtilites.handleEdit("resource", table, this);
        BGEditor mainEditor = new BGEditor("table");
        mainEditor.addForm(panel);
        mainEditor.addForm(new PhoneResourceSubscriptionPanel());
        BGSwingUtilites.buildPopupMenu(table, (Container)mainEditor, "phoneResource");
        BGUTreeTable treeTable = new BGUTreeTable(this.treeModel);
        this.add((Component)new BGSplitPaneNoBorder(1, BGSwingUtilites.wrapBorder(new JScrollPane(treeTable), "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"), (Component)mainEditor, 400L), "Center");
        treeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.performAction("resource.refresh");
            }
        });
    }

    private PhoneResourceService getPhoneResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(PhoneResourceService.class);
        }
        return this.resourceService;
    }

    private void initToolBar(BGDialogToolBar toolBar) {
        AbstractBGUPanel.DefaultAction resourceNew = new AbstractBGUPanel.DefaultAction("resource.new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_add")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                PhoneCategory category = (PhoneCategory)PhoneResourcePanel.this.treeModel.getSelectedRow();
                if (category == null || category.getId() <= 0) {
                    return;
                }
                Id phoneResourceId = new Id().setId(0);
                new PhoneResourceDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441", phoneResourceId, category.getId()).open();
                PhoneResourcePanel.this.performAction("refresh");
                PhoneResourcePanel.this.model.setSelectedRow(phoneResourceId.getId());
            }
        };
        AbstractBGUPanel.DefaultAction resourceEdit = new AbstractBGUPanel.DefaultAction("resource.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_edit")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Id phoneResourceId = PhoneResourcePanel.this.model.getSelectRow(Id.class);
                if (phoneResourceId != null) {
                    new PhoneResourceDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", phoneResourceId, -1).open();
                    PhoneResourcePanel.this.performAction("refresh");
                    PhoneResourcePanel.this.model.setSelectedRow(phoneResourceId.getId());
                }
            }
        };
        AbstractBGUPanel.DefaultAction resourceDelete = new AbstractBGUPanel.DefaultAction("resource.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_delete")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List phoneResources = PhoneResourcePanel.this.model.getSelectedRows();
                if (!phoneResources.isEmpty()) {
                    if (phoneResources.size() == 1) {
                        BGUTableRowData phoneResource = (BGUTableRowData)phoneResources.get(0);
                        if (BGSwingUtilites.confirmDelete("\u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u043e\u043c\u0435\u0440\u0430", phoneResource.optValue("range").orElse("???"))) {
                            PhoneResourcePanel.this.getPhoneResourceService().phoneResourceDelete(phoneResource.getId());
                            PhoneResourcePanel.this.performAction("refresh");
                        }
                    } else if (BGSwingUtilites.confirmDelete("\u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 -> ", phoneResources.size())) {
                        for (BGUTableRowData phoneResource : phoneResources) {
                            PhoneResourcePanel.this.getPhoneResourceService().phoneResourceDelete(phoneResource.getId());
                        }
                        PhoneResourcePanel.this.performAction("refresh");
                    }
                }
            }
        };
        AbstractBGUPanel.DefaultAction resourceImport = new AbstractBGUPanel.DefaultAction("resource.import", "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b", (Icon)ClientUtils.getIcon("import")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                PhoneCategory phoneCategory = (PhoneCategory)PhoneResourcePanel.this.treeModel.getSelectedRow();
                if (phoneCategory == null || phoneCategory.getId() <= 0) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                    return;
                }
                PhoneResource phoneResource = new PhoneResource();
                phoneResource.setCategoryId(phoneCategory.getId());
                new PhoneResourceImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432", phoneResource).open();
                PhoneResourcePanel.this.performAction("refresh");
            }
        };
        toolBar.add(resourceNew);
        toolBar.add(resourceEdit);
        toolBar.add(resourceDelete);
        toolBar.addSeparator();
        toolBar.add(resourceImport);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            PhoneCategory category = (PhoneCategory)this.treeModel.getSelectedRow();
            this.treeModel.setData(this.getPhoneResourceService().phoneCategoryRoot());
            this.treeModel.setSelectedRow(category);
        });
        new AbstractBGUPanel.DefaultAction("resource.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                PhoneCategory category = (PhoneCategory)PhoneResourcePanel.this.treeModel.getSelectedRow();
                BGUTableParams tableParams = new BGUTableParams().addParam("categoryId", category != null ? String.valueOf(category.getId()) : "-1");
                PhoneResourcePanel.this.model.loadData((ClientContext)PhoneResourcePanel.this.getContext(), tableParams);
            }
        };
        new AbstractBGUPanel.MenuAction("phoneResourceSubscription.contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceAccount account;
                PhoneResourceSubscription subscription = (PhoneResourceSubscription)e.getSource();
                if (subscription != null && (account = ((ClientContext)PhoneResourcePanel.this.getContext()).getPort(VoiceAccountService.class).voiceAccountGet(subscription.getSubscriberId())) != null) {
                    ClientUtils.openContract(account.getContractId());
                }
            }
        };
        new AbstractBGUPanel.BGActionNew(e -> {
            PhoneCategory phoneCategory = new PhoneCategory();
            PhoneCategory category = (PhoneCategory)this.treeModel.getSelectedRow();
            if (category != null) {
                phoneCategory.setParentId(category.getId());
            }
            new PhoneCategoryResourceDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", phoneCategory).open();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            PhoneCategory phoneCategory = (PhoneCategory)this.treeModel.getSelectedRow();
            if (phoneCategory == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            new PhoneCategoryResourceDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", phoneCategory).open();
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            PhoneCategory phoneCategory = (PhoneCategory)this.treeModel.getSelectedRow();
            if (phoneCategory != null && BGSwingUtilites.confirmDelete("\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", phoneCategory)) {
                this.getPhoneResourceService().phoneCategoryDelete(phoneCategory.getId());
                this.performAction("refresh");
            }
        });
    }

    class PhoneCategoryTableModel
    extends BGTreeTableModel<PhoneCategory> {
        public PhoneCategoryTableModel() {
            super(PhoneCategoryTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PhoneCategory.class, -1, 300, -1, "title", false);
            this.addColumnId();
        }
    }

    class PhoneCategoryResourceDialog
    extends BGEditorDialog<PhoneCategory> {
        private BGTextField title;

        public PhoneCategoryResourceDialog(String title, PhoneCategory data) {
            super(title, data);
            this.title = new BGTextField();
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.title.setText(((PhoneCategory)this.data).getTitle());
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isEmptyString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                return false;
            }
            ((PhoneCategory)this.data).setTitle(this.title.getText());
            int id = PhoneResourcePanel.this.getPhoneResourceService().phoneCategoryUpdate((PhoneCategory)this.data);
            PhoneResourcePanel.this.performAction("refresh");
            PhoneResourcePanel.this.treeModel.setSelectedRow(id);
            return true;
        }
    }

    class PhoneResourceTableModel
    extends BGTableModel<PhoneResource> {
        public PhoneResourceTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d", 400, 400, 400, null, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, null, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(PhoneResource val, int column) throws Exception {
            switch (column) {
                case 1: {
                    return val.getPhoneFrom() + "-" + val.getPhoneTo();
                }
                case 2: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }

    class PhoneResourceDialog
    extends BGEditorDialog<Id> {
        private int categoryId;
        private BGIntTextField phoneFrom;
        private BGIntTextField phoneTo;
        private BGControlPanelPeriodNoB period;
        private JTextArea comment;

        public PhoneResourceDialog(String title, Id data, int categoryId) {
            super(title, data);
            this.phoneFrom = new BGIntTextField(20);
            this.phoneTo = new BGIntTextField(20);
            this.period = new BGControlPanelPeriodNoB(false);
            this.comment = new JTextArea();
            this.categoryId = categoryId;
        }

        @Override
        public void doDialogPanel() {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)this.getDataPanel(), "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d, \u043f\u0435\u0440\u0438\u043e\u0434");
            tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
            this.panel.add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tryCall(() -> {
                PhoneResource phoneResource = PhoneResourcePanel.this.getPhoneResourceService().phoneResourceGet(((Id)this.data).getId());
                if (phoneResource == null) {
                    phoneResource = new PhoneResource().setCategoryId(this.categoryId);
                } else {
                    this.categoryId = phoneResource.getCategoryId();
                }
                this.phoneFrom.setText(String.valueOf(phoneResource.getPhoneFrom()));
                this.phoneTo.setText(String.valueOf(phoneResource.getPhoneTo()));
                this.period.setPeriod(new Period(phoneResource.getDateFrom(), phoneResource.getDateTo()));
                this.comment.setText(phoneResource.getComment());
            });
        }

        private JPanel getDataPanel() {
            Component[][] components = new Component[][]{{new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430:"), this.phoneFrom}, {new JLabel("\u041a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430:"), this.phoneTo}, {new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), this.period}};
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            gridy = ClientUtils.addComponentToPanel(panel, gridy, components, true);
            return panel;
        }

        private JPanel getCommentPanel() {
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            if (!this.phoneFrom.getText().matches("^[0-9]+$")) {
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430");
                return false;
            }
            if (!this.phoneTo.getText().matches("^[0-9]+$")) {
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0446\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430");
                return false;
            }
            PhoneResource phoneResource = new PhoneResource(((Id)this.data).getId()).setCategoryId(this.categoryId).setPhoneFrom(Utils.parseLong(this.phoneFrom.getText())).setPhoneTo(Utils.parseLong(this.phoneTo.getText())).setDateFrom(this.period.getPeriod().getDateFrom()).setDateTo(this.period.getPeriod().getDateTo()).setComment(this.comment.getText());
            ((Id)this.data).setId(PhoneResourcePanel.this.getPhoneResourceService().phoneResourceUpdate(phoneResource));
            return true;
        }
    }

    class PhoneResourceImportDialog
    extends BGEditorDialog<PhoneResource> {
        private JTextArea importData;

        public PhoneResourceImportDialog(String title, PhoneResource data) {
            super(title, data);
            this.importData = new JTextArea(15, 50);
        }

        @Override
        public void doDialogPanel() {
            Insets insets = new Insets(3, 3, 3, 3);
            this.importData.setMargin(insets);
            JTextArea help = new JTextArea(15, 50);
            help.setMargin(insets);
            help.setEditable(false);
            help.setText("\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0444\u043e\u0440\u043c\u0430\u0442\u044b:\n\n  <from><TAB><to>\n\n  <from><TAB><to><TAB><dateFrom><TAB><dateTo>\n\n  <from><TAB><to><TAB><dateFrom><TAB><dateTo><TAB><comment>\n\n\n<dateFrom> \u0438 <dateTo> \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 dd.MM.yyyy");
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)new JScrollPane(this.importData), "\u0414\u0430\u043d\u043d\u044b\u0435");
            tabbedPane.add((Component)new JScrollPane(help), "\u041f\u043e\u043c\u043e\u0449\u044c");
            this.panel.add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.importData.getText().isEmpty()) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435...");
                return false;
            }
            PhoneResourcePanel.this.getPhoneResourceService().phoneResourceImport(((PhoneResource)this.data).getCategoryId(), this.importData.getText());
            return true;
        }
    }
}

