/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebFilter(filterName="mpsexecutorSetCharacterEncoding", urlPatterns={"/mpsexecuter/*"})
public class MPSExecutorFilter
extends BGLogger
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("init filter " + filterConfig.getFilterName());
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        if (pathInfo != null) {
            int moduleId = 0;
            String mpsId = null;
            String[] params = pathInfo.split("/");
            if (params.length <= 3) {
                String encoding;
                switch (params.length) {
                    default: {
                        mpsId = params[2];
                    }
                    case 2: {
                        moduleId = Utils.parseInt((String)params[1], (int)0);
                        break;
                    }
                    case 0: 
                    case 1: {
                        moduleId = 0;
                    }
                }
                Conf conf = (Conf)Setup.getSetup().getConfig(moduleId, Conf.class);
                if (conf != null && (encoding = conf.getMpsSystemRequestEncoding(mpsId)) != null) {
                    request.setCharacterEncoding(encoding);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

