/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;

public class DayModeCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JLabel view;
    private String cost;
    private String costMode;
    private String type;
    private BGFloatTextField costTf;
    private ButtonGroup costButtonGroup;
    private JRadioButton constCostMode;
    private JRadioButton varCostMode;
    private BGUComboBox<KeyValue> typeCombo = new BGUComboBox();
    private BGUComboBox<TariffVar> tariffVars = new BGUComboBox();
    private List<KeyValue> types = Arrays.asList(new KeyValue("0", "\u0437\u0430 \u0434\u0435\u043d\u044c"), new KeyValue("1", "\u0437\u0430 \u043c\u0435\u0441\u044f\u0446"), new KeyValue("2", "\u0437\u0430 30 \u0434\u043d\u0435\u0439"));

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            if (tree.getParent() instanceof TariffPanelEditor) {
                TariffVar tariffVar = new TariffVar();
                tariffVar.setId(0);
                tariffVar.setTitle("---");
                this.vars.add(tariffVar);
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(TariffVarType.COST, Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).toList());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected JPanel getEditorPanel() {
        if (this.costTf == null) {
            this.costTf = new BGFloatTextField(10);
            this.typeCombo.setData(this.types);
            this.constCostMode = new JRadioButton("\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b", true);
            this.constCostMode.setActionCommand("const");
            this.varCostMode = new JRadioButton("\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
            this.varCostMode.setActionCommand("var");
            this.costButtonGroup = new ButtonGroup();
            this.costButtonGroup.add(this.constCostMode);
            this.costButtonGroup.add(this.varCostMode);
            this.tariffVars.setData(this.vars);
        }
        JPanel edit = new JPanel(new GridBagLayout());
        edit.add((Component)this.getCostConstPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        edit.add((Component)this.getCostVarPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        edit.add((Component)this.getModePanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        return edit;
    }

    private JPanel getModePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.typeCombo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCostConstPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.constCostMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.costTf, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCostVarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.varCostMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffVars, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    public Component getView() {
        this.extractData();
        StringBuffer title = new StringBuffer();
        if ("const".equals(this.costMode)) {
            title.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c: ");
            title.append(this.cost);
        } else if ("var".equals(this.costMode)) {
            title.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439: ");
            title.append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " [" + this.getTariffVarValue(this.tariffVar) + "] >" : "???"));
        }
        title.append("; \u041f\u0435\u0440\u0438\u043e\u0434 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438: ");
        title.append(this.types.stream().filter(a -> a.getKey().equals(this.type)).findFirst().orElse(this.types.get(0)).getValue());
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.view.setText(title.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.cost = data.getOrDefault("cost", "0.00");
        this.costMode = data.getOrDefault("costMode", "const");
        this.type = Utils.maskNull((String)((String)data.get("type")));
        int tariffVarId = Utils.parseInt((String)data.getOrDefault("tariffVarId", "0"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId || a.getTopId() == tariffVarId).findFirst().orElse((TariffVar)this.vars.get(0));
    }

    protected void loadData() {
        this.extractData();
        this.costButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(this.costMode)) {
                a.setSelected(true);
            }
        });
        this.costTf.setText(this.cost);
        this.typeCombo.setSelectedItem((Object)this.types.stream().filter(a -> a.getKey().equals(this.type)).findFirst().orElse(this.types.get(0)));
        this.tariffVars.setSelectedItem((Object)this.tariffVar);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cost", this.costTf.getText());
        data.put("costMode", this.costButtonGroup.getSelection().getActionCommand());
        data.put("type", ((KeyValue)this.typeCombo.getSelectedItem()).getKey());
        data.put("tariffVarId", String.valueOf(this.tariffVars.getSelectedItem() != null ? ((TariffVar)this.tariffVars.getSelectedItem()).getId() : 0));
        this.setDataInHash(data);
    }

    protected void editOk() {
        if ("var".equals(this.costButtonGroup.getSelection().getActionCommand()) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        super.editOk();
    }
}

