<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/data">
<html>

<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>

<body>
    <center>
    	<h2>Отчет по балансу<br/>Договор:<xsl:value-of select="@contractTitle"/></h2>
         За месяц: <xsl:value-of select="format-number( date/@month, '00' )"/>.<xsl:value-of select="date/@year"/><br/><br/>
     </center>
    <xsl:call-template name="table"/><br/>
</body>
</html>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="0">
	<thead>
		<tr>
			<td>Описание</td>
			<td>Сумма, руб.</td>
		</tr>
	</thead>
	<tbody>
		<tr bgcolor="#f0f0f0">
			<td style="text-align: left;"><b>Входящий остаток на начало месяца</b></td>
			<td><b><xsl:value-of select="format-number( balance/@summa1, '0.00' )" /></b></td>
		</tr>
		<tr bgcolor="#f0f0f0">
			<td style="text-align: left;"><b>Приход за месяц (всего)</b></td>
			<td><b><xsl:value-of select="format-number( balance/@summa2, '0.00' )" /></b></td>
		</tr>
		<xsl:for-each select="balance/payments/payment">
		<tr>
			<td style="text-align: left; color: #555555; padding-left: 20px;"><xsl:value-of select="@title" /></td>
			<td><xsl:value-of select="format-number( @value, '0.00' )" /></td>
		</tr>
		</xsl:for-each>
		<tr bgcolor="#f0f0f0">
			<td style="text-align: left;"><b>Расход за месяц (всего)</b></td>
			<td><b><xsl:value-of select="format-number( 0 - balance/@summa4, '0.00' )" /></b></td>
		</tr>
		<xsl:for-each select="balance/charges/charge">
		<tr>
			<td style="text-align: left; color: #555555; padding-left: 20px;"><xsl:value-of select="@title" /></td>
			<td><xsl:value-of select="format-number( 0 - @value, '0.00' )" /></td>
		</tr>
		</xsl:for-each>
		<tr bgcolor="#f0f0f0">
			<td style="text-align: left;"><b>Наработка за месяц (всего)</b></td>
			<td><b><xsl:value-of select="format-number( 0 - balance/@summa3, '0.00' )" /></b></td>
		</tr>
		<xsl:for-each select="balance/accounts/account">
		<tr>
			<td style="text-align: left; color: #555555; padding-left: 20px;"><xsl:value-of select="@title" /></td>
			<td><xsl:value-of select="format-number( 0 - @value, '0.00' )" /></td>
		</tr>
		</xsl:for-each>
		<tr bgcolor="#f0f0f0">
			<td style="text-align: left;"><b>Исходящий остаток на конец месяца</b></td>
			<td><b><xsl:value-of select="format-number( balance/@summa5, '0.00' )" /></b></td>
		</tr>
		<xsl:if test="/data/@balance_mode=1">
		<tr>
			<td style="text-align: left;">Лимит</td>
			<td><xsl:value-of select="format-number( balance/@limit, '0.00' )" /></td>
		</tr>
		</xsl:if>
	</tbody>
</table>
</xsl:template>

</xsl:stylesheet>
