/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.common.Utils;

public class ParameterEditor
extends JPanel {
    protected JTable table;
    private ParameterTableModel tableModel;
    private JSONArray tableConfig;

    public ParameterEditor(JSONArray config) {
        this.tableConfig = config;
        this.tableModel = new ParameterTableModel(this.tableConfig);
        this.table = new JTable(this.tableModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                ParameterRow parameterRow = ParameterEditor.this.tableModel.getRow(row);
                if (column == 1) {
                    String type = parameterRow.type;
                    if ("boolean".equals(type)) {
                        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(Boolean.class);
                        ((JCheckBox)((Object)tableCellRenderer)).setHorizontalAlignment(0);
                        return tableCellRenderer;
                    }
                    if ("number".equals(type)) {
                        return this.getDefaultRenderer(Number.class);
                    }
                }
                return super.getCellRenderer(row, column);
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                ParameterRow parameterRow = ParameterEditor.this.tableModel.getRow(row);
                if ("text".equals(parameterRow.type)) {
                    return this.getDefaultEditor(String.class);
                }
                if ("number".equals(parameterRow.type)) {
                    return this.getDefaultEditor(Number.class);
                }
                if ("list".equals(parameterRow.type) || "layout".equals(parameterRow.type)) {
                    return new DefaultCellEditor(new JComboBox<String>(parameterRow.values));
                }
                return super.getCellEditor(row, column);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 1) {
                    ParameterRow parameterRow = ParameterEditor.this.tableModel.getRow(row);
                    String type = parameterRow.type;
                    if ("text".equals(type) || "number".equals(type) || "list".equals(type) || "layout".equals(type)) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int row;
                if (mouseEvent.getClickCount() == 2 && ParameterEditor.this.table.columnAtPoint(mouseEvent.getPoint()) == 1 && (row = ParameterEditor.this.table.rowAtPoint(mouseEvent.getPoint())) > -1) {
                    ParameterRow parameterRow = ParameterEditor.this.tableModel.getRow(row);
                    String type = parameterRow.type;
                    if ("boolean".equals(type)) {
                        parameterRow.value = String.valueOf(Boolean.valueOf(parameterRow.value) == false);
                        ParameterEditor.this.table.invalidate();
                        ParameterEditor.this.table.repaint();
                    } else if ("text".equals(type)) {
                        ParameterEditor.this.table.setCellEditor(new CellTextEditor());
                        ParameterEditor.this.table.editCellAt(row, 1);
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void setData(JSONObject data) {
        this.tableModel = new ParameterTableModel(this.tableConfig);
        this.table.setModel(this.tableModel);
        this.tableModel.setData(data);
    }

    public JSONObject getOptions() {
        return this.tableModel.getData();
    }

    static class ParameterTableModel
    extends AbstractTableModel {
        private JSONArray config;
        private final String[] columnNames = new String[]{"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"};
        private List<ParameterRow> rows = new ArrayList<ParameterRow>();

        public ParameterTableModel(JSONArray config) {
            this.config = config;
        }

        public void setData(JSONObject data) {
            this.rows = new ArrayList<ParameterRow>();
            for (int index = 0; index < this.config.length(); ++index) {
                JSONObject configItem = this.config.getJSONObject(index);
                String key = configItem.getString("key");
                ParameterRow parameterRow = new ParameterRow();
                parameterRow.key = key;
                parameterRow.type = configItem.optString("type", "text");
                parameterRow.title = configItem.optString("title", "???");
                parameterRow.value = data != null ? data.optString(key, "") : "";
                parameterRow.values = this.getValues(configItem.optJSONArray("values"));
                this.rows.add(parameterRow);
            }
        }

        private String[] getValues(JSONArray array) {
            String[] values = null;
            if (array != null) {
                values = new String[array.length()];
                for (int index = 0; index < array.length(); ++index) {
                    values[index] = array.optString(index);
                }
            }
            return values;
        }

        public JSONObject getData() {
            JSONObject data = new JSONObject();
            for (ParameterRow parameterRow : this.rows) {
                if (!Utils.notBlankString((String)parameterRow.value)) continue;
                data.put(parameterRow.key, (Object)parameterRow.value);
            }
            return data;
        }

        public ParameterRow getRow(int rowIndex) {
            return rowIndex > -1 && rowIndex < this.rows.size() ? this.rows.get(rowIndex) : null;
        }

        @Override
        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParameterRow parameterRow = this.rows.get(rowIndex);
            boolean fl = "number".equals(parameterRow.type);
            fl = fl || "text".equals(parameterRow.type);
            return fl;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParameterRow parameterRow = this.rows.get(rowIndex);
            if (columnIndex == 0) {
                return parameterRow.title;
            }
            if (columnIndex == 1) {
                String type = parameterRow.type;
                if ("boolean".equals(type)) {
                    return Boolean.valueOf(parameterRow.value);
                }
                return parameterRow.value;
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParameterRow parameterRow = this.rows.get(rowIndex);
            parameterRow.value = String.valueOf(aValue);
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }
    }

    static class CellTextEditor
    extends DefaultCellEditor {
        public CellTextEditor() {
            super(new JTextField());
        }

        @Override
        public int getClickCountToStart() {
            return 2;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }
    }

    static class ParameterRow {
        String key;
        String title;
        String type;
        String value;
        String[] values;

        ParameterRow() {
        }
    }
}

