/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.common.client.table.BGTableModel;

public class AddressPodTableModel
extends BGTableModel<PodData> {
    public AddressPodTableModel() {
        super(AddressPodTableModel.class.getName());
    }

    @Override
    protected void initColumns() {
        this.addColumn("\u041f\u043e\u0434\u044a\u0435\u0437\u0434", 70, 70, 70, "podNumber", false, DecimalTableCellRenderer.INTEGER());
        this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0432\u0430\u0440\u0442\u0438\u0440", 120, 120, 120, "flatRange", false, HorizontalAlignmentTableCellRenderer.CENTER());
        this.addColumn("\u042d\u0442\u0430\u0436\u0435\u0439", 70, 70, 70, "floorCount", false, DecimalTableCellRenderer.INTEGER());
        this.addColumn("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043f\u043e \u044d\u0442\u0430\u0436\u0430\u043c", -1, -1, -1, "floorFlatRange", false, HorizontalAlignmentTableCellRenderer.LEFT());
    }

    @Override
    public Object getValue(PodData val, int columnIndex) throws Exception {
        String identifier = this.getIdentifier(columnIndex);
        if ("flatRange".equals(identifier)) {
            int from = val.getFlatRangeFrom();
            int count = val.getFlatRangeCount();
            if (from > 0 && count > 0) {
                return from + " - " + (from + count - 1) + " [" + count + "]";
            }
            return "";
        }
        return super.getValue(val, columnIndex);
    }

    public static class PodData {
        private int podNumber = 0;
        private int floorCount = 0;
        private int flatRangeFrom = 0;
        private int flatRangeCount = 0;
        private String floorFlatRange;

        public int getPodNumber() {
            return this.podNumber;
        }

        public int getFloorCount() {
            return this.floorCount;
        }

        public int getFlatRangeFrom() {
            return this.flatRangeFrom;
        }

        public int getFlatRangeCount() {
            return this.flatRangeCount;
        }

        public String getFloorFlatRange() {
            return this.floorFlatRange;
        }

        public PodData setPodNumber(int podNumber) {
            this.podNumber = podNumber;
            return this;
        }

        public PodData setFloorCount(int floorCount) {
            this.floorCount = floorCount;
            return this;
        }

        public PodData setFlatRangeFrom(int flatRangeFrom) {
            this.flatRangeFrom = flatRangeFrom;
            return this;
        }

        public PodData setFlatRangeCount(int flatRangeCount) {
            this.flatRangeCount = flatRangeCount;
            return this;
        }

        public PodData setFloorFlatRange(String floorFlatRange) {
            this.floorFlatRange = floorFlatRange;
            return this;
        }
    }
}

