/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;

public class FrkUtils {
    static final String PATH_ROOT_DRIVER = "ru/bitel/bgbilling/apps/cashcheck/frk/driver/";

    public static int parseInt(String val) throws DriverException {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static long parseLong(String val) throws DriverException {
        try {
            return Long.parseLong(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static BigDecimal parseBigDecimal(String val) throws DriverException {
        try {
            return new BigDecimal(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static String formatMDE(long total) {
        StringBuilder sb = new StringBuilder();
        sb.append(total / 100L).append(" \u0440\u0443\u0431. ");
        sb.append(total % 100L > 9L ? "" : "0");
        sb.append(total % 100L).append(" \u043a\u043e\u043f.");
        return sb.toString();
    }

    public static Set<Class<?>> driversTouch() {
        HashSet classes = new HashSet();
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = ClassLoader.getSystemResources(PATH_ROOT_DRIVER);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, contextClassLoader);){
                    if ("file".equals(url.getProtocol())) {
                        try {
                            File[] driverFolders;
                            File f = new File(url.toURI());
                            for (File driverFolder : driverFolders = f.listFiles()) {
                                File[] driverFiles;
                                if (!driverFolder.exists() || !driverFolder.isDirectory()) continue;
                                for (File driverFile : driverFiles = driverFolder.listFiles()) {
                                    if (!driverFile.exists() || !driverFile.isFile() || !driverFile.getCanonicalPath().endsWith(".class")) continue;
                                    String classSubPath = driverFile.getCanonicalPath().substring(driverFile.getCanonicalPath().indexOf(PATH_ROOT_DRIVER));
                                    classSubPath = classSubPath.replace('/', '.');
                                    classSubPath = classSubPath.substring(0, classSubPath.length() - 6);
                                    Class<?> c = classLoader.loadClass(classSubPath);
                                    classes.add(c);
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (!"jar".equals(url.getProtocol())) continue;
                    String jarName = url.getFile().substring(5, url.getFile().indexOf(PATH_ROOT_DRIVER) - 2);
                    try (JarFile jarFile = new JarFile(jarName);){
                        Enumeration<JarEntry> enum1 = jarFile.entries();
                        while (enum1.hasMoreElements()) {
                            JarEntry entry = enum1.nextElement();
                            if (!entry.getName().startsWith(PATH_ROOT_DRIVER) || !entry.getName().endsWith(".class")) continue;
                            String classSubPath = entry.getName().replace('/', '.');
                            classSubPath = classSubPath.substring(0, classSubPath.length() - 6);
                            Class<?> c = classLoader.loadClass(classSubPath);
                            classes.add(c);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static String getUpTime(long _startTime) {
        StringBuilder report = new StringBuilder(100);
        report.append("started: ");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        report.append(format.format(_startTime));
        report.append(", ");
        long delta = System.currentTimeMillis() - _startTime;
        report.append("uptime: ");
        Duration duration = Duration.ofMillis(delta);
        report.append(String.format("%dd %02d:%02d:%02d", duration.toDays(), duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart()));
        return report.toString();
    }

    public static String getExceptionMessage(Throwable t, Class<?>[] noIncludeClassnameExceptions) {
        Object message;
        boolean includeClassname = true;
        if (noIncludeClassnameExceptions != null) {
            for (Class<?> noIncludeClassnameException : noIncludeClassnameExceptions) {
                if (!noIncludeClassnameException.isInstance(t)) continue;
                includeClassname = false;
            }
        }
        Object object = includeClassname ? t.toString() : (message = t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName());
        if (t.getCause() != null && t.getCause() != t) {
            message = (String)message + " <= " + FrkUtils.getExceptionMessage(t.getCause(), noIncludeClassnameExceptions);
        }
        return message;
    }

    public static Check processCommandCheckParameters(String[] parameters, Logger logger) throws DriverException {
        try {
            return Check.processCommandCheckParameters((String[])parameters, (Logger)logger);
        }
        catch (BGException e) {
            throw new DriverException("error parse check data", e);
        }
    }
}

