/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.action.pub;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationFinder;
import ru.bitel.bgbilling.plugins.fias.server.action.pub.ActionGetAbonentBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ActionGetAbonentLocation
extends ActionGetAbonentBase {
    @Override
    protected Document BuildResponseXML(String numberForAnswer, LocationFinder.AddressData addressData) throws BGException {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("response");
            doc.appendChild(rootNode);
            rootNode.setAttribute("xsi:noNamespaceSchemaLocation", "pull_response.xsd");
            rootNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLScgema-instance");
            rootNode.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
            Element resultCode = XMLUtils.createElement((Element)rootNode, (String)"resultCode");
            Element resultDescription = XMLUtils.createElement((Element)rootNode, (String)"resultDescription");
            if (addressData == null || addressData.getCid() <= 0) {
                resultCode.setTextContent("4");
                resultDescription.setTextContent("UNKNOWN SUBSCRIBER");
                return doc;
            }
            resultCode.setTextContent("0");
            Element presence = XMLUtils.createElement((Element)rootNode, (String)"presence");
            presence.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            presence.setAttribute("xsi:schemaLocation", "urn:ieetf:params:xml:ns:pidf presence.xsd");
            presence.setAttribute("xmlns:fs", "http://www.svetets.ru/fias");
            presence.setAttribute("xmlns:gml", "http://www.opengis.net/gml");
            presence.setAttribute("xmlns:cl", "urn:ietf:params:xml:ns:pidf:geopriv10:civicLoc");
            presence.setAttribute("xmlns:gp", "urn:ietf:params:xml:ns:pidf:geopriv10");
            presence.setAttribute("xmlns:dm", "urn:ietf:params:xml:ns:pidf:data-model");
            presence.setAttribute("xmlns", "urn:ietf:params:xml:ns:pidf");
            presence.setAttribute("entity", numberForAnswer);
            Element dm_device = XMLUtils.createElement((Element)presence, (String)"dm:device");
            dm_device.setAttribute("id", addressData.getDeviceId());
            Element gp_geopriv = XMLUtils.createElement((Element)dm_device, (String)"gp:geopriv");
            Element gp_location_info = XMLUtils.createElement((Element)gp_geopriv, (String)"gp:location-info");
            Element gml_location = XMLUtils.createElement((Element)gp_location_info, (String)"gml:location");
            Element cl_civicAddress = XMLUtils.createElement((Element)gml_location, (String)"cl:civicAddress");
            Element fs_House = XMLUtils.createElement((Element)cl_civicAddress, (String)"fs:HOUSE");
            Element cl_HOUSEGUID = XMLUtils.createElement((Element)fs_House, (String)"fs:HOUSEGUID");
            cl_HOUSEGUID.setTextContent(addressData.getHouseGuid());
            Element cl_ENTRANCE = XMLUtils.createElement((Element)fs_House, (String)"fs:ENTRANCE");
            cl_ENTRANCE.setTextContent(addressData.getEntrance());
            Element cl_LEVEL = XMLUtils.createElement((Element)fs_House, (String)"fs:LEVEL");
            cl_LEVEL.setTextContent(addressData.getLevel());
            Element cl_ROOM = XMLUtils.createElement((Element)fs_House, (String)"fs:ROOM");
            cl_ROOM.setTextContent(addressData.getRoom());
            Element dm_deviceID = XMLUtils.createElement((Element)dm_device, (String)"dm:deviceID");
            dm_deviceID.setTextContent(numberForAnswer);
            Element dm_timestamp = XMLUtils.createElement((Element)dm_device, (String)"dm:timestamp");
            dm_timestamp.setTextContent(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
            return doc;
        }
        catch (Exception ex) {
            throw new BGException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

