/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;

public class StatusMatrixPanel
extends BGUPanel {
    private List<Status> statusList = new ArrayList<Status>();
    private List<Integer> statusIds = new ArrayList<Integer>();
    private BGUTable matrixTable = null;
    private BGUTable defaultMatrixTable = null;
    private MatrixTableModel matrixTableModel = null;
    private DefaultMatrixTableModel defaultMatrixTableModel = null;
    private ContractStatusService contractStatusService = null;
    private final StatusMatrix statusMatrix;
    private final String entityTitle;

    public StatusMatrixPanel(StatusMatrix statusMatrix, String entityTitle) {
        this.statusMatrix = statusMatrix;
        this.entityTitle = entityTitle;
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDefaultMatrixPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getMatrixPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel getDefaultMatrixPanel() {
        this.defaultMatrixTable = new BGUTable(null);
        Font font = this.defaultMatrixTable.getFont();
        font = font.deriveFont((float)font.getSize() + 5.0f);
        this.defaultMatrixTable.setFont(font);
        this.defaultMatrixTable.setRowHeight(this.getFontMetrics(font).getHeight() + 5);
        this.defaultMatrixTable.setRowSelectionAllowed(false);
        BGSwingUtilites.handleMouseClicked(this.defaultMatrixTable, this::defaultMatrixTableMouseClicked);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.defaultMatrixTable, 100, 50), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private void defaultMatrixTableMouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            JSONObject jsonObject;
            String statusId = this.defaultMatrixTableModel.getIdentifier(this.defaultMatrixTable.convertColumnIndexToModel(this.defaultMatrixTable.getSelectedColumn()));
            jsonObject.put(statusId, !(jsonObject = ((RowData)this.defaultMatrixTableModel.getSelectedRow()).getJson()).getBoolean(statusId));
            Boolean[][] values = new Boolean[1][this.statusList.size()];
            int s = 0;
            for (Status status : this.statusList) {
                values[0][s++] = jsonObject.getBoolean(String.valueOf(status.getId()));
            }
            this.tryCall(() -> {
                this.statusMatrix.valuesUpdate(Arrays.asList(0), this.statusIds, values);
                this.setData();
            });
        }
    }

    private JPanel getMatrixPanel() {
        this.matrixTable = new BGUTable(null);
        BGSwingUtilites.handleMouseClicked(this.matrixTable, e -> this.matrixTableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.matrixTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private void matrixTableMouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2 && !this.matrixTableModel.getSelectedRows().isEmpty()) {
            this.openMatrixEditor();
        } else if (SwingUtilities.isRightMouseButton(event)) {
            this.getPopupMenu().show(this.matrixTable, event.getX(), event.getY());
        }
    }

    @Override
    protected void getPopupMenuItems() {
        this.popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.openMatrixEditor());
    }

    public void openMatrixEditor() {
        List<RowData> selectedRows = this.matrixTableModel.getSelectedRows();
        if (selectedRows.isEmpty()) {
            ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438");
        } else {
            new MatrixEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0430\u0442\u0440\u0438\u0446\u044b", selectedRows).open();
            this.matrixTableModel.fireTableDataChanged();
        }
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = ((ClientContext)this.getContext()).getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    public void setData() {
        this.tryCall(() -> {
            this.statusList = this.getContractStatusService().getStatusList(false);
            this.statusIds = this.statusList.stream().map(a -> a.getId()).collect(Collectors.toList());
            this.matrixTableModel = new MatrixTableModel(this.entityTitle);
            this.matrixTable.setModel(this.matrixTableModel);
            this.defaultMatrixTableModel = new DefaultMatrixTableModel();
            this.defaultMatrixTable.setModel(this.defaultMatrixTableModel);
            List<IdTitle> services = this.statusMatrix.list();
            Boolean[][] values = this.statusMatrix.valuesGet(services.stream().map(a -> a.getId()).collect(Collectors.toList()), this.statusIds, false);
            int r = 0;
            ArrayList<RowData> rows = new ArrayList<RowData>();
            for (IdTitle service : services) {
                JSONObject rowJsonObject = new JSONObject();
                rowJsonObject.put("serviceId", service.getId());
                rowJsonObject.put("serviceTitle", (Object)service.getTitle());
                if (this.statusList != null) {
                    int c = 0;
                    for (Status status : this.statusList) {
                        rowJsonObject.put(String.valueOf(status.getId()), (Object)values[r][c++]);
                    }
                }
                rows.add(new RowData(rowJsonObject));
                ++r;
            }
            this.matrixTableModel.setData(rows);
            Boolean[][] defaultValues = this.statusMatrix.valuesGet(Arrays.asList(0), this.statusIds, false);
            rows = new ArrayList();
            JSONObject rowJsonObject = new JSONObject();
            rowJsonObject.put("serviceId", 0);
            if (this.statusList != null) {
                int c = 0;
                for (Status status : this.statusList) {
                    Boolean value = defaultValues[0][c++];
                    rowJsonObject.put(String.valueOf(status.getId()), value != null ? value : false);
                }
            }
            rows.add(new RowData(rowJsonObject));
            this.defaultMatrixTableModel.setData(rows);
        });
    }

    public void editItem() {
        this.openMatrixEditor();
    }

    class MatrixTableModel
    extends BGTableModel<RowData> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SERVIC_TITLE = "serviceTitle";
        public static final String VALUE_ON = "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";
        public static final String VALUE_OFF = "\u043d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";
        public static final String VALUE_DEFAULT = "\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";

        public MatrixTableModel(String title) {
            super(MatrixTableModel.class.getName());
            this.addColumn(title, 200, 400, -1, COLUMN_SERVIC_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
            if (StatusMatrixPanel.this.statusList != null) {
                for (Status status : StatusMatrixPanel.this.statusList) {
                    this.addColumn(status.getTitle(), 100, 200, -1, String.valueOf(status.getId()), true, new MyRenderer());
                }
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject rowJsonObject = rowData.getJson();
            switch (identifier) {
                case "id": {
                    return rowJsonObject.optInt("serviceId");
                }
                case "serviceTitle": {
                    return rowJsonObject.optString(identifier);
                }
            }
            boolean def = !rowJsonObject.has(identifier);
            JSONObject defJson = ((RowData)StatusMatrixPanel.this.defaultMatrixTableModel.getRows().get(0)).getJson();
            return new CellData(StatusMatrixPanel.this, def, !def ? (rowJsonObject.optBoolean(identifier) ? VALUE_ON : VALUE_OFF) : (defJson.optBoolean(identifier) ? VALUE_ON : VALUE_OFF));
        }
    }

    class DefaultMatrixTableModel
    extends BGTableModel<RowData> {
        public DefaultMatrixTableModel() {
            super(DefaultMatrixTableModel.class.getName());
            if (StatusMatrixPanel.this.statusList != null) {
                for (Status status : StatusMatrixPanel.this.statusList) {
                    this.addColumn(status.getTitle(), 100, 200, -1, String.valueOf(status.getId()), true, new MyRenderer());
                }
            }
        }

        @Override
        protected void initColumns() {
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            return new CellData(StatusMatrixPanel.this, false, rowData.getJson().optBoolean(this.getIdentifier(column)) ? "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c" : "\u043d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c");
        }
    }

    public static interface StatusMatrix {
        public List<IdTitle> list() throws Exception;

        public Boolean[][] valuesGet(List<Integer> var1, List<Integer> var2, boolean var3) throws Exception;

        public void valuesUpdate(List<Integer> var1, List<Integer> var2, Boolean[][] var3) throws Exception;
    }

    class MatrixEditor
    extends BGEditorDialog<List<RowData>> {
        private EditorTableModel editorTableModel;

        public MatrixEditor(String title, List<RowData> data) {
            super(title, data);
            this.editorTableModel = new EditorTableModel();
        }

        @Override
        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            BGUTable table = new BGUTable(this.editorTableModel);
            table.setSelectionMode(0);
            BGSwingUtilites.handleLDMouseClicked(table, e -> this.tableMouseClicked(table, (MouseEvent)e));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 700, 200), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            ArrayList<RowData> datas = new ArrayList<RowData>();
            for (Status status : StatusMatrixPanel.this.statusList) {
                String statusId = String.valueOf(status.getId());
                String value = null;
                for (RowData rowData : (List)this.data) {
                    JSONObject json = rowData.getJson();
                    String statusValue = String.valueOf(json.has(statusId) ? Boolean.valueOf(json.optBoolean(statusId, false)) : "default");
                    if (value == null) {
                        value = statusValue;
                        continue;
                    }
                    if (value.equals(statusValue)) continue;
                    value = "current";
                    break;
                }
                if (value == null) continue;
                JSONObject jsonObject = new JSONObject().put("id", status.getId()).put("title", (Object)status.getTitle()).put("value", value);
                datas.add(new RowData(jsonObject));
            }
            this.editorTableModel.setData(datas);
        }

        private void tableMouseClicked(BGUTable table, MouseEvent event) {
            String value = this.editorTableModel.getIdentifier(table.convertColumnIndexToModel(table.getSelectedColumn()));
            ((RowData)this.editorTableModel.getSelectedRow()).getJson().put("value", (Object)value);
            this.editorTableModel.fireTableDataChanged();
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.data != null) {
                Boolean[][] values = new Boolean[((List)this.data).size()][StatusMatrixPanel.this.statusList.size()];
                int r = 0;
                for (RowData rowData : (List)this.data) {
                    int s = 0;
                    JSONObject rowJsonObject = rowData.getJson();
                    for (RowData status : this.editorTableModel.getRows()) {
                        String statusId = String.valueOf(status.getJson().getInt("id"));
                        String statusValue = status.getJson().getString("value");
                        if ("default".equals(statusValue)) {
                            rowJsonObject.remove(statusId);
                        } else if (!"current".equals(statusValue)) {
                            rowJsonObject.put(statusId, (Object)statusValue);
                        }
                        values[r][s++] = rowJsonObject.has(statusId) ? Boolean.valueOf(rowJsonObject.optBoolean(statusId)) : null;
                    }
                    ++r;
                }
                StatusMatrixPanel.this.statusMatrix.valuesUpdate(((List)this.data).stream().map(a -> a.getJson().optInt("serviceId")).collect(Collectors.toList()), StatusMatrixPanel.this.statusIds, values);
            }
            return true;
        }
    }

    class CellData {
        private boolean def;
        private String title;

        public CellData(StatusMatrixPanel this$0, boolean def, String title) {
            this.def = def;
            this.title = title;
        }

        public boolean isDef() {
            return this.def;
        }

        public String toString() {
            return this.title;
        }
    }

    class MyRenderer
    extends HorizontalAlignmentTableCellRenderer {
        private Color defaultColor;

        public MyRenderer() {
            super(0);
            this.defaultColor = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color color = this.defaultColor;
                if (value instanceof CellData && !((CellData)value).isDef()) {
                    color = "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c".equals(value.toString()) ? Color.GREEN : new Color(255, 192, 192);
                }
                component.setBackground(color);
            }
            return component;
        }
    }

    class EditorTableModel
    extends BGTableModel<RowData> {
        public EditorTableModel() {
            super(EditorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c", 100, 100, 100, "true", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c", 100, 100, 100, "false", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u0422\u0435\u043a\u0443\u0449\u0435\u0435", 100, 100, 100, "current", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", 100, 100, 100, "default", false, new RadioButtonTableCellRenderer());
        }

        @Override
        public Object getValue(RowData val, int column) throws BGException {
            String i = this.getIdentifier(column);
            if ("title".equals(i)) {
                return val.getJson().optString(i);
            }
            return i.equals(val.getJson().optString("value"));
        }
    }

    class TitleLabel
    extends JLabel {
        public TitleLabel(String text) {
            super(text);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }
    }
}

