/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tools.client;

import bitel.billing.module.common.BGDialog;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.net.URI;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.function.Async;

public class ToolDialog
extends BGDialog {
    private static final String COMMAND_EXEC = "exec:";
    private final JTextPane textArea = new JTextPane();
    private final BGButton button = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");

    public ToolDialog(ClientContext context) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        int width = displayMode.getWidth();
        int height = displayMode.getHeight();
        this.add(this.getPanel());
        this.pack();
        this.setMinimumSize(new Dimension(500, 400));
        this.setLocation(width > 0 ? width >>> 1 : 0, height > 0 ? height >>> 1 : 0);
        this.setLocationRelativeTo(BGClient.getFrame());
    }

    public JPanel getPanel() {
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setText("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430...");
        this.textArea.setEditable(false);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add((Component)this.button, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.textArea), true), "Center");
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    public void handler(String result, Throwable ex) {
        SwingUtilities.invokeLater(() -> {
            if (ex != null) {
                Throwable t = ex;
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                if (t instanceof SOAPFaultException && t.getCause() != null) {
                    t = t.getCause();
                }
                if (t instanceof BGRuntimeException) {
                    t = t.getCause();
                }
                if (t instanceof BGMessageException) {
                    this.textArea.setText(t.getMessage());
                } else if (t instanceof BGIllegalAccessException) {
                    this.textArea.setText(t.getMessage());
                } else {
                    this.textArea.setText(BGException.printStackTraceToString(t));
                }
                if (!this.isShowing()) {
                    this.showDialog();
                }
            } else if (Utils.notBlankString(result)) {
                if (result.startsWith("browse:")) {
                    String result2 = result.substring(7);
                    this.browse(result2);
                    this.dispose();
                } else if (result.startsWith("telnet:")) {
                    String result2 = result.substring(7);
                    this.telnet(result2);
                    this.dispose();
                } else if (result.startsWith("ping:")) {
                    String result2 = result.substring(5);
                    this.ping(result2);
                    this.dispose();
                } else if (result.startsWith(COMMAND_EXEC)) {
                    String[] command = new String[]{result.substring(COMMAND_EXEC.length())};
                    this.exec(command);
                    this.dispose();
                } else {
                    if (result.startsWith("<html>")) {
                        this.textArea.setContentType("text/html");
                    }
                    this.textArea.setText(result);
                    if (!this.isShowing()) {
                        this.showDialog();
                    }
                }
            }
        });
    }

    public void setFuture(Async<String> future) {
        this.button.addActionListener(a -> {
            this.dispose();
            if (!future.getFuture().isDone()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u043e\u043a\u043d\u0430 \u043d\u0435 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 2);
            }
        });
        String result = null;
        try {
            result = future.getFuture().get(5L, TimeUnit.SECONDS);
            if (Utils.notBlankString(result) && !this.isShowing()) {
                this.showDialog();
            }
        }
        catch (TimeoutException e) {
            if (!this.isShowing()) {
                this.showDialog();
            }
        }
        catch (InterruptedException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        catch (ExecutionException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void telnet(String telnet) {
        try {
            int port = 21;
            int index = telnet.lastIndexOf(32);
            if (index > 0) {
                port = Utils.parseInt(telnet.substring(index + 1), 21);
                telnet = telnet.substring(0, index);
            }
            ClientUtils.openTelnet(telnet, port);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void ping(String host) {
        try {
            boolean win = System.getProperty("os.name").toLowerCase().contains("win");
            String cmd = win ? "ping -t " + host : "ping " + host;
            ClientUtils.openTerminal(cmd);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void browse(String url) {
        try {
            ClientUtils.openBrowser(new URI(url));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void exec(String[] command) {
        try {
            ClientUtils.exec(command);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }
}

