/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action;

import bitel.billing.server.ActionBase;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseProduct;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseComponentDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseProductDao;

public class ActionProductItemProductList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int productId = this.getIntParameter("product_id", -1);
        int productItemId = this.getIntParameter("product_item_id", -1);
        if (productId > 0) {
            Element selectList = this.createElement(this.rootNode, "list_select");
            Element availableList = this.createElement(this.rootNode, "list_available");
            LicenseComponentDao licenseComponentDao = new LicenseComponentDao(this.con, this.mid);
            List<LicenseComponent> selectedProductItems = licenseComponentDao.listForProduct(productId);
            List<LicenseComponent> allProductItems = licenseComponentDao.list();
            for (LicenseComponent pi : allProductItems) {
                if (!this.isSelected(pi, selectedProductItems)) {
                    this.addListItem(availableList, String.valueOf(pi.getId()), pi.getTitle());
                    continue;
                }
                this.addListItem(selectList, String.valueOf(pi.getId()), pi.getTitle());
            }
        } else if (productItemId > 0) {
            Element selectList = this.createElement(this.rootNode, "list_select");
            Element availableList = this.createElement(this.rootNode, "list_available");
            LicenseProductDao licenseProductDao = new LicenseProductDao(this.con, this.mid);
            List<LicenseProduct> selectedProducts = licenseProductDao.getProductsWithComponent(productItemId);
            List<LicenseProduct> allProducts = licenseProductDao.list();
            for (LicenseProduct p : allProducts) {
                if (!this.isSelected(p, selectedProducts)) {
                    this.addListItem(availableList, String.valueOf(p.getId()), p.getTitle() + " " + p.getVersion());
                    continue;
                }
                this.addListItem(selectList, String.valueOf(p.getId()), p.getTitle() + " " + p.getVersion());
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }

    private boolean isSelected(LicenseComponent productItem, List<LicenseComponent> selectedProductItems) {
        for (LicenseComponent selectedItem : selectedProductItems) {
            if (selectedItem.getId() != productItem.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean isSelected(LicenseProduct product, List<LicenseProduct> selectedProducts) {
        for (LicenseProduct selectedProduct : selectedProducts) {
            if (selectedProduct.getId() != product.getId()) continue;
            return true;
        }
        return false;
    }
}

