/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.bean;

import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final String ORDER_STATUS_REGISTER = "0";
    private static final String ORDER_STATUS_APPROVED = "1";
    private static final String ORDER_STATUS_DEPOSITED = "2";
    private static final String ORDER_STATUS_REVERSED = "3";
    private static final String ORDER_STATUS_REFUNDED = "4";
    private static final String ORDER_STATUS_AUTHORIZATION = "5";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "alfabank_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionId(rs.getString("order_id"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setStatus(rs.getString("status"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected Transaction getImpl(int transactionId) throws SQLException {
        return (Transaction)this.getById(transactionId);
    }

    protected String getQueryById() {
        return "SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?";
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws SQLException {
        boolean result = false;
        if (transaction != null && newTransactionStatus != null) {
            String query = "UPDATE " + this.tableName + " SET status=? WHERE status=? AND id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                ps.setString(index++, newTransactionStatus.getCode());
                ps.setString(index++, transaction.getStatus());
                ps.setInt(index++, transaction.getId());
                boolean bl = result = ps.executeUpdate() > 0;
                if (result) {
                    transaction.setStatus(newTransactionStatus.getCode());
                }
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws Exception {
        Page page = new Page(1, this.moduleSetup.getInt("alfabank.transaction.status.check.count", 5));
        SearchParam searchParam = SearchParam.builder().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode()).setAutopayment(Boolean.valueOf(autopaymentTransaction)).setPage(page).setSort(new String[]{"createDate:1"}).build();
        SearchResult searchResult = new SearchResult(searchParam);
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            String orderId = transaction.getTransactionId();
            this.getLogger().debug("alfabankTransactionId = {}", (Object)transaction.getId());
            this.getLogger().debug("alfabankTransactionOrderId = {}", (Object)orderId);
            if (orderId == null) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                this.update(transaction);
                try {
                    this.con.commit();
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                continue;
            }
            String userName = this.getUserName(autopaymentTransaction);
            String userPswd = this.getUserPswd(autopaymentTransaction);
            userName = URLEncoder.encode(userName, "UTF-8");
            userPswd = URLEncoder.encode(userPswd, "UTF-8");
            orderId = URLEncoder.encode(orderId, "UTF-8");
            StringBuilder spec = new StringBuilder().append(this.moduleSetup.get("alfabank.rest.order.status.url", "https://test.paymentgate.ru/testpayment/rest/getOrderStatusExtended.do"));
            StringBuilder query = new StringBuilder().append("language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&orderId=").append(orderId).append("&userName=").append(userName).append("&password=").append(userPswd);
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec.toString());
            this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {}", (Object)query.toString());
            StringBuilder resultJson = this.doConnection(spec.toString(), "POST", true, query.toString());
            this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
            if (resultJson == null) {
                return;
            }
            boolean error = false;
            JSONObject resultJsonObject = new JSONObject(resultJson.toString());
            String errorCode = resultJsonObject.optString("ErrorCode", resultJsonObject.optString("errorCode", null));
            if (errorCode == null || ORDER_STATUS_REGISTER.equals(errorCode)) {
                String orderNumber = resultJsonObject.optString("OrderNumber", resultJsonObject.optString("orderNumber", null));
                String orderStatus = resultJsonObject.optString("OrderStatus", resultJsonObject.optString("orderStatus", null));
                if (orderStatus != null) {
                    String paymentWay;
                    if (ORDER_STATUS_AUTHORIZATION.equals(orderStatus)) continue;
                    if (!ORDER_STATUS_REGISTER.equals(orderStatus) && !ORDER_STATUS_APPROVED.equals(orderStatus)) {
                        if (ORDER_STATUS_DEPOSITED.equals(orderStatus)) {
                            if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                                this.getLogger().error("Transaction for ID = {} has status != 'created'", (Object)orderNumber);
                            } else if (transaction.getPaymentId() > 0) {
                                this.getLogger().error("Transaction for ID = {} has paymentId > 0", (Object)orderNumber);
                            } else {
                                this.addTransactionPayment(transaction, TransactionManager.getParamString((JSONObject)resultJsonObject, (String)transaction.getParameters()));
                                JSONObject bindingInfo = resultJsonObject.optJSONObject("bindingInfo");
                                if (bindingInfo != null) {
                                    PeriodWithTime period;
                                    AutopaymentManager autopaymentManager;
                                    Autopayment autopayment;
                                    String clientId = bindingInfo.optString("clientId", null);
                                    String bindingId = bindingInfo.optString("bindingId", null);
                                    if (clientId != null && bindingId != null && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(contractId)) != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                                        period.setLocalDateTimeFrom(LocalDateTime.now());
                                        autopayment.setAccessToken(bindingId);
                                        autopaymentManager.updateAutopayment(autopayment);
                                    }
                                }
                            }
                        } else if (ORDER_STATUS_REVERSED.equals(orderStatus) || ORDER_STATUS_REFUNDED.equals(orderStatus)) {
                            if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                                this.getLogger().error("Transaction for ID = {} has status != 'ok'", (Object)orderNumber);
                                error = true;
                            } else if (transaction.getPaymentId() < 1) {
                                this.getLogger().error("Transaction for ID = {} has paymentId < 1", (Object)orderNumber);
                                error = true;
                            } else {
                                PaymentDao paymentDao = new PaymentDao(this.con);
                                Payment payment = (Payment)paymentDao.get(transaction.getPaymentId());
                                paymentDao.delete(transaction.getPaymentId());
                                transaction.setStatus(TransactionStatus.ERROR.getCode());
                                transaction.setPaymentId(0);
                                this.update(transaction);
                                if (payment != null) {
                                    try (BalanceUtils bu = new BalanceUtils(this.con);){
                                        bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                                    }
                                    EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                                }
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (Utils.notEmptyString((String)(paymentWay = resultJsonObject.optString("paymentWay")))) {
                        BGTransactionType transactionType = switch (paymentWay) {
                            case "CARD" -> BGTransactionType.CARD;
                            case "SBP" -> BGTransactionType.QR_SBP;
                            case "SBP_C2B" -> BGTransactionType.QR_SBP;
                            default -> BGTransactionType.OTHER;
                        };
                        transaction.setTransactionType(transactionType);
                        this.update(transaction);
                    }
                }
            } else {
                error = true;
            }
            if (error) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setParameters(TransactionManager.getParamString((JSONObject)resultJsonObject, (String)transaction.getParameters()));
                this.update(transaction);
            }
            this.con.commit();
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, String returnUrl) throws Exception {
        if (autopaymentTransaction || requestBindingId) {
            AlfabankAutopaymentSumEvent event = new AlfabankAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((AlfabankAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setAutopayment(autopaymentTransaction)).build();
        this.update(transaction);
        String userName = URLEncoder.encode(this.getUserName(autopaymentTransaction), "UTF-8");
        String userPswd = URLEncoder.encode(this.getUserPswd(autopaymentTransaction), "UTF-8");
        String description = this.moduleSetup.get("alfabank.rest.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
        description = URLEncoder.encode(description.replace("{CONTRACT_TITLE}", contractTitle), "UTF-8");
        String features = this.moduleSetup.get(autopaymentTransaction ? "alfabank.autopayment.features" : "alfabank.payment.features", null);
        int currency = this.moduleSetup.getInt("alfabank.rest.currency", 0);
        returnUrl = Utils.isBlankString((String)returnUrl) ? URLEncoder.encode(this.moduleSetup.get("alfabank.rest.return.url", ""), "UTF-8") : URLEncoder.encode(returnUrl, "UTF-8");
        String billingName = this.moduleSetup.get("alfabank.billing.name", Setup.getSetup().get("billing.name"));
        String spec = this.moduleSetup.get("alfabank.rest.register.url", "https://test.paymentgate.ru/testpayment/rest/register.do");
        StringBuilder query = new StringBuilder().append("amount=").append(sum.multiply(new BigDecimal(100)).setScale(0)).append(currency > 0 ? "&currency=" : "").append(currency > 0 ? Integer.valueOf(currency) : "").append("&language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&orderNumber=").append(transaction.getId()).append("&userName=").append(userName).append("&password=").append(userPswd).append("&description=").append(description).append("&returnUrl=").append(returnUrl);
        if (requestBindingId) {
            StringBuilder clientId = new StringBuilder();
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            query.append("&clientId=").append(clientId.toString());
        }
        if (Utils.notBlankString((String)features)) {
            query.append("&features=").append(features);
        }
        this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec);
        this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {}", (Object)query.toString());
        StringBuilder resultJson = this.doConnection(spec, "POST", true, query.toString());
        this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
        try {
            JSONObject resultJsonObject = new JSONObject(resultJson.toString());
            for (String key : new String[]{"orderId", "formUrl", "errorCode", "errorMessage"}) {
                if (!resultJsonObject.has(key)) continue;
                dataMap.put(key, resultJsonObject.get(key));
            }
        }
        catch (JSONException ex) {
            this.logError(ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        if (dataMap.containsKey("orderId")) {
            transaction.setParameters("orderId=" + String.valueOf(dataMap.get("orderId")));
            transaction.setTransactionId(String.valueOf(dataMap.get("orderId")));
            this.update(transaction);
        } else if (dataMap.containsKey("errorCode")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setParameters("errorCode=" + String.valueOf(dataMap.get("errorCode")) + "\nerrorMessage=" + String.valueOf(dataMap.get("errorMessage")));
            this.update(transaction);
        } else {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setParameters("resultJson=" + resultJson.toString());
            this.update(transaction);
        }
        return transaction;
    }

    public String paymentOrderBinding(Transaction transaction, Autopayment autopayment) {
        String result = null;
        if (transaction != null && autopayment != null) {
            String userName = this.moduleSetup.get("alfabank.autopayment.rest.user.name", "autopaymentUser");
            String userPswd = this.moduleSetup.get("alfabank.autopayment.rest.user.pswd", "autopaymentPassword");
            String bindingId = autopayment.getAccessToken();
            try {
                userName = URLEncoder.encode(userName, "UTF-8");
                userPswd = URLEncoder.encode(userPswd, "UTF-8");
                bindingId = URLEncoder.encode(bindingId, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (transaction.getTransactionId() == null) {
                this.getLogger().error("transaction.getTransactionId() = null for ID=" + transaction.getId());
                return result;
            }
            String url = this.moduleSetup.get("alfabank.rest.order.binding.url", "https://test.paymentgate.ru/testpayment/rest/paymentOrderBinding.do");
            StringBuilder spec = new StringBuilder().append("language=").append(this.moduleSetup.get("alfabank.rest.language", "ru")).append("&mdOrder=").append(transaction.getTransactionId()).append("&bindingId=").append(bindingId).append("&tii=U").append("&userName=").append(userName).append("&password=").append(userPswd);
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)url);
            this.getLogger().debug("\t\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {}", (Object)spec.toString());
            StringBuilder resultJson = null;
            try {
                resultJson = this.doConnection(url, "POST", true, spec.toString());
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)String.valueOf(resultJson));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            if (resultJson != null) {
                StringBuilder resultData = new StringBuilder();
                JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                if (resultJsonObject != null) {
                    if (resultJsonObject.has("errorCode")) {
                        resultData.append("errorCode=").append(resultJsonObject.getInt("errorCode")).append("\n");
                    }
                    if (resultJsonObject.has("info")) {
                        resultData.append("info=").append(resultJsonObject.getString("info")).append("\n");
                    }
                    if (resultJsonObject.has("redirect")) {
                        resultData.append("redirect=").append(resultJsonObject.getString("redirect")).append("\n");
                    }
                    result = resultData.toString();
                }
            }
        }
        return result;
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws Exception {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            Payment payment = Payment.builder().setDate(new Date()).setTypeId(this.moduleSetup.getInt("alfabank.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("alfabank.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0410\u043b\u044c\u0444\u0430 \u0431\u0430\u043d\u043a\u0430").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).setData(this.getPaymentData(transaction)).build();
            new PaymentDao(this.con).update((Object)payment);
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            transaction.setParameters(transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("alfabank.request.timeout", 10000));
    }

    private String getUserName(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("alfabank.autopayment.rest.user.name", "autopaymentUser") : this.moduleSetup.get("alfabank.rest.user.name", "user");
    }

    private String getUserPswd(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("alfabank.autopayment.rest.user.pswd", "autopaymentPassword") : this.moduleSetup.get("alfabank.rest.user.pswd", "password");
    }

    protected <T extends BGAbstractTransaction> String getPaymentData(T transaction) {
        return super.getPaymentData(transaction);
    }
}

