/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeries;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionCardSeries
extends ActionBase {
    public void doAction() throws Exception {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        CardSeriesManager sm = new CardSeriesManager(this.con, this.mid);
        List<CardSeries> seriesList = sm.getSeriesList();
        for (CardSeries s : seriesList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(s.getId()));
            row.setAttribute("contractPattern", s.getContractPatternTitle());
            row.setAttribute("paymentType", s.getPaymentTypeTitle());
            row.setAttribute("serviceActivate", s.getServiceActivateTitle());
            row.setAttribute("serviceBalance", s.getServiceBalanceTitle());
            row.setAttribute("summ", Utils.formatCost((float)s.getSumm()));
            row.setAttribute("title", s.getTitle());
            row.setAttribute("period", TimeUtils.formatPeriod((Calendar)s.getDate1(), (Calendar)s.getDate2()));
            row.setAttribute("free", String.valueOf(s.getFreeCard()));
        }
    }
}

