/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.helpdesk.client.bean.PackageTableModel;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskPackageTab;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class HelpdeskPackageEditor
extends BGPanel {
    private HelpdeskPackageTab panel = null;
    private PackageTableModel tableModel = new PackageTableModel();
    private BGButtonPanelOkCancel panelOkCancel = new BGButtonPanelOkCancel();

    public HelpdeskPackageEditor(HelpdeskPackageTab packagePanel) {
        this.panel = packagePanel;
        this.jbInit();
    }

    private void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        this.panelOkCancel.getButtonOk().setText("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.panelOkCancel.addActionListener(event -> {
            if ("ok".equals(event.getActionCommand())) {
                this.updateData();
            } else {
                this.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.panelOkCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        try {
            SearchResult searchResult = ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).packageList(null, new Page(1, 1000));
            this.tableModel.setData(searchResult.getList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void updateData() {
        Package pkg = (Package)this.tableModel.getSelectedRow();
        if (pkg == null) {
            ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442!");
            return;
        }
        Request request = new Request().setModule(this.getContext().getModule()).setContractId(this.getContext().getContractId()).setAction("UpdateContractPackage").setAttribute("id", pkg.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.setVisible(false);
            this.panel.performAction("refresh");
        }
    }
}

