/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.jws.WebService;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.modules.inet.common.service.RequestLogService;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.concurrent.ConcurrentUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.RequestLogService")
public class RequestLogServiceImpl
extends AbstractService
implements RequestLogService {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String inetConnectionLog(int deviceId, long connectionId, Date connectionStartTime) throws BGException {
        connection = InetUtils.getConnection(this.getConnection(), this.moduleId, connectionId, connectionStartTime);
        if (connection == null) {
            inetConnectionDao = new InetConnectionDao(this.getConnection(), this.moduleId);
            try {
                connection = inetConnectionDao.get(deviceId, connectionId);
            }
            finally {
                inetConnectionDao.close();
            }
        }
        if (connection == null) {
            return "\u0421\u0435\u0441\u0441\u0438\u044f:" + connectionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
        }
        dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
        entryList = dataLogEntryDao.list(connection.getConnectionStart(), connection.getConnectionStop(), deviceId, connection.getDevicePort(), connection.getAcctSessionId(), connection.getId(), null);
        map = new HashMap<Integer, ArrayList<ConnectionLogEntry>>();
        for (ConnectionLogEntry entry : entryList) {
            list = (ArrayList<ConnectionLogEntry>)map.get(entry.getApplicationId());
            if (list == null) {
                list = new ArrayList<ConnectionLogEntry>();
                map.put(entry.getApplicationId(), list);
            }
            list.add(entry);
        }
        futures = new ArrayList<FutureApplicationId>();
        timeout = (long)this.context.getModuleSetup().getInt("requestLog.request.timeout", 30) * 1000L;
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Send request to appId#{}", e.getKey());
                for (ConnectionLogEntry connectionLogEntry : (List)e.getValue()) {
                    this.getLogger().debug("\tconnectionLogEntry.getId() = " + connectionLogEntry.getId());
                    this.getLogger().debug("\tconnectionLogEntry.getLogType() = " + connectionLogEntry.getLogType());
                    this.getLogger().debug("\tconnectionLogEntry.getDeviceId() = " + connectionLogEntry.getDeviceId());
                    this.getLogger().debug("\tconnectionLogEntry.getIdentifier() = " + connectionLogEntry.getIdentifier());
                    this.getLogger().debug("\tconnectionLogEntry.getConnectionId() = " + connectionLogEntry.getConnectionId());
                    this.getLogger().debug("\tconnectionLogEntry.getApplicationId() = " + connectionLogEntry.getApplicationId());
                }
            }
            event = new RequestLogGetEvent(this.moduleId, deviceId, ((Integer)e.getKey()).intValue(), (List)e.getValue());
            futures.add(new FutureApplicationId((Integer)e.getKey(), EventProcessor.getInstance().requestAsync((Event)event, timeout)));
        }
        try {
            if (ConcurrentUtils.awaitFutures(futures.stream().map((Function<FutureApplicationId, Future>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$inetConnectionLog$0(ru.bitel.bgbilling.modules.inet.server.service.RequestLogServiceImpl$FutureApplicationId ), (Lru/bitel/bgbilling/modules/inet/server/service/RequestLogServiceImpl$FutureApplicationId;)Ljava/util/concurrent/Future;)()).toList(), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS)) {
                // empty if block
            }
        }
        catch (InterruptedException ex) {
            this.logError(ex);
        }
        result = new StringBuilder(1000);
        resultMap = new HashMap<Integer, ArrayList<RequestLogGetEvent.LogEntryResult>>();
        for (FutureApplicationId futureApplicationId : futures) {
            if (futureApplicationId.future.isDone()) {
                try {
                    event = futureApplicationId.future.get();
                    if (event.getLogEntryResultList() != null) {
                        for (RequestLogGetEvent.LogEntryResult logEntryResult : event.getLogEntryResultList()) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug(logEntryResult.getId() + ":\n" + logEntryResult.getData());
                            }
                            if ((list = (ArrayList<RequestLogGetEvent.LogEntryResult>)resultMap.get(logEntryResult.getId())) == null) {
                                list = new ArrayList<RequestLogGetEvent.LogEntryResult>();
                                resultMap.put(logEntryResult.getId(), list);
                            }
                            list.add(logEntryResult);
                        }
                        continue;
                    }
                    this.getLogger().debug("Result list is null for contractId = " + event.getContractId() + "; event.getLogEntryList().size() = " + event.getLogEntryList().size());
                }
                catch (Exception ex) {
                    this.logError(ex);
                    result.append(ex.getMessage()).append(" appId#").append(futureApplicationId.applicationId).append("\n");
                }
                continue;
            }
            result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 appId#").append(futureApplicationId.applicationId).append("\n");
        }
        var14_17 = entryList.iterator();
        block14: while (true) {
            if (!var14_17.hasNext()) {
                return result.toString();
            }
            e = (ConnectionLogEntry)var14_17.next();
            entryResultList = (List)resultMap.get(e.getId());
            if (entryResultList == null) continue;
            result.append(result.length() > 0 ? "\n" : "");
            var17_21 = entryResultList.iterator();
            while (true) {
                if (var17_21.hasNext()) ** break;
                continue block14;
                entryResult = (RequestLogGetEvent.LogEntryResult)var17_21.next();
                result.append(result.length() > 0 ? "\n" : "");
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult != null ? entryResult.getData() : "null");
            }
            break;
        }
    }

    public String authErrorLog(int deviceId, Date errorTime, int logCoordinateRecordId) throws BGException {
        ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
        ConnectionLogEntry entry = dataLogEntryDao.get(deviceId, errorTime, logCoordinateRecordId);
        if (entry == null) {
            return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043b\u043e\u0433\u0430.";
        }
        RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, entry);
        event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
        StringBuilder result = new StringBuilder(1000);
        if (event.getLogEntryResultList() != null) {
            for (RequestLogGetEvent.LogEntryResult entryResult : event.getLogEntryResultList()) {
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult.getData());
                result.append("\n");
            }
        }
        return result.toString();
    }

    private static /* synthetic */ Future lambda$inetConnectionLog$0(FutureApplicationId a) {
        return a.future;
    }

    static class FutureApplicationId {
        Integer applicationId;
        Future<RequestLogGetEvent> future;

        public FutureApplicationId(Integer applicationId, Future<RequestLogGetEvent> future) {
            this.applicationId = applicationId;
            this.future = future;
        }
    }
}

