/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.tariff.directory.DirectoriesManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffNodeMenuItem;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultRootTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.FlushableRootTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public abstract class DefaultTariffTreeNode
implements TariffTreeNode {
    private int check = -1;
    private static Icon okIcon = ClientUtils.getIcon("ok");
    private static Icon cancelIcon = ClientUtils.getIcon("cancel");
    private boolean editable = false;
    private int id = 0;
    private int mtree_id = 0;
    private String type;
    protected ModuleTariffConfig mtc;
    protected TariffTree tree;
    protected TariffVar tariffVar;
    protected List<TariffVar> vars = new ArrayList<TariffVar>();
    private TariffTreeNode parent;
    private DefaultMutableTreeNode viewableNode;
    private DirectoriesManager dirManager;
    private String data = "";
    private List<TariffTreeNode> childs = new ArrayList<TariffTreeNode>();
    private JMenuItem delMenuItem;
    private JMenu addSubmenu;
    private JMenuItem editorMenuItem;
    private JMenuItem moveUpMenuItem;
    private JMenuItem moveDownMenuItem;
    private JMenuItem moveOnPosMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem fixMenuItem;
    private JPanel nodeEditor;
    private JPanel utilsPanel;
    protected JPopupMenu rcMenu;
    private Map<Integer, List<Element>> nodesForLoad;
    private List<Element> childsForLoad;
    private boolean _wasLoad = false;
    private boolean _wasFind = false;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        this.id = id;
        this.mtree_id = mtree;
        this.type = type;
        this.tree = tree;
        this.mtc = config;
        this.parent = parent;
        this.nodesForLoad = childsArray;
        this.viewableNode = new DefaultMutableTreeNode(this);
        if (this.nodesForLoad != null) {
            this.childsForLoad = this.nodesForLoad.remove(id);
        }
        if (this.childsForLoad != null) {
            this.viewableNode.add(new DefaultMutableTreeNode(""));
        }
        this.utilsPanel = this.getUtilsPanel();
    }

    private void initNodeEditor() {
        try {
            this.nodeEditor = new JPanel(new GridBagLayout());
            this.nodeEditor.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
            JPanel childEdit = this.getEditorPanel();
            this.nodeEditor.add((Component)childEdit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            JButton okBut = new JButton();
            okBut.setMargin(new Insets(2, 2, 2, 2));
            okBut.setIcon(okIcon);
            okBut.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            okBut.addActionListener(e -> this.editOk());
            JButton cancelBut = new JButton();
            cancelBut.setIcon(cancelIcon);
            cancelBut.setMargin(new Insets(2, 2, 2, 2));
            cancelBut.setToolTipText("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
            cancelBut.addActionListener(e -> this.tree.getViewableTree().stopEditing());
            this.nodeEditor.add((Component)okBut, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 3, 3), 0, 0));
            this.nodeEditor.add((Component)cancelBut, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 3, 3), 0, 0));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public JPopupMenu getRightClickMenu() {
        if (this.rcMenu == null) {
            this.initRightClickMenu();
        }
        this.updateCutCopyPasteItems();
        this.fixMenuItem.setEnabled(this.check == 0);
        return this.rcMenu;
    }

    protected void initRightClickMenu() {
        this.rcMenu = new JPopupMenu();
        this.addSubmenu = this.createAddSubmenu();
        if (this.addSubmenu != null) {
            this.tree.getViewableTree().expandPath(this.tree.getViewableTree().getSelectionPath());
            this.rcMenu.add(this.addSubmenu);
        }
        this.createDelCopyCutPasteMenuItems();
        if (this.editable) {
            if (this.addSubmenu != null) {
                this.rcMenu.addSeparator();
            }
            this.createEditMenuItem();
            this.rcMenu.add(this.editorMenuItem);
            this.rcMenu.addSeparator();
            this.createMoveUpMenuItem();
            this.rcMenu.add(this.moveUpMenuItem);
            this.createMoveDownMenuItem();
            this.rcMenu.add(this.moveDownMenuItem);
            this.createMoveOnPosMenuItem();
            this.rcMenu.add(this.moveOnPosMenuItem);
            this.rcMenu.addSeparator();
            this.rcMenu.add(this.delMenuItem);
            this.rcMenu.addSeparator();
            this.rcMenu.add(this.cutMenuItem);
            this.rcMenu.add(this.copyMenuItem);
            this.rcMenu.add(this.pasteMenuItem);
        }
        if (this.editable || this.addSubmenu != null) {
            this.rcMenu.addSeparator();
        }
        if (!this.editable) {
            this.rcMenu.add(this.pasteMenuItem);
            this.rcMenu.addSeparator();
        }
        this.createFixMenuItem();
        this.rcMenu.add(this.fixMenuItem);
        this.createAdditionalMenus();
    }

    private void createMoveUpMenuItem() {
        this.moveUpMenuItem = new JMenuItem("\u0414\u0432\u0438\u043d\u0443\u0442\u044c \u0432\u0432\u0435\u0440\u0445");
        this.moveUpMenuItem.addActionListener(e -> this.moveUpAction());
    }

    private void createMoveDownMenuItem() {
        this.moveDownMenuItem = new JMenuItem("\u0414\u0432\u0438\u043d\u0443\u0442\u044c \u0432\u043d\u0438\u0437");
        this.moveDownMenuItem.addActionListener(e -> this.moveDownAction());
    }

    private void createMoveOnPosMenuItem() {
        this.moveOnPosMenuItem = new JMenuItem("\u0414\u0432\u0438\u043d\u0443\u0442\u044c \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u044e");
        this.moveOnPosMenuItem.addActionListener(e -> this.moveOnPosAction());
    }

    private void createEditMenuItem() {
        this.editorMenuItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.editorMenuItem.addActionListener(e -> this.editAction());
    }

    private void createDelCopyCutPasteMenuItems() {
        this.delMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.delMenuItem.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0437\u0435\u043b?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.deleteAction();
            }
        });
        this.cutMenuItem = new JMenuItem("\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c");
        this.cutMenuItem.addActionListener(e -> this.cutAction());
        this.copyMenuItem = new JMenuItem("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.copyMenuItem.addActionListener(e -> this.copyAction());
        this.pasteMenuItem = new JMenuItem("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
        this.pasteMenuItem.addActionListener(e -> this.pasteAction());
    }

    private JMenu createAddSubmenu() {
        this.addSubmenu = new JMenu("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        Map<String, String> avaliableChilds = this.mtc.getType_TitleChilds(this.type);
        Iterator<Map.Entry<String, String>> iter = avaliableChilds.entrySet().iterator();
        if (!iter.hasNext()) {
            this.addSubmenu = null;
        } else {
            while (iter.hasNext()) {
                Map.Entry<String, String> me = iter.next();
                String type = me.getKey();
                String title = me.getValue();
                JMenuItem item = new JMenuItem(title);
                this.addSubmenu.add(item);
                item.setActionCommand(type);
                item.addActionListener(e -> this.addChildAction(e));
            }
        }
        return this.addSubmenu;
    }

    private void createFixMenuItem() {
        this.fixMenuItem = new JMenuItem("\u0418\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438");
        this.fixMenuItem.addActionListener(e -> {
            this.fixNode();
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "<html><table width=250>\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0443\u0437\u043b\u043e\u0432 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d. \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0443\u0437\u0435\u043b, \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c \u0447\u0442\u043e \u0443\u0437\u043b\u044b \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u044b \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u043c \u043f\u043e\u0440\u044f\u0434\u043a\u0435, \u0438\u043d\u0430\u0447\u0435 \u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u044c\u0442\u0435 \u0438\u0445 \u0432\u0440\u0443\u0447\u043d\u0443\u044e.", "\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435", 1);
        });
    }

    private void createAdditionalMenus() {
        TariffNodeMenuItem[] items = this.mtc.getMenuItems(this.type);
        if (items != null) {
            this.rcMenu.addSeparator();
            for (int i = 0; i < items.length; ++i) {
                TariffNodeMenuItem item = items[i];
                JMenuItem menuItem = new JMenuItem(item.getTitle());
                menuItem.addActionListener(e -> {
                    item.init(this);
                    JDialog dialog = item.getDialog();
                    dialog.setVisible(true);
                    this.tree.updateTree();
                });
                this.rcMenu.add(menuItem);
            }
        }
    }

    private void updateCutCopyPasteItems() {
        boolean copy_cut = this.parent != null && this.editable;
        this.copyMenuItem.setEnabled(copy_cut);
        this.cutMenuItem.setEnabled(copy_cut);
        this.pasteMenuItem.setEnabled(this.tree.canPaste(this.mtree_id, this));
    }

    @Override
    public void loadChilds() {
        if (!this._wasLoad) {
            this._wasLoad = true;
            ArrayList<TariffTreeNode> childsToAdd = new ArrayList<TariffTreeNode>();
            if (this.childsForLoad != null) {
                int size = this.childsForLoad.size();
                Element el = null;
                String type = null;
                String data = null;
                int id = 0;
                boolean editable = false;
                TariffTreeNode newChild = null;
                for (int i = 0; i < size; ++i) {
                    el = this.childsForLoad.get(i);
                    id = Integer.parseInt(el.getAttribute("id"));
                    newChild = this.createChild(id, type = el.getAttribute("type"), data = el.getAttribute("data"), editable = el.getAttribute("editable").equals("true"));
                    if (newChild == null) continue;
                    childsToAdd.add(newChild);
                }
            }
            TariffTreeNode ttn = null;
            int size = childsToAdd.size();
            if (size > 0) {
                if (this.mtc.childsSortNeed(this.type)) {
                    Collections.sort(childsToAdd);
                }
                for (int i = 0; i < size; ++i) {
                    ttn = (TariffTreeNode)childsToAdd.get(i);
                    this.addChild(ttn);
                }
            }
            this.nodesForLoad = null;
            this.childsForLoad = null;
            if (size > 0) {
                this.viewableNode.remove(0);
            }
        }
    }

    @Override
    public void loadAllDescendant() {
        this.loadAllDescendant(this);
    }

    private void loadAllDescendant(TariffTreeNode context) {
        context.loadChilds();
        List<TariffTreeNode> childs = context.getChilds();
        for (TariffTreeNode node : childs) {
            this.loadAllDescendant(node);
        }
    }

    private void copyAction() {
        this.tree.copyNode(this.mtree_id, this);
    }

    private void cutAction() {
        this.tree.cutNode(this.mtree_id, this);
    }

    private void pasteAction() {
        this.tree.pasteNode(this.mtree_id, this);
    }

    @Override
    public void deleteAction() {
        this.tree.deleteNode(this.id);
        this.parent.getChilds().remove(this);
        this.viewableNode.removeFromParent();
        this.markNeedFlush(this.parent);
        this.tree.updateTree();
    }

    private void addChildAction(ActionEvent e) {
        String addType = e.getActionCommand();
        int id = this.tree.createNode(this.mtree_id, addType, this.getId());
        TariffTreeNode child = this.createChild(id, addType, "", true);
        this.addChild(child);
        this.markNeedFlush(this);
        this.tree.updateTree();
    }

    protected void editAction() {
        try {
            if (this.nodeEditor == null) {
                this.initNodeEditor();
            }
            this.loadData();
            this.tree.getViewableTree().startEditingAtPath(this.tree.getViewableTree().getSelectionPath());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void moveUpAction() {
        try {
            List<TariffTreeNode> brothers = this.parent.getChilds();
            int thisPos = this.getNodePos(this);
            if (thisPos > 0) {
                this.exchangeByNode(brothers.get(thisPos - 1));
            }
            this.markNeedFlush(this);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void moveDownAction() {
        try {
            List<TariffTreeNode> brothers = this.parent.getChilds();
            int size = brothers.size();
            int thisPos = this.getNodePos(this);
            if (thisPos >= 0 && thisPos < size - 1) {
                this.exchangeByNode(brothers.get(thisPos + 1));
            }
            this.markNeedFlush(this);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void moveOnPosAction() {
        block6: {
            String newPos = null;
            List<TariffTreeNode> brothers = this.parent.getChilds();
            int size = brothers.size();
            newPos = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u0432\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u0443\u0437\u043b\u0430", "\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0443\u0437\u043b\u0430", 2);
            if (newPos == null) break block6;
            int pos = Utils.parseInt(newPos, 0);
            if (pos <= 0 || pos > size) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430!");
            } else {
                int needPos = pos - 1;
                int currentPos = this.getNodePos(this);
                if (needPos > currentPos) {
                    for (int i = 0; i < needPos - currentPos; ++i) {
                        this.moveDownAction();
                    }
                } else {
                    for (int i = 0; i < currentPos - needPos; ++i) {
                        this.moveUpAction();
                    }
                }
            }
        }
    }

    private TariffTreeNode createChild(int id, String type, String data, boolean editable) {
        TariffTreeNode newChild = this.mtc.createNodeByType(type);
        if (newChild != null) {
            newChild.setDirManager(this.dirManager);
            newChild.init(id, this.mtree_id, type, this.tree, this.mtc, this, this.nodesForLoad);
            newChild.setEditable(editable);
            newChild.setData(data);
        }
        return newChild;
    }

    @Override
    public void addChild(TariffTreeNode newChild) {
        this.childs.add(newChild);
        this.viewableNode.add(newChild.getViewableTreeNode());
    }

    @Override
    public void removeChild(TariffTreeNode newChild) {
        this.childs.remove(newChild);
        this.viewableNode.remove(newChild.getViewableTreeNode());
    }

    private void markNeedFlush(TariffTreeNode node) {
        if (node instanceof FlushableRootTariffTreeNode) {
            ((FlushableRootTariffTreeNode)node).markNeedFlush();
        }
        if ((node = node.getParent()) != null) {
            this.markNeedFlush(node);
        }
    }

    private int getNodePos(TariffTreeNode node) {
        int pos = -1;
        List<TariffTreeNode> brothers = this.parent.getChilds();
        int size = brothers.size();
        for (int i = 0; i < size; ++i) {
            if (brothers.get(i) != node) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private void exchangeByNode(TariffTreeNode node) throws Exception {
        int code1 = this.id;
        int code2 = node.getId();
        if (!this.tree.checkForSwap(code1, code2)) {
            return;
        }
        DefaultMutableTreeNode viewParent = (DefaultMutableTreeNode)this.parent.getViewableTreeNode();
        int thisPos = this.getNodePos(this);
        int opponentPos = this.getNodePos(node);
        if (opponentPos > thisPos) {
            viewParent.remove(thisPos);
            viewParent.insert(this.getViewableTreeNode(), opponentPos);
        } else {
            viewParent.remove(opponentPos);
            viewParent.insert(node.getViewableTreeNode(), thisPos);
        }
        List<TariffTreeNode> brothers = this.parent.getChilds();
        brothers.set(thisPos, node);
        brothers.set(opponentPos, this);
        this.tree.changePos(code1, code2);
        this.tree.updateTree();
        this.markNeedFlush(this);
    }

    @Override
    public void changeParent(TariffTreeNode parent) {
        TariffTreeNode oldParent = this.parent;
        this.parent = parent;
        oldParent.removeChild(this);
        ((DefaultMutableTreeNode)parent.getViewableTreeNode()).add(this.viewableNode);
        this.markNeedFlush(parent);
    }

    protected Map<String, String> getDataInHash() {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer pairsSt = new StringTokenizer(this.data, "%");
        while (pairsSt.hasMoreTokens()) {
            String pair = pairsSt.nextToken();
            StringTokenizer key_value = new StringTokenizer(pair, "&");
            if (key_value.countTokens() != 2) continue;
            String key = key_value.nextToken();
            String value = key_value.nextToken();
            result.put(key, value);
        }
        return result;
    }

    protected void setDataInHash(Map<String, ?> data) {
        StringBuilder sb = new StringBuilder();
        for (String key : data.keySet()) {
            if (sb.length() != 0) {
                sb.append("%");
            }
            sb.append(key);
            sb.append("&");
            sb.append(data.get(key));
        }
        this.data = sb.toString();
    }

    protected void saveData() {
        this.tree.updateNode(this.id, this.data);
        this.tree.updateTree();
        this.markNeedFlush(this);
    }

    @Override
    public Component getUtils() {
        return this.utilsPanel;
    }

    @Override
    public Component getEditor() throws Exception {
        this.loadData();
        return this.nodeEditor;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getMTreeId() {
        return this.mtree_id;
    }

    @Override
    public ModuleTariffConfig getModuleTreeConfig() {
        return this.mtc;
    }

    @Override
    public void setFind(boolean value) {
        this._wasFind = value;
    }

    @Override
    public boolean wasFind() {
        return this._wasFind;
    }

    @Override
    public MutableTreeNode getViewableTreeNode() {
        return this.viewableNode;
    }

    @Override
    public TariffTreeNode getParent() {
        return this.parent;
    }

    @Override
    public List<TariffTreeNode> getChilds() {
        return this.childs;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    protected String getData() {
        return this.data;
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
    }

    @Override
    public void setDirManager(DirectoriesManager value) {
        this.dirManager = value;
    }

    protected DirectoriesManager getDirManager() {
        return this.dirManager;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    protected JPanel getUtilsPanel() {
        return new JPanel();
    }

    protected abstract JPanel getEditorPanel() throws Exception;

    protected void loadData() throws Exception {
    }

    protected void serializeData() {
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
    }

    protected void serializeHashToXML(Element el) {
        for (Map.Entry<String, String> me : this.getDataInHash().entrySet()) {
            el.setAttribute(me.getKey(), me.getValue());
        }
    }

    protected void loadHashFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>();
        NamedNodeMap nnm = el.getAttributes();
        int size = nnm.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nnm.item(i);
            data.put(node.getNodeName(), node.getNodeValue());
        }
        this.setDataInHash(data);
        this.saveData();
    }

    @Override
    public void serializeChildsToXML(Element el) throws Exception {
        this.loadChilds();
        TariffTreeNode node = null;
        Element nodeEl = null;
        int size = this.childs.size();
        for (int i = 0; i < size; ++i) {
            node = this.childs.get(i);
            nodeEl = el.getOwnerDocument().createElement(node.getType());
            node.serializeToXML(nodeEl);
            el.appendChild(nodeEl);
        }
    }

    @Override
    public void loadChildsFromXML(Element el) throws Exception {
        Node node = null;
        Element childEl = null;
        String type = null;
        int childId = 0;
        TariffTreeNode childNode = null;
        NodeList childsNodes = el.getChildNodes();
        int size = childsNodes.getLength();
        for (int i = 0; i < size; ++i) {
            node = childsNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childEl = (Element)node;
            type = childEl.getNodeName();
            childId = this.tree.createNode(this.mtree_id, type, this.getId());
            childNode = this.createChild(childId, type, "", true);
            childNode.loadFromXML(childEl);
            this.addChild(childNode);
        }
    }

    @Override
    public TariffTreeNode clone(TariffTreeNode newParent) {
        TariffTreeNode result = null;
        int cloneID = this.tree.createNode(this.mtree_id, this.type, newParent.getId());
        if (cloneID > 0) {
            result = this.createChild(cloneID, this.type, this.data, true);
            for (TariffTreeNode child : this.childs) {
                child.clone(result);
            }
            this.tree.updateNode(cloneID, this.data);
            newParent.addChild(result);
        }
        this.markNeedFlush(result);
        return result;
    }

    protected String getUnitName(int type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "\u0431\u0430\u0439\u0442";
                break;
            }
            case 1: {
                result = "KB";
                break;
            }
            case 2: {
                result = "MB";
                break;
            }
            case 3: {
                result = "GB";
                break;
            }
            case 4: {
                result = "\u0441\u0435\u043a\u0443\u043d\u0434";
                break;
            }
            case 5: {
                result = "\u043c\u0438\u043d\u0443\u0442";
                break;
            }
            case 6: {
                result = "\u0447\u0430\u0441\u043e\u0432";
            }
        }
        return result;
    }

    protected void setDirectoryItemSelection(JComboBox<? extends IdTitle> combo, int id) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            IdTitle di = combo.getItemAt(i);
            if (di == null || di.getId() != id) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    protected int getIdFromDirectoryCombo(JComboBox<? extends IdTitle> combo) {
        int result = -1;
        IdTitle di = (IdTitle)combo.getSelectedItem();
        if (di != null) {
            result = di.getId();
        }
        return result;
    }

    protected JPanel getDirectoryAddPanel(Directory directory, BGComboBox<IdTitle> combo, boolean addNo) {
        JPanel result = new JPanel(new GridBagLayout());
        BGTextField titleField = new BGTextField();
        titleField.setMinimumSize(new Dimension(200, 24));
        titleField.setPreferredSize(new Dimension(200, 24));
        JButton addButton = new JButton("+");
        addButton.setMargin(new Insets(2, 2, 2, 2));
        addButton.setFont(new Font("Arial", 1, 12));
        result.add((Component)titleField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        result.add((Component)addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        ActionListener al = e -> {
            try {
                String title = titleField.getText();
                if (Utils.notBlankString(title) && directory.getCode(title) <= 0) {
                    directory.addValue(title);
                    combo.removeAllItems();
                    this.buildDirectoryCombo(directory, combo);
                    if (addNo) {
                        IdTitle di = new IdTitle();
                        di.setId(0);
                        di.setTitle("-- \u043d\u0435\u0442 --");
                        combo.insertItemAt(di, 0);
                        combo.setSelectedIndex(1);
                    } else {
                        combo.setSelectedIndex(0);
                    }
                    titleField.setText("");
                    combo.updateUI();
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        };
        addButton.addActionListener(al);
        titleField.addActionListener(al);
        return result;
    }

    protected void buildDirectoryCombo(Directory dir, JComboBox<IdTitle> combo) throws Exception {
        combo.addItem(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        if (dir != null) {
            for (IdTitle di : dir.getItems()) {
                combo.addItem(di);
            }
        }
    }

    protected void editOk() {
        try {
            this.serializeData();
            this.saveData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.tree.getViewableTree().stopEditing();
        this.tree.updateTree();
    }

    @Override
    public boolean checkNode() throws Exception {
        if (this.check < 0) {
            this.check = this.tree.checkNode(this.getId(), this.mtree_id) ? 1 : 0;
        }
        return this.check == 1;
    }

    public void fixNode() {
        this.tree.fixNode(this.getId(), this.mtree_id);
        this.check = 1;
    }

    protected void addField(JPanel panel, String labelText, JComponent component) {
        panel.add((Component)new JLabel(labelText), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
    }

    protected int getModuleId(TariffTreeNode parent) {
        TariffTreeNode p = parent.getParent();
        if (p == null) {
            return parent instanceof DefaultRootTariffTreeNode ? ((DefaultRootTariffTreeNode)parent).getModuleId() : 0;
        }
        return this.getModuleId(p);
    }

    protected String getTariffVarValue(TariffVar tariffVar) {
        return tariffVar.getTopId() > 0 && tariffVar.getDefaultValue().isEmpty() ? "<\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u043e\u0434. \u0442\u0430\u0440\u0438\u0444\u0430>" : tariffVar.getDefaultValue();
    }
}

