/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import bitel.billing.module.common.table.BGRadio;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class RadioTableCellRenderer
extends JRadioButton
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public RadioTableCellRenderer() {
        this(2);
    }

    public RadioTableCellRenderer(int horizontalAlignment) {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setSelected(false);
        if (value instanceof BGRadio) {
            this.setText(value.toString());
            this.setSelected(((BGRadio)value).isSelected());
        } else if (value instanceof String) {
            this.setSelected(Boolean.valueOf((String)value));
        } else if (value instanceof Boolean) {
            this.setSelected((Boolean)value);
        }
        return this;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }
}

