/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarValue;
import ru.bitel.bgbilling.kernel.tariff.common.event.TariffVarModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarRuntime;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarValueDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.ThreadContext;

public class TariffVarRuntimeMap
extends BGLogger
implements EventListener<TariffVarModifiedEvent> {
    private volatile Map<Integer, TariffVarRuntime> idMap;
    private static final AtomicReference<TariffVarRuntimeMap> REFERENCE = new AtomicReference();

    public static TariffVarRuntimeMap getInstance() {
        ServerContext context = ThreadContext.get(ServerContext.class);
        TariffVarRuntimeMap result = REFERENCE.get();
        if (result == null) {
            try {
                TariffVarRuntimeMap newResult = new TariffVarRuntimeMap();
                EventProcessor ep = EventProcessor.getInstance();
                ep.addListener(newResult, TariffVarModifiedEvent.class, 0, null);
                newResult.idMap = newResult.load(context.getConnectionSet().getConnection());
                result = REFERENCE.getAndSet(newResult);
                if (result == null) {
                    result = newResult;
                } else {
                    ep.removeListener(newResult);
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
        return result;
    }

    @Override
    public void notify(TariffVarModifiedEvent e, EventListenerContext ctx) throws Exception {
        this.idMap = this.load();
    }

    public Optional<TariffVar> opt(int id, LocalDate date) {
        return Optional.ofNullable(this.get(id, date));
    }

    public TariffVar get(int id, LocalDate date) {
        Objects.requireNonNull(date);
        TariffVarRuntime tariffVarRuntime = this.idMap.get(id);
        if (tariffVarRuntime != null) {
            TariffVar tariffVar = tariffVarRuntime.getTariffVar();
            if (!tariffVarRuntime.getValues().isEmpty()) {
                for (TariffVarValue tariffVarValue : tariffVarRuntime.getValues()) {
                    Period period = tariffVarValue.getPeriod();
                    if (period.getLocalDateFrom() != null && date.isBefore(period.getLocalDateFrom()) || period.getLocalDateTo() != null && date.isAfter(period.getLocalDateTo())) continue;
                    if (tariffVarValue.getValue() == null && tariffVar.getUpId() > 0) {
                        return this.get(tariffVar.getUpId(), date);
                    }
                    return tariffVar.copyTariffVar().setDefaultValue(tariffVarValue.getValue());
                }
                if (tariffVar.getDefaultValue() == null && tariffVar.getUpId() > 0) {
                    return this.get(tariffVar.getUpId(), date);
                }
                return tariffVar.copyTariffVar();
            }
            if (tariffVar.getDefaultValue() == null && tariffVar.getUpId() > 0) {
                return this.get(tariffVar.getUpId(), date);
            }
            return tariffVar.copyTariffVar();
        }
        return null;
    }

    private Map<Integer, TariffVarRuntime> load() throws Exception {
        ServerContext context = ThreadContext.get(ServerContext.class);
        return this.load(context.getConnection());
    }

    private Map<Integer, TariffVarRuntime> load(Connection con) throws Exception {
        this.getLogger().info("Reloading TariffVarRuntimeMap");
        TariffVarDao tariffVarDao = new TariffVarDao(con);
        Map idMap = tariffVarDao.list().stream().map(a -> new TariffVarRuntime().setTariffVar((TariffVar)a)).collect(Collectors.toMap(a -> a.getTariffVar().getId(), Function.identity()));
        int tariffVarId = 0;
        TariffVarRuntime tariffVarRuntime = null;
        TariffVarValueDao tariffVarValueDao = new TariffVarValueDao(con);
        for (TariffVarValue tariffVarValue : tariffVarValueDao.list()) {
            if (tariffVarValue.getTariffVarId() != tariffVarId) {
                tariffVarId = tariffVarValue.getTariffVarId();
                tariffVarRuntime = (TariffVarRuntime)idMap.get(tariffVarId);
            }
            if (tariffVarRuntime == null) continue;
            tariffVarRuntime.getValues().add(tariffVarValue);
        }
        return Collections.unmodifiableMap(idMap);
    }
}

