/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.resource;

import bitel.billing.server.ActionConType;
import jakarta.annotation.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceAdapter;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class JDBCResourceAdapter
implements ResourceAdapter<Connection> {
    private static final Logger logger = LogManager.getLogger();
    private final Context context;

    public JDBCResourceAdapter(Context context) {
        this.context = context;
    }

    @Override
    public Connection borrow(ContainerContext ctx, int moduleId, Resource resource, Class<?> clazz, Class<?> resourceClazz, Class<?> fieldClass, Object bean) {
        Connection con;
        if (resource == null || "".equals(resource.name())) {
            ActionConType type = clazz.getAnnotation(ActionConType.class);
            con = type == null || type.value() == 1 ? ctx.getConnectionSet().getConnection() : (type != null && type.value() == 2 ? ctx.getConnectionSet().getSlaveConnection() : ctx.getConnectionSet().getConnection());
        } else {
            Connection c;
            try {
                DataSource ds;
                try {
                    ds = (DataSource)this.context.lookup(resource.name());
                }
                catch (NamingException e) {
                    ds = (DataSource)ctx.getEnvironment().lookup(resource.name());
                }
                c = ds.getConnection();
            }
            catch (SQLException e) {
                c = null;
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                c = null;
                logger.error(e.getMessage(), (Throwable)e);
            }
            con = c;
        }
        return con;
    }

    @Override
    public void commit(Connection r) {
        try {
            if (!r.getAutoCommit()) {
                r.commit();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void recycle(Connection r) {
        ServerUtils.closeConnection((Connection)r);
    }
}

