/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceEditor;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ContractSubPanel_Module
extends ContractSubPanel {
    private static final String COL_COMMENT = "f3";
    private static final String COL_SERVICE_ID = "f4";
    private static final String COL_DATE = "f2";
    private String packageClient;
    private Map<String, ServicePanel> servicePanels = new HashMap<String, ServicePanel>();
    private JTabbedPane mainTabbedPane = new JTabbedPane();
    private CardLayout cardLayoutModulePanel = new CardLayout();
    private BGDialogToolBar moduleToolBar = new BGDialogToolBar();
    private BGTable servicesTable = new BGTable();
    private JPanel moduleConfigContainer = new JPanel();
    private ServiceEditor serviceEditor = new ServiceEditor();
    private ServicePanel panel = null;
    private JPanel moduleTab = new JPanel(new GridBagLayout());
    private JPanel serviceListTab = new JPanel(new GridBagLayout());

    public ContractSubPanel_Module() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.servicesTable.setHeader(this.rb_name, this.moduleDoc, "services");
        this.servicesTable.setSelectionMode(0);
        this.servicesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContractSubPanel_Module.this.table_mouseClicked(e);
            }
        });
    }

    private void jbInit() throws Exception {
        this.moduleToolBar.setOrientation(0);
        this.moduleToolBar.setMargin(new Insets(5, 5, 5, 5));
        this.moduleToolBar.setBorderPainted(false);
        this.moduleToolBar.setFloatable(false);
        this.moduleToolBar.setActionListener(new PropertyToolBarActionListener());
        this.moduleConfigContainer.setLayout(this.cardLayoutModulePanel);
        this.panel = new ServicePanel();
        this.panel.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.servicePanels.put("0", this.panel);
        this.moduleConfigContainer.setLayout(this.cardLayoutModulePanel);
        this.moduleConfigContainer.add((Component)this.panel, "0");
        this.serviceEditor.addPropertyChangeListener(evt -> {
            if ("closeEditor".equals(evt.getPropertyName())) {
                this.setData();
            }
        });
        this.serviceListTab.add((Component)new JScrollPane(this.servicesTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.serviceListTab.add((Component)this.serviceEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.7, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.moduleTab.add((Component)this.moduleToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.moduleTab.add((Component)this.moduleConfigContainer, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.moduleTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(String module, int mid, String packageClient) {
        super.init(module, mid);
        this.packageClient = packageClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData() {
        if (this.packageClient != null) {
            try {
                String className = this.packageClient + ".ServicePropertiesPanel";
                this.panel = this.servicePanels.get(className);
                if (this.panel == null) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        this.module = ClientUtils.getValueFromResourceBundle(clazz.getPackage().getName() + ".setup", "module.id", this.module);
                        ClientContext context = new ClientContext(this.module, this.getModuleId(), this.getContractId(), this.rb_name);
                        ClientContext.push(context);
                        try {
                            this.panel = (ServicePanel)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            this.panel.init(this.getContractId(), this.getModuleId(), 0);
                            this.moduleConfigContainer.add(className, this.panel);
                            this.cardLayoutModulePanel.show(this.moduleConfigContainer, className);
                            this.servicePanels.put(className, this.panel);
                            this.panel.trySetData();
                        }
                        finally {
                            ClientContext.pop();
                        }
                    }
                    catch (Exception ex) {
                        this.panel = this.servicePanels.get("0");
                        this.cardLayoutModulePanel.show(this.moduleConfigContainer, "0");
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                } else {
                    this.cardLayoutModulePanel.show(this.moduleConfigContainer, className);
                    this.panel.trySetData();
                }
                if (this.panel != null) {
                    if (!this.panel.isAllowedServiceAvaliable()) {
                        this.removeAll();
                        this.add((Component)this.moduleTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    } else {
                        Request request;
                        Document doc;
                        boolean isSecondTabVisible = this.serviceListTab.isShowing();
                        this.removeAll();
                        this.add((Component)this.mainTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                        this.mainTabbedPane.addTab("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", this.moduleTab);
                        this.mainTabbedPane.addTab("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", this.serviceListTab);
                        if (isSecondTabVisible) {
                            this.mainTabbedPane.setSelectedIndex(1);
                        }
                        if (ClientUtils.checkStatus(doc = this.getDocument(request = new Request().setModule("contract").setAction("ContractServices").setContractId(this.getContractId()).setModuleId(this.getModuleId())))) {
                            this.setDocument(doc);
                        }
                        this.servicesTable.updateData(XMLUtils.selectNode(doc, "//table"));
                    }
                }
                if (this.panel != null) {
                    this.panel.initModuleToollBar(this.moduleToolBar);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            this.cardLayoutModulePanel.show(this.moduleConfigContainer, "0");
        }
    }

    private void table_mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.editItem();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.moduleTab.isShowing()) {
            this.panel.actionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void newItem() {
        if (this.moduleTab.isShowing()) {
            this.panel.newItem();
        } else {
            this.serviceEditor.setId(0);
            this.serviceEditor.init(this.serviceEditor.getModule(), this.getModuleId());
            this.serviceEditor.setContractId(this.getContractId());
            this.serviceEditor.trySetData();
            this.serviceEditor.setServicesBoxEnable(true);
            this.serviceEditor.setVisible(true);
        }
    }

    @Override
    public void editItem() {
        if (this.moduleTab.isShowing()) {
            this.panel.editItem();
        } else {
            int id = Utils.parseInt(ClientUtils.getRowId(this.servicesTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null));
            if (id != 0) {
                this.serviceEditor.setId(id);
                this.serviceEditor.init(this.serviceEditor.getModule(), this.getModuleId());
                this.serviceEditor.setContractId(this.getContractId());
                this.serviceEditor.trySetData();
                this.serviceEditor.setServicesBoxEnable(false);
                int row = this.servicesTable.getSelectedRow();
                String comment = this.servicesTable.getRowId(row, COL_COMMENT);
                String serviceId = this.servicesTable.getRowId(row, COL_SERVICE_ID);
                String date = this.servicesTable.getRowId(row, COL_DATE);
                this.serviceEditor.setEditData(serviceId, comment, date);
                this.serviceEditor.setVisible(true);
            }
        }
    }

    @Override
    public void deleteItem() {
        if (this.moduleTab.isShowing()) {
            this.panel.deleteItem();
        } else {
            String id = ClientUtils.getRowId(this.servicesTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
            if (id == null) {
                return;
            }
            String title = this.servicesTable.getColumnValueString(this.servicesTable.getSelectedRow(), "service");
            if (title == null) {
                title = this.servicesTable.getColumnValueString(this.servicesTable.getSelectedRow(), "1");
            }
            if (ClientUtils.confirmDelete(title)) {
                Request request = new Request().setModule("contract").setAction("DeleteContractService").setAttribute("id", id);
                ClientUtils.checkStatus(TransferManager.getDocument(request));
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            this.setData();
        }
    }

    class PropertyToolBarActionListener
    implements ActionListener {
        PropertyToolBarActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < ContractSubPanel_Module.this.moduleConfigContainer.getComponentCount(); ++i) {
                ServicePanel panel = (ServicePanel)ContractSubPanel_Module.this.moduleConfigContainer.getComponent(i);
                if (!panel.isVisible()) continue;
                panel.actionPerformed(e);
                break;
            }
        }
    }
}

