/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=HouseModifiedEvent.class, serviceClass=AddressService.class)
public class House
extends Id {
    private IdTitle country;
    private IdTitle city;
    private IdTitle street;
    private IdTitle area;
    private IdTitle quarter;
    private int house;
    private String frac;
    private String comment;
    private String postIndex;
    private int amount;
    private int podCount = 1;
    private Map<String, String> params;

    @XmlAttribute
    public int getAmount() {
        return this.amount;
    }

    @XmlElement
    public IdTitle getArea() {
        return this.area;
    }

    @XmlElement
    public IdTitle getCity() {
        return this.city;
    }

    public String getComment() {
        return this.comment;
    }

    @XmlElement
    public IdTitle getCountry() {
        return this.country;
    }

    @XmlAttribute
    public String getFrac() {
        return this.frac;
    }

    @XmlAttribute
    public int getHouse() {
        return this.house;
    }

    @XmlAttribute
    public String getHouseFrac() {
        StringBuilder buf = new StringBuilder();
        if (this.house > 0) {
            buf.append(this.house);
        }
        if (this.frac != null && !this.frac.isEmpty()) {
            if (Character.isDigit(this.frac.charAt(0))) {
                buf.append('/');
            }
            buf.append(this.frac);
        }
        return buf.toString();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public int getPodCount() {
        return this.podCount;
    }

    @XmlAttribute
    public String getPostIndex() {
        return this.postIndex;
    }

    @XmlElement
    public IdTitle getQuarter() {
        return this.quarter;
    }

    @XmlElement
    public IdTitle getStreet() {
        return this.street;
    }

    public Optional<IdTitle> optArea() {
        return Optional.ofNullable(this.area);
    }

    public Optional<IdTitle> optCity() {
        return Optional.ofNullable(this.city);
    }

    public Optional<IdTitle> optCountry() {
        return Optional.ofNullable(this.country);
    }

    public Optional<IdTitle> optQuarter() {
        return Optional.ofNullable(this.quarter);
    }

    public Optional<IdTitle> optStreet() {
        return Optional.ofNullable(this.street);
    }

    public House setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public House setArea(IdTitle area) {
        this.area = area;
        return this;
    }

    public House setAreaId(int id) {
        (this.area != null ? this.area : (this.area = new IdTitle())).setId(id);
        return this;
    }

    public House setCity(IdTitle city) {
        this.city = city;
        return this;
    }

    public House setCityId(int id) {
        (this.city != null ? this.city : (this.city = new IdTitle())).setId(id);
        return this;
    }

    public House setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public House setCountry(IdTitle country) {
        this.country = country;
        return this;
    }

    public House setFrac(String frac) {
        this.frac = frac;
        return this;
    }

    public House setHouse(int house) {
        this.house = house;
        return this;
    }

    public House setHouseAndFrac(String houseAndFrac) {
        this.frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                this.frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        this.house = Utils.parseInt(str.toString(), 0);
        return this;
    }

    @Override
    public House setId(int id) {
        super.setId(id);
        return this;
    }

    public House setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public House setPodCount(int podCount) {
        this.podCount = podCount;
        return this;
    }

    public House setPostIndex(String postIndex) {
        this.postIndex = postIndex;
        return this;
    }

    public House setQuarter(IdTitle quarter) {
        this.quarter = quarter;
        return this;
    }

    public House setQuarterId(int id) {
        (this.quarter != null ? this.quarter : (this.quarter = new IdTitle())).setId(id);
        return this;
    }

    public House setStreet(IdTitle street) {
        this.street = street;
        return this;
    }

    public House setStreetId(int id) {
        (this.street != null ? this.street : (this.street = new IdTitle())).setId(id);
        return this;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id=").append(this.getId());
        buf.append("; areaId=").append(this.area != null ? this.area.getId() : 0);
        buf.append("; streetId=").append(this.street != null ? this.street.getId() : 0);
        buf.append("; quarterId=").append(this.quarter != null ? this.quarter.getId() : 0);
        buf.append("; house=").append(this.house);
        buf.append("; frac=").append(this.frac);
        buf.append("; postIndex=").append(this.postIndex);
        buf.append("; amount=").append(this.amount);
        buf.append("; comment=").append(this.comment);
        return buf.toString();
    }

    public static House from(House house) {
        return new House().setId(house.getId()).setHouse(house.getHouse()).setFrac(house.getFrac()).setComment(house.getComment()).setPostIndex(house.getPostIndex()).setAmount(house.getAmount()).setCountry(house.getCountry().toIdTitle()).setCity(house.getCity().toIdTitle()).setStreet(house.getStreet().toIdTitle()).setArea(house.getArea().toIdTitle()).setQuarter(house.getQuarter().toIdTitle());
    }

    public static Object[] getHouseAndFrac(String houseAndFrac) {
        String frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        return new Object[]{Utils.parseInt(str.toString(), 0), frac};
    }
}

