/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Optional;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public class ActionFindContract
extends ActionBase {
    private Page page = null;
    private int records = 0;
    private String filter = "";
    private String parameters = null;
    private boolean showClosed = true;

    @Override
    public void doAction() throws Exception {
        int del = this.getIntParameter("del", -1);
        int fc = this.getIntParameter("fc", -1);
        boolean showSub = this.getIntParameter("show_sub", 1) > 0;
        this.showClosed = this.getIntParameter("show_closed", 1) > 0;
        String type = this.getParameter("type", null);
        this.filter = del == 0 ? " AND del=0 " : "";
        this.filter = this.filter + (String)(fc > -1 ? " AND fc=" + fc + " " : "");
        if (!showSub) {
            this.filter = this.filter + " AND scid IN ( 0, -1 ) ";
        }
        if (!this.showClosed) {
            this.filter = type.startsWith("c") ? this.filter + " AND (contract.date2 IS NULL OR ?<=contract.date2 ) " : this.filter + " AND (object.date2 IS NULL OR ?<=object.date2 ) ";
        }
        this.page = this.getPage();
        this.parameters = this.getParameter("parameters");
        Element contracts = this.createElement(this.rootNode, "contracts");
        int typeId = Utils.parseInt((String)type.substring(1));
        if (type.startsWith("c")) {
            if (typeId == 1) {
                this.selectForType1(contracts);
            } else if (typeId == 8) {
                this.selectForType2(contracts);
            } else if (typeId == 3) {
                this.selectForType3(contracts);
            } else if (typeId == 6) {
                this.selectForType6(contracts);
            } else if (typeId == 7) {
                this.selectForType7(contracts);
            } else if (typeId == 10) {
                this.selectForTypePhone(contracts);
            }
        } else if (type.startsWith("o")) {
            if (typeId == 1) {
                this.selectForTypeText(contracts);
            } else if (typeId == 2) {
                this.selectForTypeList(contracts);
            } else if (typeId == 3) {
                this.selectForTypeDate(contracts);
            } else if (typeId == 4) {
                this.selectForTypeAddress(contracts);
            } else if (typeId == 5) {
                this.selectForTypeId(contracts);
            }
        }
        if (this.page.getPageSize() > 0) {
            this.page.setRecordCount(this.records);
            this.setPageAttribute(contracts, this.page);
        }
        contracts.setAttribute("allRecord", String.valueOf(this.records));
    }

    private void selectForType1(Element contracts) throws SQLException {
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        String parameter = this.getParameter("parameter");
        if (parameter == null || parameter.trim().length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(150);
        StringBuilder count = new StringBuilder(150);
        StringBuilder where = new StringBuilder(100);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ]' ) ");
        sb.append("FROM contract LEFT JOIN contract_parameter_type_1 AS t2 ON contract.id=t2.cid ");
        count.append("SELECT count(DISTINCT contract.id) FROM contract LEFT JOIN contract_parameter_type_1 AS t2 ON contract.id=t2.cid ");
        where.append("WHERE t2.pid in ( ");
        where.append(this.parameters);
        where.append(") ");
        where.append(this.filter);
        where.append("AND UPPER(t2.val) REGEXP ?");
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        PreparedStatement ps = this.con.prepareStatement(sb.toString());
        int index = 1;
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        ps.setString(index++, parameter.toUpperCase());
        this.executeQuery1(contracts, ps);
        ps.close();
        ps = this.con.prepareStatement(count.toString());
        index = 1;
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        ps.setString(index++, parameter.toUpperCase());
        this.executeQuery2(ps);
        ps.close();
    }

    private void selectForType2(Element contracts) throws SQLException {
        int city = this.getIntParameter("city", 0);
        int street = this.getIntParameter("street", 0);
        int house = this.getIntParameter("house", -1);
        int houseId = this.getIntParameter("houseId", -1);
        String frac = this.getParameter("frac");
        String flat = this.getParameter("flat");
        String room = this.getParameter("room");
        int pod = this.getIntParameter("pod", -1);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT SQL_CALC_FOUND_ROWS DISTINCT contract.id, contract.title, concat( contract.comment, '   [ \u0410\u0414\u0420\u0415\u0421: ', addr.address, ' ]' ) as comment");
        sb.append(" FROM contract_parameter_type_2 AS addr");
        sb.append(" INNER JOIN contract ON contract.id=addr.cid");
        sb.append(this.filter);
        sb.append(" INNER JOIN address_house AS house ON addr.hid=house.id");
        sb.append(" INNER JOIN address_street AS street ON street.id=house.street_id ");
        sb.append(" INNER JOIN address_city AS city ON city.id=street.cityid");
        StringBuilder where = new StringBuilder();
        where.append(" WHERE true");
        if (Utils.notBlankString((String)this.parameters)) {
            where.append(" AND addr.pid in ( ").append(this.parameters).append(") ");
        }
        if (houseId > 0) {
            where.append(" AND addr.hid=").append(houseId);
        } else {
            if (city > 0) {
                where.append(" AND street.cityid=").append(city);
            }
            if (street > 0) {
                where.append(" AND house.street_id=").append(street);
            }
            if (house > 0) {
                where.append(" AND house.house=").append(house);
            }
            where.append(Utils.notEmptyString((String)frac) ? " AND ( house.frac=? OR house.frac=? )" : "");
        }
        where.append(pod >= 0 ? "AND addr.pod=? " : "");
        where.append(Utils.notEmptyString((String)flat) ? " AND addr.flat REGEXP ?" : "");
        where.append(Utils.notBlankString((String)room) ? " AND addr.room REGEXP ?" : "");
        this.addUserPermission(sb, null, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY city.title, street.title, house.house, house.frac, addr.flat, addr.room, contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString(), 1);){
            int index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            if (houseId < 1 && Utils.notEmptyString((String)frac)) {
                ps.setString(index++, frac);
                String frac1 = frac;
                if (frac.length() > 0 && frac.startsWith("/")) {
                    frac1 = frac.substring(1);
                }
                ps.setString(index++, frac1);
            }
            if (pod >= 0) {
                ps.setInt(index++, pod);
            }
            if (Utils.notEmptyString((String)flat)) {
                ps.setString(index++, "^[^[:digit:]]*" + flat + "[^[:digit:]]*$");
            }
            if (Utils.notBlankString((String)room)) {
                ps.setString(index++, "^[^[:digit:]]*" + room + "[^[:digit:]]*$");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Element element = this.createElement(contracts, "item");
                    element.setAttribute("id", rs.getString(1));
                    element.setAttribute("title", rs.getString(2));
                    element.setAttribute("comment", rs.getString(3));
                }
            }
        }
        this.records = ServerUtils.foundRows(this.con);
    }

    private void selectForType3(Element contracts) throws SQLException {
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        String email = this.getParameter("mail");
        String name = this.getParameter("name");
        if (email != null && email.length() == 0) {
            email = null;
        }
        if (name != null && name.length() == 0) {
            name = null;
        }
        StringBuilder sb = new StringBuilder(150);
        StringBuilder count = new StringBuilder(150);
        StringBuilder where = new StringBuilder(100);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ]' ) ");
        sb.append("FROM contract LEFT JOIN contract_parameter_type_3 AS t2 ON contract.id=t2.cid ");
        count.append("SELECT count(DISTINCT contract.id) FROM contract LEFT JOIN contract_parameter_type_3 AS t2 ON contract.id=t2.cid ");
        where.append("WHERE t2.pid in ( ");
        where.append(this.parameters);
        where.append(") ");
        where.append(this.filter);
        where.append(email != null ? "AND t2.email REGEXP ? " : "");
        where.append(name != null ? "AND t2.name REGEXP ? " : "");
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement(sb.toString());
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        if (email != null) {
            ps.setString(index++, email);
        }
        if (name != null) {
            ps.setString(index++, name);
        }
        this.executeQuery1(contracts, ps);
        ps.close();
        index = 1;
        ps = this.con.prepareStatement(count.toString());
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        if (email != null) {
            ps.setString(index++, email);
        }
        if (name != null) {
            ps.setString(index++, name);
        }
        this.executeQuery2(ps);
        ps.close();
    }

    private void selectForType6(Element contracts) throws SQLException {
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        String parameters = this.getParameter("parameters");
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        StringBuilder sb = new StringBuilder(150);
        StringBuilder count = new StringBuilder(150);
        StringBuilder where = new StringBuilder(100);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ]' ) ");
        sb.append("FROM contract LEFT JOIN contract_parameter_type_6 AS t2 ON contract.id=t2.cid ");
        count.append("SELECT count(DISTINCT contract.id) FROM contract LEFT JOIN contract_parameter_type_6 AS t2 ON contract.id=t2.cid ");
        where.append("WHERE t2.pid in ( ");
        where.append(parameters);
        where.append(") ");
        where.append(this.filter);
        if (date1 != null) {
            where.append(" AND t2.val>=");
            where.append("'");
            where.append(TimeUtils.format((Date)date1, (String)"yyyy-MM-dd"));
            where.append("' ");
        }
        if (date2 != null) {
            where.append(" AND t2.val<=");
            where.append("'");
            where.append(TimeUtils.format((Date)date2, (String)"yyyy-MM-dd"));
            where.append("' ");
        }
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        PreparedStatement ps = this.con.prepareStatement(sb.toString());
        int index = 1;
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        this.executeQuery1(contracts, ps);
        ps.close();
        ps = this.con.prepareStatement(count.toString());
        index = 1;
        if (!this.showClosed) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
        }
        this.executeQuery2(ps);
        ps.close();
    }

    private void selectForType7(Element contracts) throws SQLException {
        int pid = this.getIntParameter("pid", -1);
        String values = this.getParameter("values");
        if (pid > 0 && values != null && values.length() > 0) {
            StringBuilder sb = new StringBuilder(150);
            StringBuilder count = new StringBuilder(150);
            StringBuilder where = new StringBuilder(100);
            sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ]' ) ");
            sb.append(" FROM contract LEFT JOIN contract_parameter_type_7 AS t2 ON contract.id=t2.cid ");
            count.append("SELECT COUNT(DISTINCT contract.id) FROM contract");
            count.append(" LEFT JOIN contract_parameter_type_7 AS t2 ON contract.id=t2.cid ");
            where.append("WHERE t2.val in ( ").append(values).append(") ");
            where.append(this.filter).append(" AND t2.pid=").append(pid);
            this.addUserPermission(sb, count, where);
            sb.append((CharSequence)where);
            sb.append(" ORDER BY contract.title");
            if (this.page.getPageSize() > 0) {
                sb.append(this.page.sqlLimit());
            }
            count.append((CharSequence)where);
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            int index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            this.executeQuery1(contracts, ps);
            ps.close();
            ps = this.con.prepareStatement(count.toString());
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            this.executeQuery2(ps);
            ps.close();
        }
    }

    private void selectForTypePhone(Element contracts) throws SQLException {
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        String phone = this.getParameter("phone");
        if (phone != null && phone.length() == 0) {
            phone = null;
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append("SELECT DISTINCT contract.id, contract.title, concat( contract.comment, '   \u0422\u0415\u041b\u0415\u0424\u041e\u041d: ', t2.phone ) as comment ");
        sb.append("FROM contract LEFT JOIN ").append("contract_parameter_type_phone_item").append(" AS t2 ON contract.id=t2.cid ");
        StringBuilder count = new StringBuilder(150);
        count.append("SELECT count(DISTINCT contract.id) FROM contract LEFT JOIN contract_parameter_type_phone_item AS t2 ON contract.id=t2.cid ");
        StringBuilder where = new StringBuilder(150);
        where.append("WHERE t2.pid in ( ").append(this.parameters).append(") ");
        where.append(this.filter);
        if (phone != null) {
            where.append("AND t2.phone REGEXP ?");
        }
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where).append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        int index = 1;
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            if (phone != null) {
                ps.setString(index++, phone);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Element element = this.createElement(contracts, "item");
                    element.setAttribute("id", rs.getString(1));
                    element.setAttribute("title", rs.getString(2));
                    element.setAttribute("comment", rs.getString(3));
                }
            }
        }
        index = 1;
        ps = this.con.prepareStatement(count.toString());
        try {
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            if (phone != null) {
                ps.setString(index++, phone);
            }
            this.executeQuery2(ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void selectForTypeText(Element contracts) throws SQLException {
        int index;
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        String parameter = this.getParameter("parameter");
        if (parameter == null || parameter.trim().length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(150);
        StringBuilder count = new StringBuilder(150);
        StringBuilder where = new StringBuilder(100);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ] ', object.title ) ");
        sb.append("FROM contract LEFT JOIN object ON contract.id=object.cid");
        sb.append(" LEFT JOIN object_param_value_text AS param_value ON object.id=param_value.object_id ");
        count.append("SELECT COUNT(DISTINCT object.id) FROM contract LEFT JOIN object ON contract.id=object.cid");
        count.append(" LEFT JOIN object_param_value_text AS param_value ON object.id=param_value.object_id ");
        where.append("WHERE param_value.param_id in ( ").append(this.parameters).append(") ");
        where.append(this.filter);
        where.append(" AND UPPER(param_value.value) REGEXP ? ");
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            ps.setString(index++, parameter.toUpperCase());
            this.executeQuery1(contracts, ps);
        }
        ps = this.con.prepareStatement(count.toString());
        try {
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            ps.setString(index++, parameter.toUpperCase());
            this.executeQuery2(ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void selectForTypeList(Element contracts) throws SQLException {
        int pid = this.getIntParameter("pid", -1);
        String values = this.getParameter("values");
        if (pid > 0 && values != null && values.length() > 0) {
            int index;
            StringBuilder sb = new StringBuilder(150);
            StringBuilder count = new StringBuilder(150);
            StringBuilder where = new StringBuilder(100);
            sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ] ', object.title ) ");
            sb.append("FROM contract LEFT JOIN object ON contract.id=object.cid");
            sb.append(" LEFT JOIN object_param_value_list AS param_value ON object.id=param_value.object_id ");
            count.append("SELECT COUNT(DISTINCT object.id) FROM contract LEFT JOIN object ON contract.id=object.cid");
            count.append(" LEFT JOIN object_param_value_list AS param_value ON object.id=param_value.object_id ");
            where.append("WHERE param_value.param_id=? AND param_value.value in ( ").append(values).append(") ");
            where.append(this.filter);
            this.addUserPermission(sb, count, where);
            sb.append((CharSequence)where);
            sb.append(" ORDER BY contract.title");
            if (this.page.getPageSize() > 0) {
                sb.append(this.page.sqlLimit());
            }
            count.append((CharSequence)where);
            try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
                index = 1;
                ps.setInt(index++, pid);
                if (!this.showClosed) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
                }
                this.executeQuery1(contracts, ps);
            }
            ps = this.con.prepareStatement(count.toString());
            try {
                index = 1;
                ps.setInt(index++, pid);
                if (!this.showClosed) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
                }
                this.executeQuery2(ps);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private void selectForTypeDate(Element contracts) throws SQLException {
        int index;
        if (this.parameters == null || this.parameters.trim().length() == 0) {
            return;
        }
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        StringBuilder sb = new StringBuilder(150);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ] ', object.title ) ");
        sb.append("FROM contract LEFT JOIN object ON contract.id=object.cid");
        sb.append(" LEFT JOIN object_param_value_date AS param_value ON object.id=param_value.object_id ");
        StringBuilder count = new StringBuilder(150);
        count.append("SELECT COUNT(DISTINCT object.id) FROM contract LEFT JOIN object ON contract.id=object.cid");
        count.append(" LEFT JOIN object_param_value_date AS param_value ON object.id=param_value.object_id ");
        StringBuilder where = new StringBuilder(100);
        where.append("WHERE param_value.param_id in ( ").append(this.parameters).append(") ");
        where.append(this.filter);
        where.append(" AND (? IS NULL OR TO_DAYS(param_value.value)>=TO_DAYS(?)) AND (? IS NULL OR TO_DAYS(param_value.value)<=TO_DAYS(?)) ");
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
            this.executeQuery1(contracts, ps);
        }
        ps = this.con.prepareStatement(count.toString());
        try {
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
            this.executeQuery2(ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void selectForTypeAddress(Element contracts) throws SQLException {
        int city = this.getIntParameter("city", 0);
        int street = this.getIntParameter("street", 0);
        int house = this.getIntParameter("house", -1);
        int houseId = this.getIntParameter("houseId", -1);
        String frac = this.getParameter("frac");
        String flat = this.getParameter("flat");
        String room = this.getParameter("room");
        int pod = this.getIntParameter("pod", -1);
        StringBuilder sb = new StringBuilder();
        StringBuilder where = new StringBuilder();
        sb.append("SELECT SQL_CALC_FOUND_ROWS DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ] ', object.title )");
        sb.append(" FROM object_param_value_address AS param_value");
        sb.append(" INNER JOIN object ON object.id=param_value.object_id");
        sb.append(" INNER JOIN contract ON contract.id=object.cid");
        sb.append(this.filter);
        sb.append(" LEFT JOIN address_house AS house ON param_value.hid=house.id");
        sb.append(" LEFT JOIN address_street AS street ON house.street_id=street.id");
        where.append(" WHERE true ");
        if (this.parameters != null && this.parameters.trim().length() > 0) {
            where.append(" AND param_value.param_id in ( ").append(this.parameters).append(")");
        }
        if (pod >= 0) {
            where.append(" AND param_value.pod=").append(pod);
        }
        where.append(Utils.notEmptyString((String)flat) ? " AND param_value.flat REGEXP ?" : "");
        where.append(Utils.notEmptyString((String)room) ? " AND param_value.room REGEXP ?" : "");
        if (houseId > 0) {
            where.append(" AND param_value.hid=").append(houseId);
        } else {
            if (city > 0) {
                where.append(" AND street.cityid=").append(city);
            }
            if (street > 0) {
                where.append(" AND house.street_id=").append(street);
            }
            if (house > 0) {
                where.append(" AND house.house=").append(house);
            }
            if (Utils.notBlankString((String)frac)) {
                where.append(" AND ( house.frac=?");
                if (frac.length() > 1 && frac.startsWith("/")) {
                    where.append(" OR house.frac=?");
                }
                where.append(" )");
            }
        }
        this.addUserPermission(sb, new StringBuilder(), where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        sb.append(this.page.sqlLimit());
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString(), 1);){
            int index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            if (Utils.notEmptyString((String)flat)) {
                ps.setString(index++, "^[^[:digit:]]*" + flat + "[^[:digit:]]*$");
            }
            if (Utils.notBlankString((String)room)) {
                ps.setString(index++, "^[^[:digit:]]*" + room + "[^[:digit:]]*$");
            }
            if (houseId < 1 && Utils.notBlankString((String)frac)) {
                ps.setString(index++, frac);
                if (frac.length() > 1 && frac.startsWith("/")) {
                    ps.setString(index++, frac.substring(1));
                }
            }
            this.executeQuery1(contracts, ps);
        }
        this.records = ServerUtils.foundRows(this.con);
    }

    private void selectForTypeId(Element contracts) throws SQLException {
        int index;
        String id = this.getParameter("parameter");
        StringBuilder sb = new StringBuilder(150);
        StringBuilder count = new StringBuilder(150);
        StringBuilder where = new StringBuilder(100);
        sb.append("SELECT DISTINCT contract.id, concat( contract.title, ' [ ', contract.comment, ' ] ', object.title ) ");
        sb.append("FROM contract LEFT JOIN object ON contract.id=object.cid ");
        count.append("SELECT COUNT(DISTINCT object.id) FROM contract LEFT JOIN object ON contract.id=object.cid ");
        where.append(" WHERE object.id = ");
        where.append(id);
        where.append(this.filter);
        this.addUserPermission(sb, count, where);
        sb.append((CharSequence)where);
        sb.append(" ORDER BY contract.title");
        if (this.page.getPageSize() > 0) {
            sb.append(this.page.sqlLimit());
        }
        count.append((CharSequence)where);
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            this.executeQuery1(contracts, ps);
        }
        ps = this.con.prepareStatement(count.toString());
        try {
            index = 1;
            if (!this.showClosed) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)new Date()));
            }
            this.executeQuery2(ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void executeQuery1(Element element, PreparedStatement ps) throws SQLException {
        try (ResultSet rs = ps.executeQuery();){
            boolean comment = false;
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!"comment".equals(metaData.getColumnName(i))) continue;
                comment = true;
                break;
            }
            while (rs.next()) {
                Element itemElement = this.createElement(element, "item");
                itemElement.setAttribute("id", rs.getString(1));
                itemElement.setAttribute("title", rs.getString(2));
                if (!comment) continue;
                itemElement.setAttribute("comment", rs.getString("comment"));
            }
        }
    }

    private void executeQuery2(PreparedStatement ps) throws SQLException {
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                this.records = rs.getInt(1);
            }
        }
    }

    private void addUserPermission(StringBuilder sb, StringBuilder count, StringBuilder where) {
        Optional<User> userOpt = PermissionOfRoles.getUserById(this.userId);
        if (userOpt.isEmpty()) {
            return;
        }
        User user = userOpt.get();
        if (user.getContractCid() > 0 && user.getContractPid() > 0) {
            sb.append(" LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
            where.append(" AND par.pid=");
            where.append(user.getContractPid());
            where.append(" AND par.val=");
            where.append(user.getContractCid());
            if (count != null) {
                count.append(" LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
            }
        }
        sb.append(" LEFT JOIN contract_label_link AS labels ON contract.id=labels.contract_id ");
        if (count != null) {
            count.append(" LEFT JOIN contract_label_link AS labels ON contract.id=labels.contract_id ");
        }
        ContractDao.addLabelAndDomainFilter(where, user);
    }
}

