/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroupPrice;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class LicenseTariffGroupPriceDao
extends AbstractIdDao<LicenseTariffGroupPrice> {
    public LicenseTariffGroupPriceDao(Connection con, int moduleId) {
        super(con, moduleId, "lic_tariff_group_price");
    }

    public List<LicenseTariffGroupPrice> list(int productId) throws SQLException {
        return this.listImpl(null, "product_id=?", "id", new Object[]{productId});
    }

    protected LicenseTariffGroupPrice getFromRS(ResultSet rs) throws SQLException {
        LicenseTariffGroupPrice licenseTariffGroupPrice = new LicenseTariffGroupPrice(rs.getInt("id")).setProductId(rs.getInt("product_id")).setTariffGroupId(rs.getInt("tariff_group_id")).setTariffRangeId(rs.getInt("tariff_range_id")).setUnlimCost(rs.getBigDecimal("unlim_cost"));
        this.fromRanges(rs.getString("ranges"), licenseTariffGroupPrice);
        return licenseTariffGroupPrice;
    }

    protected void updateImpl(LicenseTariffGroupPrice licenseTariffGroupPrice) throws SQLException {
        String querySet = "product_id=?, tariff_group_id=?, tariff_range_id=?, ranges=?, unlim_cost=?";
        try (PreparedStatement ps = this.prepareStatement((Id)licenseTariffGroupPrice, querySet);){
            int index = 1;
            ps.setInt(index++, licenseTariffGroupPrice.getProductId());
            ps.setInt(index++, licenseTariffGroupPrice.getTariffGroupId());
            ps.setInt(index++, licenseTariffGroupPrice.getTariffRangeId());
            ps.setString(index++, this.toRanges(licenseTariffGroupPrice));
            ps.setBigDecimal(index++, licenseTariffGroupPrice.getUnlimCost());
            this.executeUpdate((Id)licenseTariffGroupPrice, index, ps);
        }
    }

    private void fromRanges(String ranges, LicenseTariffGroupPrice licenseTariffGroupPrice) {
        if (Utils.notBlankString((String)ranges)) {
            String[] rangeArray;
            for (String range : rangeArray = ranges.split(";")) {
                String[] rangeCost = range.split("=");
                if (rangeCost.length != 2) continue;
                licenseTariffGroupPrice.getRangeValue().add(Utils.parseInt((String)rangeCost[0]));
                licenseTariffGroupPrice.getRangeCost().add(Utils.parseBigDecimal((String)rangeCost[1], (BigDecimal)BigDecimal.ZERO));
            }
        }
    }

    private String toRanges(LicenseTariffGroupPrice licenseTariffGroupPrice) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < licenseTariffGroupPrice.getRangeValue().size(); ++index) {
            Integer range = (Integer)licenseTariffGroupPrice.getRangeValue().get(index);
            BigDecimal cost = (BigDecimal)licenseTariffGroupPrice.getRangeCost().get(index);
            builder.append(builder.length() > 0 ? ";" : "");
            builder.append(range).append("=").append(cost.toPlainString());
        }
        return builder.toString();
    }
}

