/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductHistoryDao;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class MegafonUtils {
    private static final Logger log = LogManager.getLogger();

    public static void addPaymentForActivateOption(ServerContext context, MegafonApiClient apiClient, MegafonOption option, MegafonContractProduct contractProduct) {
        MegafonUtils.addPaymentForActivateOption(context.getModuleId(), apiClient, option, contractProduct);
    }

    public static void addPaymentForActivateOption(int moduleId, MegafonApiClient apiClient, MegafonOption option, MegafonContractProduct contractProduct) {
        BigDecimal price = option.getOptionType().equals((Object)MegafonOptionType.PROLONGATE) ? MegafonUtils.defineCorrectProductPrice(option.getPrice()) : option.getPrice();
        MegafonUtils.addPaymentForActivate(moduleId, apiClient, contractProduct, price, option.getProductOfferingId());
    }

    public static void addPaymentForActivateProduct(ServerContext context, MegafonApiClient megafonClient, MegafonProduct product, MegafonContractProduct contractProduct) {
        MegafonUtils.addPaymentForActivate(context.getModuleId(), megafonClient, contractProduct, MegafonUtils.defineCorrectProductPrice(BigDecimal.valueOf(product.getPrice())), product.getProductOfferingId());
    }

    public static void addPaymentForActivateProduct(int moduleId, MegafonApiClient megafonClient, MegafonProduct product, MegafonContractProduct contractProduct) {
        MegafonUtils.addPaymentForActivate(moduleId, megafonClient, contractProduct, MegafonUtils.defineCorrectProductPrice(BigDecimal.valueOf(product.getPrice())), product.getProductOfferingId());
    }

    private static void addPaymentForActivate(int moduleId, MegafonApiClient megafonClient, MegafonContractProduct contractProduct, BigDecimal price, String productOfferingId) {
        String msisdn = MegafonUtils.defineCorrectMSISDN(contractProduct);
        log.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0430 MSISDN={}", (Object)msisdn);
        BigDecimal currentBalance = MegafonUtils.getCurrentBalanceForMSISDN(megafonClient, msisdn);
        log.debug("MSISDN= {}, \u0411\u0430\u043b\u0430\u043d\u0441 \u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d\u0435= {}, \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430={}", (Object)msisdn, (Object)currentBalance, (Object)price);
        if (currentBalance.compareTo(price) <= 0) {
            BigDecimal diff = price.subtract(currentBalance);
            log.debug("\u041d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 msisdn={} \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 productOfferingId={} \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 = {}", (Object)msisdn, (Object)productOfferingId, (Object)diff);
            MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(moduleId);
            kassaApiClient.addPayment(contractProduct.getContractId(), msisdn, diff, "");
        }
    }

    public static BigDecimal getCurrentBalanceForMSISDN(MegafonApiClient megafonClient, String msisdn) {
        return new BigDecimal(Utils.maskBlank((String)megafonClient.getCustomersInfo(msisdn).optJSONObject("balances").optString("currentBalance"), (String)"0"));
    }

    public static String defineCorrectMSISDN(MegafonContractProduct contractProduct) {
        return Utils.isBlankString((String)contractProduct.getAdditionalMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
    }

    public static BigDecimal defineCorrectProductPrice(BigDecimal productPrice) {
        LocalDate now = LocalDate.now();
        int dayOfMonth = now.getDayOfMonth();
        if (dayOfMonth == 1) {
            return productPrice;
        }
        int remainingDays = now.lengthOfMonth() - dayOfMonth + 1;
        return productPrice.divide(BigDecimal.valueOf(30L), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(remainingDays));
    }

    public static void sendAlarm(String header, String msg) {
        long millis = System.currentTimeMillis();
        String key = "Megafon_" + header;
        if (AlarmSender.needAlarmSend((String)key, (long)millis, (long)10000L)) {
            AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, header, msg), (long)millis);
        }
    }

    public static void npayServiceAdd(ModuleSetup moduleSetup, ServerContext context, int npayServiceId, IdTitle productOrOption, MegafonContractProduct megafonContractProduct, int npayServiceEntityId) throws Exception {
        NPayService npayService = (NPayService)context.getService(NPayService.class, MegafonUtils.getNpayMidOrThrow(moduleSetup));
        Service service = MegafonUtils.getNpayServiceOrThrow(moduleSetup, npayServiceId);
        ServiceObject serviceObject = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, context.getModuleId(), npayServiceEntityId, true, new Date()).stream().filter(so -> so.getServiceId() == service.getId()).findAny().orElse(null);
        if (serviceObject != null) {
            String error = String.format("\u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0430\u0431\u043e\u043d.\u043f\u043b\u0430\u0442\u044b \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 cid=%s, \u0437\u0430 productId=%s \u0431\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430 \u0434\u043b\u044f megafonContractProduct ID=%s, MSISDN=%s", megafonContractProduct.getContractId(), megafonContractProduct.getProductId(), megafonContractProduct.getId(), MegafonUtils.defineCorrectMSISDN(megafonContractProduct));
            log.error(error);
            MegafonUtils.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430!", error);
        }
        serviceObject = new ServiceObject();
        serviceObject.setServiceId(service.getId());
        serviceObject.setContractId(megafonContractProduct.getContractId());
        serviceObject.setCol(BigDecimal.ONE);
        serviceObject.setDate1(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getStartTime()));
        serviceObject.setDate2(megafonContractProduct.getEndTime() != null ? TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getEndTime()) : null);
        serviceObject.setComment(String.format("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0434\u0443\u043a\u0442: ID=%s, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435=%s", productOrOption.getId(), productOrOption.getTitle()));
        serviceObject.setEntityId(npayServiceEntityId);
        log.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d.\u043f\u043b\u0430\u0442\u044b. cid={}, serviceId={}", (Object)megafonContractProduct.getContractId(), (Object)service.getId());
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
    }

    public static void npayServiceAdd(ModuleSetup moduleSetup, ServerContext context, int npayServiceId, IdTitle productOrOption, MegafonContractProduct megafonContractProduct) throws Exception {
        MegafonUtils.npayServiceAdd(moduleSetup, context, npayServiceId, productOrOption, megafonContractProduct, megafonContractProduct.getId());
    }

    public static void removeNpayService(ModuleSetup moduleSetup, ServerContext context, int npayServiceId, MegafonContractProduct megafonContractProduct, int npayServiceEntityId) throws Exception {
        int npayMid = MegafonUtils.getNpayMidOrThrow(moduleSetup);
        NPayService npayService = (NPayService)context.getService(NPayService.class, npayMid);
        List serviceObjectList = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, npayMid, npayServiceEntityId, false, new Date());
        List<ServiceObject> serviceObjects = serviceObjectList.stream().filter(so -> so.getServiceId() == npayServiceId).toList();
        if (Utils.isEmptyCollection(serviceObjects)) {
            throw new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=%s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 serviceId=%s", megafonContractProduct.getContractId(), npayServiceId));
        }
        ServiceObject serviceObject = serviceObjects.stream().filter(so -> so.getEntityId() == npayServiceEntityId).findFirst().orElseThrow(() -> new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=%s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 entityId=%s", megafonContractProduct.getContractId(), npayServiceEntityId)));
        log.debug("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430, \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u041c\u0435\u0433\u0430\u0444\u043e\u043d, \u0441\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. cid={}, serviceId={}", (Object)megafonContractProduct.getContractId(), (Object)npayServiceId);
        serviceObject.setDate2(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getEndTime()));
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
    }

    private static Service getNpayServiceOrThrow(ModuleSetup setup, int npayServiceId) throws Exception {
        return ModuleCache.getInstance().getModuleServicesList(MegafonUtils.getNpayMidOrThrow(setup)).stream().filter(s -> s.getId() == npayServiceId).findFirst().orElseThrow();
    }

    public static int getNpayMidOrThrow(ModuleSetup moduleSetup) throws BGException {
        int npayMid = moduleSetup.getInt("npay.mid", -1);
        if (npayMid > 0) {
            return npayMid;
        }
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            if (!"npay".equals(module.getName())) continue;
            npayMid = module.getId();
        }
        if (npayMid <= 0) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c Npay");
        }
        return npayMid;
    }

    public static void contractAddCharge(ServerContext context, ModuleSetup moduleSetup, int contractId, BigDecimal summa, String msg) {
        try {
            ChargeService chargeService = (ChargeService)context.getService(ChargeService.class, 0);
            int chargeTypeId = Utils.parseInt((String)moduleSetup.get("chargeType"), (int)0);
            if (chargeTypeId <= 0) {
                chargeTypeId = MegafonUtils.createMegafonChargeType(chargeService);
                moduleSetup.set("chargeType", String.valueOf(chargeTypeId));
            }
            Charge charge = new Charge();
            charge.setContractId(contractId);
            charge.setSum(summa);
            charge.setUserId(0);
            charge.setTypeId(chargeTypeId);
            charge.setComment(msg);
            charge.setDate(new Date());
            charge.setTimeChange(new Date());
            chargeService.chargeUpdate(charge);
            context.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int createMegafonChargeType(ChargeService chargeService) throws Exception {
        ChargeType type = new ChargeType();
        type.setTitle("\u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        type.setType(0);
        type.setEditable(true);
        type.setPayback(false);
        return chargeService.chargeTypeUpdate(type);
    }

    public static void saveContractProductHistoryEntry(Connection connection, int moduleId, MegafonContractProduct contractProduct, MegafonContractProductStatus oldStatus, String reason) {
        MegafonUtils.saveContractProductHistoryEntry(connection, moduleId, contractProduct, oldStatus, reason, 0);
    }

    public static void saveContractProductHistoryEntry(Connection connection, int moduleId, MegafonContractProduct contractProduct, MegafonContractProductStatus oldStatus, String reason, int megafonOptionId) {
        MegafonContractProductHistory history = new MegafonContractProductHistory();
        history.setContractId(contractProduct.getContractId());
        history.setProductId(contractProduct.getProductId());
        history.setTitle(reason);
        history.setNewProductStatus(contractProduct.getStatus());
        history.setOldProductStatus(oldStatus);
        history.setChangeDate(LocalDateTime.now());
        history.setUserId(0);
        history.setMsisdn(contractProduct.getMsisdn());
        history.setAdditionalMsisdn(contractProduct.getAdditionalMsisdn());
        history.setMegafonOptionId(megafonOptionId);
        try {
            MegafonContractProductHistoryDao historyDao = new MegafonContractProductHistoryDao(connection, moduleId);
            historyDao.update(history);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean allowBalance(Connection connection, BigDecimal price, int contractId) {
        try (BalanceUtils bu = new BalanceUtils(connection);){
            boolean bl;
            try (ContractDao contractDao = new ContractDao(connection, 0);){
                BigDecimal resultBalance = bu.getBalance(LocalDate.now(), contractId).subtract(((Contract)contractDao.get(contractId)).getBalanceLimit());
                bl = resultBalance.compareTo(price) >= 0;
            }
            return bl;
        }
        catch (BGException e) {
            throw new RuntimeException(e);
        }
    }
}

