/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountMode;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseTariffMode;
import ru.bitel.common.model.Id;

public class SmartHouseAccountTypeDao
extends AbstractIdDao<SmartHouseAccountType> {
    public SmartHouseAccountTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_account_type");
    }

    public List<SmartHouseAccountType> list() throws SQLException {
        return this.listImpl(null, null, "title", new Object[0]);
    }

    protected SmartHouseAccountType getFromRS(ResultSet rs) throws SQLException {
        return new SmartHouseAccountType().setId(rs.getInt("id")).setTitle(rs.getString("title")).setMode(SmartHouseAccountMode.getSmartHouseAccountMode((int)rs.getInt("mode"))).setHandlerClass(rs.getString("handler_class")).setUsed(rs.getBoolean("used")).setComment(rs.getString("comment")).setTariffMode(SmartHouseTariffMode.valueOf((String)rs.getString("tariff_mode")));
    }

    protected void updateImpl(SmartHouseAccountType accountType) throws SQLException {
        String querySet = "title=?, mode=?, handler_class=?, used=?, comment=?, tariff_mode=?";
        try (PreparedStatement ps = this.prepareStatement((Id)accountType, querySet);){
            int index = 1;
            ps.setString(index++, accountType.getTitle());
            ps.setInt(index++, accountType.getMode().getMode());
            ps.setString(index++, accountType.getHandlerClass());
            ps.setBoolean(index++, accountType.isUsed());
            ps.setString(index++, accountType.getComment());
            ps.setString(index++, accountType.getTariffMode().toString());
            this.executeUpdate((Id)accountType, index, ps);
        }
    }
}

