/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class VoiceDestinationPanel
extends BGUPanel {
    private static final String SET_DATA_ACTION = "setData";
    private static final VoiceOperator NOT_SELECTED_OPERATOR_ITEM = new VoiceOperator(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
    private BGUTable destinationTable;
    private DestinationTablModel destinationTableModel;
    private BGUComboBox<VoiceOperator> operatorFilter;
    private List<VoiceOperator> operatorList = new ArrayList<VoiceOperator>();
    private BGTextField titleFilter;
    private BGControlPanelPages pagePanel;
    private JLabel recordCountLabel;

    public VoiceDestinationPanel() {
        super((LayoutManager)new GridBagLayout());
    }

    protected void jbInit() throws Exception {
        this.destinationTableModel = new DestinationTablModel();
        this.destinationTable = new BGUTable((TableModel)((Object)this.destinationTableModel));
        this.destinationTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && VoiceDestinationPanel.this.destinationTable.pointOnSelectRows(e.getPoint())) {
                    VoiceDestinationPanel.this.getPopupMenu().show((Component)VoiceDestinationPanel.this.destinationTable, e.getX(), e.getY());
                }
            }
        });
        this.titleFilter = new BGTextField(20);
        this.titleFilter.getDocument().addDocumentListener(new TitleDocumentListener());
        this.operatorFilter = new BGUComboBox();
        this.operatorFilter.addActionListener(l -> this.performAction(SET_DATA_ACTION));
        this.pagePanel = new BGControlPanelPages();
        this.pagePanel.addPropertyChangeListener(l -> this.performAction(SET_DATA_ACTION));
        this.recordCountLabel = new JLabel();
        int gridx = 0;
        JPanel navigationPanel = new JPanel(new GridBagLayout());
        navigationPanel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.operatorFilter, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        navigationPanel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.titleFilter, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        navigationPanel.add((Component)this.recordCountLabel, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)navigationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)this.destinationTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.destinationTable, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            VoiceOperator selectedItem = (VoiceOperator)this.operatorFilter.getSelectedItem();
            VoiceOperatorService operatorService = (VoiceOperatorService)((ClientContext)this.getContext()).getWebService(VoiceOperatorService.class);
            this.operatorList = operatorService.voiceOperatorList();
            DefaultComboBoxModel<VoiceOperator> operatorFilterModel = new DefaultComboBoxModel<VoiceOperator>(this.operatorList.toArray(new VoiceOperator[0]));
            operatorFilterModel.insertElementAt(NOT_SELECTED_OPERATOR_ITEM, 0);
            this.operatorFilter.setModel(operatorFilterModel);
            this.operatorFilter.setSelectedItem(selectedItem != null ? selectedItem : Integer.valueOf(0));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            boolean showMainPanel;
            VoiceOperator oper = (VoiceOperator)this.operatorFilter.getSelectedItem();
            boolean bl = showMainPanel = oper.getId() == 0 || oper.isUseCustomGeoDict();
            if (!showMainPanel) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e!");
                return;
            }
            VoiceDestination currentDestination = new VoiceDestination();
            new VoiceDestinationEditor("\u041d\u043e\u0432\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", currentDestination).open();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            VoiceDestination currentDestination = (VoiceDestination)this.destinationTableModel.getSelectedRow();
            if (currentDestination == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            new VoiceDestinationEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f", currentDestination).open();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            List selectedDestinationList = this.destinationTableModel.getSelectedRows();
            if (selectedDestinationList == null || selectedDestinationList.isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 (\u044f) \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            String message = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 " + ((VoiceDestination)selectedDestinationList.get(0)).getTitle();
            if (selectedDestinationList.size() > 1) {
                message = message + ", " + ((VoiceDestination)selectedDestinationList.get(1)).getTitle() + ", ...";
            }
            message = message + "?";
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                VoiceService voiceService = (VoiceService)((ClientContext)this.getContext()).getWebService(VoiceService.class);
                voiceService.voiceDestinationDelete(Utils.getIdList((Collection)selectedDestinationList));
                this.performAction(SET_DATA_ACTION);
            }
        });
        new AbstractBGUPanel.DefaultAction(SET_DATA_ACTION, "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                boolean showMainPanel;
                VoiceOperator voiceOperator = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
                if (voiceOperator == null) {
                    return;
                }
                boolean bl = showMainPanel = voiceOperator.getId() == 0 || voiceOperator.isUseCustomGeoDict();
                if (!showMainPanel) {
                    VoiceDestinationPanel.this.destinationTableModel.setData(new ArrayList());
                    VoiceDestinationPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
                    VoiceDestinationPanel.this.pagePanel.setPageIndex(1);
                    return;
                }
                int operator = ((VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem()).getId();
                String title = VoiceDestinationPanel.this.titleFilter.getText();
                VoiceService voiceService = (VoiceService)((ClientContext)VoiceDestinationPanel.this.getContext()).getWebService(VoiceService.class);
                SearchResult data = voiceService.voiceDestinationList(operator, title, VoiceDestinationPanel.this.pagePanel.getPage());
                VoiceDestinationPanel.this.destinationTableModel.setData(Optional.ofNullable(data.getList()).orElse(new ArrayList()));
                VoiceDestinationPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + data.getPage().getRecordCount());
                VoiceDestinationPanel.this.pagePanel.setPage(data.getPage());
            }
        };
        new AbstractBGUPanel.DefaultAction("menu.used", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceDestination voiceDestination = (VoiceDestination)VoiceDestinationPanel.this.destinationTableModel.getSelectedRow();
                if (voiceDestination != null) {
                    new DectinationUsedDialog("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f " + voiceDestination.getGuiTitle(), voiceDestination).open();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("menu.replace", "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435..."){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceDestination voiceDestination = (VoiceDestination)VoiceDestinationPanel.this.destinationTableModel.getSelectedRow();
                if (voiceDestination != null) {
                    new DectinationReplaceDialog("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 - " + voiceDestination.getGuiTitle(), voiceDestination).open();
                }
            }
        };
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getActionMap().get("menu.used"));
            this.popupMenu.add(this.getActionMap().get("menu.replace"));
        }
        return this.popupMenu;
    }

    class DestinationTablModel
    extends BGTableModel<VoiceDestination> {
        public DestinationTablModel() {
            super(DestinationTablModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", -1, -1, -1, "operatorId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447. (\u043a\u043e\u0434\u044b/\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b)", 200, 200, 200, "linkCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }

        public Object getValue(VoiceDestination val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("operatorId".equals(identifier)) {
                return VoiceDestinationPanel.this.operatorList.stream().filter(a -> a.getId() == val.getOperatorId()).findFirst().map(a -> a.getTitle()).orElse("");
            }
            if ("linkCount".equals(identifier)) {
                return val.getCodeLinkCount() + " / " + val.getRangeLinkCount();
            }
            return super.getValue((Object)val, column);
        }
    }

    private class TitleDocumentListener
    implements DocumentListener {
        private TitleDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.process(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.process(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.process(e);
        }

        private void process(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.getLength() <= 0 || doc.getLength() >= 2) {
                VoiceDestinationPanel.this.performAction(VoiceDestinationPanel.SET_DATA_ACTION);
            }
        }
    }

    class VoiceDestinationEditor
    extends BGEditorDialog<VoiceDestination> {
        private BGTextField destinationTitle;

        public VoiceDestinationEditor(String title, VoiceDestination data) {
            super(title, (Object)data);
            this.destinationTitle = new BGTextField(40);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.destinationTitle, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.destinationTitle.setText(((VoiceDestination)this.data).getTitle());
        }

        public boolean doApply() throws Exception {
            String title = this.destinationTitle.getText();
            if (Utils.isBlankString((String)title)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f!");
                return false;
            }
            ((VoiceDestination)this.data).setTitle(title);
            VoiceOperator operator = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
            if (operator != null && !operator.equals((Object)NOT_SELECTED_OPERATOR_ITEM)) {
                ((VoiceDestination)this.data).setOperatorId(operator.getId());
            }
            ((VoiceService)((ClientContext)VoiceDestinationPanel.this.getContext()).getWebService(VoiceService.class)).voiceDestinationUpdate((VoiceDestination)this.data);
            VoiceDestinationPanel.this.performAction(VoiceDestinationPanel.SET_DATA_ACTION);
            return true;
        }
    }

    class DectinationReplaceDialog
    extends BGEditorDialog<VoiceDestination> {
        private BGUList<IdTitle> toDestinationList;

        public DectinationReplaceDialog(String title, VoiceDestination data) {
            super(title, (Object)data);
            this.toDestinationList = new BGUList();
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.toDestinationList, (int)600, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            try {
                int operator = ((VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem()).getId();
                this.toDestinationList.setData(((VoiceService)((ClientContext)VoiceDestinationPanel.this.getContext()).getWebService(VoiceService.class)).voiceDestinationList(operator, null, null).getList().stream().filter(a -> a.getId() != ((VoiceDestination)this.data).getId()).map(IdTitle::toIdTitle).toList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            IdTitle toDestination = (IdTitle)this.toDestinationList.getSelectedValue();
            if (toDestination == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
                return false;
            }
            try {
                ((VoiceService)((ClientContext)VoiceDestinationPanel.this.getContext()).getWebService(VoiceService.class)).voiceDestinationReplace(((VoiceDestination)this.data).getId(), toDestination.getId());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            VoiceDestinationPanel.this.performAction(VoiceDestinationPanel.SET_DATA_ACTION);
            return true;
        }
    }

    class DectinationUsedDialog
    extends BGEditorDialog<VoiceDestination> {
        private JTextArea txt;

        public DectinationUsedDialog(String title, VoiceDestination data) {
            super(title, (Object)data);
            this.txt = new JTextArea(15, 50);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JScrollPane(this.txt), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            try {
                List codes = ((VoiceService)((ClientContext)VoiceDestinationPanel.this.getContext()).getWebService(VoiceService.class)).voiceGeographicCodeByDestinationId(((VoiceDestination)this.data).getId());
                StringBuffer buf = new StringBuffer();
                codes.forEach(a -> buf.append(a.toString()).append("\n"));
                this.txt.setText(buf.toString());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }
}

