/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.bean.api;

import bitel.billing.server.contract.bean.ContractUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.AgentAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDescAPI;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public class AVDesc4
extends BGLogger
implements AVDescAPI {
    private static final String ADD_CUSTOMER = "add.ds";
    private static final String INFO_CUSTOMER = "info.ds";
    private static final String UPDATE_CUSTOMER = "change.ds";
    private Connection con;
    private int moduleId;
    private AgentAVDManager agentManager = null;
    private int httpTimeout = 30000;
    private String urlString = null;
    private String userName = null;
    private String userPswd = null;
    private String encoding = null;
    private SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMddHHmmss");

    public AVDesc4(Connection con, ParameterMap moduleSetup, int moduleId, AgentAVDManager agentManager) {
        this.con = con;
        this.moduleId = moduleId;
        this.agentManager = agentManager;
        this.urlString = moduleSetup.get("drweb.api.url", null);
        this.userName = moduleSetup.get("drweb.api.user", null);
        this.userPswd = moduleSetup.get("drweb.api.pswd", null);
        this.encoding = moduleSetup.get("drweb.api.encoding", null);
        this.httpTimeout = moduleSetup.getInt("drweb.api.timeout", 30000);
    }

    @Override
    public AgentAVD getAgentFromAVD(int contractId, String groupTitle, Date expires) throws BGException {
        AgentAVD agent = null;
        try {
            String answer;
            HashMap<String, String> params = new HashMap<String, String>();
            String name = this.getName(contractId);
            params.put("name", name);
            params.put("expires", this.yyyyMMdd.format(expires == null ? new Date() : expires));
            if (groupTitle != null) {
                params.put("rate", groupTitle);
            }
            if ((answer = this.transferData(ADD_CUSTOMER, params)) == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            Document doc = XMLUtils.parseDocument((String)answer);
            int errorCode = this.checkError(doc);
            if (errorCode != 0) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430" + XMLUtils.selectText((Node)doc, (String)"//error/message/text()"));
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            agent = new AgentAVD();
            agent.setAgentUUID(XMLUtils.selectText((Node)doc, (String)"//station/@id"));
            agent.setName(name);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
        return agent;
    }

    @Override
    public void sinchronizeAgent(int contractId) {
        try {
            for (AgentAVD agent : contractId < 1 ? this.agentManager.getListAll() : this.agentManager.getListById(contractId)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", agent.getAgentUUID());
                String answer = this.transferData(INFO_CUSTOMER, params);
                if (answer == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
                }
                Document doc = XMLUtils.parseDocument((String)answer);
                int errorCode = this.checkError(doc);
                if (errorCode == 0) {
                    agent.setName(XMLUtils.selectText((Node)doc, (String)"//stations/station/@name"));
                    this.agentManager.updateNotLog(agent);
                    continue;
                }
                if (errorCode != 17 && errorCode != 6) continue;
                this.getLogger().info("delete agent [" + agent.getId() + "](" + agent.getAgentUUID() + ")");
                this.agentManager.delete(agent.getId());
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Override
    public void prolongAgentOnAVD(AgentAVD agent, Date date) throws BGException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", agent.getAgentUUID());
            params.put("expires", date == null ? "0" : this.yyyyMMdd.format(date));
            String answer = this.transferData(UPDATE_CUSTOMER, params);
            if (answer == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430 (\u043d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430)");
            }
            Document doc = XMLUtils.parseDocument((String)answer);
            int errorCode = this.checkError(doc);
            if (errorCode != 0) {
                this.getLogger().error("errorCode = " + errorCode);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
    }

    @Override
    public void blockOnAVD(AgentAVD agent, Date dateFrom, Date dateTo) throws BGException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", agent.getAgentUUID());
            SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
            params.put("block-begin", yyyyMMdd.format(dateFrom));
            params.put("block-end", yyyyMMdd.format(dateTo));
            String answer = this.transferData(UPDATE_CUSTOMER, params);
            if (answer == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
            int errorCode = this.checkError(doc);
            if (errorCode != 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0430\u0433\u0435\u043d\u0442\u0430");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
    }

    @Override
    public void changeTariffOnAVD(AgentAVD agent, String groupTitle) throws BGException {
        try {
            String answer;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", agent.getAgentUUID());
            if (groupTitle != null) {
                params.put("rate", groupTitle);
            }
            if ((answer = this.transferData(UPDATE_CUSTOMER, params)) == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430");
            }
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
            int errorCode = this.checkError(doc);
            if (errorCode != 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
    }

    private String transferData(String command, Map<String, String> params) throws Exception {
        StringBuilder paramStr = new StringBuilder();
        for (String key : params.keySet()) {
            paramStr.append(this.urlEncode(key));
            paramStr.append("=");
            paramStr.append(this.urlEncode(params.get(key)));
            paramStr.append("&");
        }
        String url = this.urlString + command + (String)(paramStr.length() == 0 ? "" : "?" + paramStr.toString());
        this.getLogger().debug("url={}", (Object)url);
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).header("Content-type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.encodeUTF8((String)(this.userName + ":" + this.userPswd))).build();
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(this.httpTimeout)).build();
        try {
            String result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("result={}", (Object)result);
            }
            return result;
        }
        catch (Exception ex) {
            this.logError(ex);
            return null;
        }
    }

    private String urlEncode(String inStr) {
        String outStr = "";
        if (inStr != null) {
            try {
                outStr = URLEncoder.encode(inStr, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return outStr;
    }

    private String getName(int contractId) throws SQLException {
        AgentAVDManager agentManager = new AgentAVDManager(this.con, this.moduleId);
        return new ContractUtils(this.con).getContractTitle(contractId, false) + "_" + (agentManager.getAgentCount(contractId) + 1);
    }

    private int checkError(Document doc) throws Exception {
        String codeElementTextContent = XMLUtils.selectText((Node)doc, (String)"//error/errno/text()");
        if (Utils.isEmptyString((String)codeElementTextContent)) {
            return 0;
        }
        return Integer.parseInt(codeElementTextContent);
    }
}

